/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.resources.team;

import java.util.HashSet;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceRuleFactory;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.MultiRule;

public class ResourceRuleFactory
implements IResourceRuleFactory {
    private final IWorkspace workspace = ResourcesPlugin.getWorkspace();

    protected ResourceRuleFactory() {
    }

    public final ISchedulingRule buildRule() {
        return this.workspace.getRoot();
    }

    public ISchedulingRule charsetRule(IResource iResource) {
        if (iResource.getType() == 8) {
            return null;
        }
        return iResource.getProject();
    }

    public ISchedulingRule copyRule(IResource iResource, IResource iResource2) {
        return this.parent(iResource2);
    }

    public ISchedulingRule createRule(IResource iResource) {
        return this.parent(iResource);
    }

    public ISchedulingRule deleteRule(IResource iResource) {
        return this.parent(iResource);
    }

    private boolean isReadOnly(IResource iResource) {
        ResourceAttributes resourceAttributes = iResource.getResourceAttributes();
        return resourceAttributes == null ? false : resourceAttributes.isReadOnly();
    }

    public final ISchedulingRule markerRule(IResource iResource) {
        return null;
    }

    public ISchedulingRule modifyRule(IResource iResource) {
        IPath iPath = iResource.getFullPath();
        if (iPath.segmentCount() == 2 && iPath.segment(1).equals(".project")) {
            return this.parent(iResource);
        }
        return iResource;
    }

    public ISchedulingRule moveRule(IResource iResource, IResource iResource2) {
        return MultiRule.combine((ISchedulingRule)this.parent(iResource), (ISchedulingRule)this.parent(iResource2));
    }

    protected final ISchedulingRule parent(IResource iResource) {
        switch (iResource.getType()) {
            case 4: 
            case 8: {
                return iResource;
            }
        }
        return iResource.getParent();
    }

    public ISchedulingRule refreshRule(IResource iResource) {
        return this.parent(iResource);
    }

    public ISchedulingRule validateEditRule(IResource[] iResourceArray) {
        if (iResourceArray.length == 0) {
            return null;
        }
        if (iResourceArray.length == 1) {
            return this.isReadOnly(iResourceArray[0]) ? this.parent(iResourceArray[0]) : null;
        }
        HashSet<ISchedulingRule> hashSet = new HashSet<ISchedulingRule>();
        int n = 0;
        while (n < iResourceArray.length) {
            if (this.isReadOnly(iResourceArray[n])) {
                hashSet.add(this.parent(iResourceArray[n]));
            }
            ++n;
        }
        if (hashSet.isEmpty()) {
            return null;
        }
        if (hashSet.size() == 1) {
            return (ISchedulingRule)hashSet.iterator().next();
        }
        ISchedulingRule[] iSchedulingRuleArray = hashSet.toArray(new ISchedulingRule[hashSet.size()]);
        return new MultiRule(iSchedulingRuleArray);
    }
}

