/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.tools.actionscript.ui;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.debug.ui.launchConfigurations.JavaLaunchShortcut;
import org.eclipse.jdt.internal.ui.util.MainMethodSearchEngine;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.swt.tools.actionscript.build.ActionScriptLaunchConfigurationDelegate;
import org.eclipse.swt.tools.actionscript.ui.ActionScriptUIPlugin;
import org.eclipse.swt.tools.actionscript.ui.Messages;
import org.eclipse.swt.widgets.Shell;

public class ActionScriptApplicationLaunchShortcut
extends JavaLaunchShortcut {
    protected ILaunchConfiguration createConfiguration(IType iType) {
        ILaunchConfiguration iLaunchConfiguration = null;
        ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy = null;
        try {
            ILaunchConfigurationType iLaunchConfigurationType = this.getConfigurationType();
            iLaunchConfigurationWorkingCopy = iLaunchConfigurationType.newInstance(null, this.getLaunchManager().generateUniqueLaunchConfigurationNameFrom(iType.getElementName()));
            iLaunchConfigurationWorkingCopy.setAttribute(ActionScriptLaunchConfigurationDelegate.ATTR_MAIN_TYPE_NAME, iType.getFullyQualifiedName());
            iLaunchConfigurationWorkingCopy.setAttribute(ActionScriptLaunchConfigurationDelegate.ATTR_PROJECT_NAME, iType.getJavaProject().getElementName());
            iLaunchConfigurationWorkingCopy.setAttribute("org.eclipse.swt.tools.actionscript.core.outputDirName", Messages.ActionScriptApplicationLaunchShortcut_0);
            iLaunchConfigurationWorkingCopy.setMappedResources(new IResource[]{iType.getUnderlyingResource()});
            iLaunchConfiguration = iLaunchConfigurationWorkingCopy.doSave();
        }
        catch (CoreException coreException) {
            MessageDialog.openError((Shell)ActionScriptUIPlugin.getActiveWorkbenchShell(), (String)Messages.ActionScriptApplicationLaunchShortcut_1, (String)coreException.getStatus().getMessage());
        }
        return iLaunchConfiguration;
    }

    protected IType[] findTypes(Object[] objectArray, IRunnableContext iRunnableContext) throws InterruptedException, CoreException {
        try {
            IType iType;
            if (objectArray.length == 1 && (iType = this.isMainMethod(objectArray[0])) != null) {
                return new IType[]{iType};
            }
            iType = this.getJavaElements(objectArray);
            MainMethodSearchEngine mainMethodSearchEngine = new MainMethodSearchEngine();
            int n = 1;
            IJavaSearchScope iJavaSearchScope = SearchEngine.createJavaSearchScope((IJavaElement[])iType, (int)(n |= 2));
            return mainMethodSearchEngine.searchMainMethods(iRunnableContext, iJavaSearchScope, 0);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw (CoreException)invocationTargetException.getTargetException();
        }
    }

    private IType isMainMethod(Object object) {
        IAdaptable iAdaptable;
        IJavaElement iJavaElement;
        if (object instanceof IAdaptable && (iJavaElement = (IJavaElement)(iAdaptable = (IAdaptable)object).getAdapter(IJavaElement.class)) != null && iJavaElement.getElementType() == 9) {
            try {
                IMethod iMethod = (IMethod)iJavaElement;
                if (iMethod.isMainMethod()) {
                    return iMethod.getDeclaringType();
                }
            }
            catch (JavaModelException javaModelException) {
                javaModelException.printStackTrace();
            }
        }
        return null;
    }

    private IJavaElement[] getJavaElements(Object[] objectArray) {
        ArrayList<IJavaElement> arrayList = new ArrayList<IJavaElement>(objectArray.length);
        int n = 0;
        while (n < objectArray.length) {
            IJavaElement iJavaElement;
            Object object = objectArray[n];
            if (object instanceof IAdaptable && (iJavaElement = (IJavaElement)((IAdaptable)object).getAdapter(IJavaElement.class)) != null) {
                IType iType;
                if (iJavaElement instanceof IMember && (iType = ((IMember)iJavaElement).getDeclaringType()) != null) {
                    iJavaElement = iType;
                }
                arrayList.add(iJavaElement);
            }
            ++n;
        }
        return arrayList.toArray(new IJavaElement[arrayList.size()]);
    }

    protected ILaunchConfigurationType getConfigurationType() {
        return this.getLaunchManager().getLaunchConfigurationType("org.eclipse.swt.tools.actionscript.core.actionscriptApplication");
    }

    protected String getEditorEmptyMessage() {
        return Messages.ActionScriptApplicationLaunchShortcut_2;
    }

    protected String getSelectionEmptyMessage() {
        return Messages.ActionScriptApplicationLaunchShortcut_3;
    }

    protected String getTypeSelectionTitle() {
        return Messages.ActionScriptApplicationLaunchShortcut_4;
    }

    private ILaunchManager getLaunchManager() {
        return DebugPlugin.getDefault().getLaunchManager();
    }
}

