/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.tools.actionscript.ui;

import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;

public class ActionScriptPropertyTester
extends PropertyTester {
    private static final String PROPERTY_HAS_MAIN = "hasMain";
    private static final String PROPERTY_IS_CONTAINER = "isContainer";

    public boolean test(Object object, String string, Object[] objectArray, Object object2) {
        if (PROPERTY_IS_CONTAINER.equals(string)) {
            IResource iResource;
            if (object instanceof IAdaptable && (iResource = (IResource)((IAdaptable)object).getAdapter(IResource.class)) != null) {
                return iResource instanceof IContainer;
            }
            return false;
        }
        IJavaElement iJavaElement = null;
        if (object instanceof IAdaptable && (iJavaElement = (IJavaElement)((IAdaptable)object).getAdapter(IJavaElement.class)) != null && !iJavaElement.exists()) {
            return false;
        }
        if (PROPERTY_HAS_MAIN.equals(string)) {
            return this.hasMain(iJavaElement);
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean hasMain(IJavaElement iJavaElement) {
        try {
            IType iType = this.getType(iJavaElement);
            if (iType == null) return false;
            if (!iType.exists()) return false;
            if (this.hasMainMethod(iType)) {
                return true;
            }
            IJavaElement[] iJavaElementArray = iType.getChildren();
            int n = 0;
            while (true) {
                if (n >= iJavaElementArray.length) {
                    return false;
                }
                if (this.hasMainInChildren(this.getType(iJavaElementArray[n]))) {
                    return true;
                }
                ++n;
            }
        }
        catch (JavaModelException javaModelException) {
            return false;
        }
        catch (CoreException coreException) {}
        return false;
    }

    private boolean hasMainMethod(IType iType) throws JavaModelException {
        IMethod[] iMethodArray = iType.getMethods();
        int n = 0;
        while (n < iMethodArray.length) {
            if (iMethodArray[n].isMainMethod()) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private IType getType(IJavaElement iJavaElement) {
        IType iType = null;
        if (iJavaElement instanceof ICompilationUnit) {
            iType = ((ICompilationUnit)iJavaElement).findPrimaryType();
        } else if (iJavaElement instanceof IClassFile) {
            iType = ((IClassFile)iJavaElement).getType();
        } else if (iJavaElement instanceof IType) {
            iType = (IType)iJavaElement;
        } else if (iJavaElement instanceof IMember) {
            iType = ((IMember)iJavaElement).getDeclaringType();
        }
        return iType;
    }

    private boolean hasMainInChildren(IType iType) throws CoreException {
        if (iType.isClass() & Flags.isStatic((int)iType.getFlags())) {
            if (this.hasMainMethod(iType)) {
                return true;
            }
            IJavaElement[] iJavaElementArray = iType.getChildren();
            int n = 0;
            while (n < iJavaElementArray.length) {
                if (iJavaElementArray[n].getElementType() == 7) {
                    return this.hasMainInChildren((IType)iJavaElementArray[n]);
                }
                ++n;
            }
        }
        return false;
    }
}

