/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.tools.actionscript.ui;

import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.launcher.DebugTypeSelectionDialog;
import org.eclipse.jdt.internal.debug.ui.launcher.MainMethodSearchEngine;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.tools.actionscript.ui.Messages;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public class DeployMainPage
extends WizardPage {
    Text fProjText;
    Text fMainText;
    IJavaProject project;
    IType[] types = null;
    private String projectName = null;
    private String mainTypeName = null;

    public DeployMainPage(String string, String string2, ImageDescriptor imageDescriptor) {
        super(string, string2, imageDescriptor);
    }

    public void createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        composite2.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(1808);
        gridData.horizontalSpan = 1;
        gridLayout.verticalSpacing = 0;
        composite2.setLayoutData((Object)gridData);
        this.createProjectEditor(composite2);
        this.createMainTypeEditor(composite2, Messages.DeployMainPage_0);
        this.setMessage(Messages.DeployMainPage_1);
        this.setPageComplete(this.isComplete());
        this.setControl((Control)composite2);
    }

    protected void createProjectEditor(Composite composite) {
        Font font = composite.getFont();
        Group group = new Group(composite, 0);
        group.setText(Messages.DeployMainPage_2);
        GridData gridData = new GridData(768);
        group.setLayoutData((Object)gridData);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        group.setLayout((Layout)gridLayout);
        group.setFont(font);
        this.fProjText = new Text((Composite)group, 2052);
        gridData = new GridData(768);
        this.fProjText.setLayoutData((Object)gridData);
        this.fProjText.setFont(font);
        this.fProjText.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                DeployMainPage.this.setPageComplete(DeployMainPage.this.isComplete());
            }
        });
        if (this.projectName != null) {
            this.fProjText.setText(this.projectName);
        }
        Button button = new Button((Composite)group, 8);
        button.setText(Messages.DeployMainPage_3);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                DeployMainPage.this.project = DeployMainPage.this.chooseJavaProject();
                if (DeployMainPage.this.project == null) {
                    return;
                }
                DeployMainPage.this.fProjText.setText(DeployMainPage.this.project.getElementName());
            }
        });
    }

    protected void createMainTypeEditor(Composite composite, String string) {
        Group group = new Group(composite, 0);
        group.setLayout((Layout)new GridLayout(2, false));
        group.setText(string);
        group.setFont(composite.getFont());
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 1;
        group.setLayoutData((Object)gridData);
        this.fMainText = new Text((Composite)group, 2052);
        this.fMainText.setFont(composite.getFont());
        gridData = new GridData(768);
        gridData.horizontalSpan = 1;
        this.fMainText.setLayoutData((Object)gridData);
        if (this.mainTypeName != null) {
            this.fMainText.setText(this.mainTypeName);
        }
        this.fMainText.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                DeployMainPage.this.setPageComplete(DeployMainPage.this.isComplete());
            }
        });
        Button button = new Button((Composite)group, 8);
        button.setText(Messages.DeployMainPage_4);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                IJavaProject iJavaProject = DeployMainPage.this.getJavaProject();
                IJavaElement[] iJavaElementArray = null;
                if (iJavaProject == null || !iJavaProject.exists()) {
                    IJavaModel iJavaModel = JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot());
                    if (iJavaModel != null) {
                        try {
                            iJavaElementArray = iJavaModel.getJavaProjects();
                        }
                        catch (JavaModelException javaModelException) {
                            JDIDebugUIPlugin.log((Throwable)javaModelException);
                        }
                    }
                } else {
                    iJavaElementArray = new IJavaElement[]{iJavaProject};
                }
                if (iJavaElementArray == null) {
                    iJavaElementArray = new IJavaElement[]{};
                }
                int n = 1;
                IJavaSearchScope iJavaSearchScope = SearchEngine.createJavaSearchScope((IJavaElement[])iJavaElementArray, (int)(n |= 2));
                MainMethodSearchEngine mainMethodSearchEngine = new MainMethodSearchEngine();
                DeployMainPage.this.types = mainMethodSearchEngine.searchMainMethods((IProgressMonitor)new NullProgressMonitor(), iJavaSearchScope, false);
                DebugTypeSelectionDialog debugTypeSelectionDialog = new DebugTypeSelectionDialog(DeployMainPage.this.getShell(), DeployMainPage.this.types, Messages.DeployMainPage_10);
                if (debugTypeSelectionDialog.open() == 1) {
                    return;
                }
                Object[] objectArray = debugTypeSelectionDialog.getResult();
                IType iType = (IType)objectArray[0];
                if (iType != null) {
                    DeployMainPage.this.fMainText.setText(iType.getFullyQualifiedName());
                    DeployMainPage.this.fProjText.setText(iType.getJavaProject().getElementName());
                }
            }
        });
    }

    private IJavaProject chooseJavaProject() {
        JavaElementLabelProvider javaElementLabelProvider = new JavaElementLabelProvider(JavaElementLabelProvider.SHOW_DEFAULT);
        ElementListSelectionDialog elementListSelectionDialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)javaElementLabelProvider);
        elementListSelectionDialog.setTitle(Messages.DeployMainPage_5);
        elementListSelectionDialog.setMessage(Messages.DeployMainPage_6);
        try {
            elementListSelectionDialog.setElements((Object[])JavaCore.create((IWorkspaceRoot)this.getWorkspaceRoot()).getJavaProjects());
        }
        catch (JavaModelException javaModelException) {
            JDIDebugUIPlugin.log((Throwable)javaModelException);
        }
        IJavaProject iJavaProject = this.getJavaProject();
        if (iJavaProject != null) {
            elementListSelectionDialog.setInitialSelections(new Object[]{iJavaProject});
        }
        if (elementListSelectionDialog.open() == 0) {
            return (IJavaProject)elementListSelectionDialog.getFirstResult();
        }
        return null;
    }

    protected IJavaProject getJavaProject() {
        String string = this.fProjText.getText().trim();
        if (string.length() < 1) {
            return null;
        }
        return this.getJavaModel().getJavaProject(string);
    }

    private IJavaModel getJavaModel() {
        return JavaCore.create((IWorkspaceRoot)this.getWorkspaceRoot());
    }

    private IWorkspaceRoot getWorkspaceRoot() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    public void setTypes(IType[] iTypeArray) {
        if (iTypeArray.length > 1) {
            String string = null;
            IJavaProject iJavaProject = null;
            int n = 0;
            while (n < iTypeArray.length) {
                iJavaProject = iTypeArray[n].getJavaProject();
                String string2 = iJavaProject.getElementName();
                if (string == null) {
                    string = string2;
                } else if (string != string2) break;
                ++n;
            }
            this.projectName = string;
            this.project = iJavaProject;
        } else if (iTypeArray.length == 1) {
            this.project = iTypeArray[0].getJavaProject();
            this.projectName = this.project.getElementName();
            this.mainTypeName = iTypeArray[0].getFullyQualifiedName();
        }
    }

    boolean isComplete() {
        if (this.fProjText == null || this.fMainText == null) {
            return false;
        }
        String string = this.fProjText.getText().trim();
        if (string.equals("")) {
            this.setErrorMessage(Messages.DeployMainPage_8);
            return false;
        }
        string = this.fMainText.getText().trim();
        if (string.equals("")) {
            this.setErrorMessage(Messages.DeployMainPage_10);
            return false;
        }
        this.setErrorMessage(null);
        this.setMessage(Messages.DeployMainPage_1);
        return true;
    }
}

