/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.demo.e4photo;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.ArrayList;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class Exif {
    IFD[] ifds;
    private String make;
    private String model;
    private Integer orientation;
    private String software;
    private String timestamp;
    private String exposure;
    private Integer iso;
    private Double aperture;
    private String exposureComp;
    private Boolean flash;
    private Integer width;
    private Integer height;
    private Double focalLength;
    private Integer whiteBalance;
    private String lightSource;
    private String exposureProgram;
    private String gpsLatitude;
    private String gpsLongitude;
    private final String name;
    private URI uri;
    public String gpsLatitudeRef;
    public String gpsLongitudeRef;

    public URI getUri() {
        return this.uri;
    }

    public String getName() {
        return this.name;
    }

    public String getMake() {
        return this.make;
    }

    public String getModel() {
        return this.model;
    }

    public Integer getOrientation() {
        return this.orientation;
    }

    public String getSoftware() {
        return this.software;
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    public String getExposure() {
        return this.exposure;
    }

    public Integer getIso() {
        return this.iso;
    }

    public Double getAperture() {
        return this.aperture;
    }

    public String getExposureComp() {
        return this.exposureComp;
    }

    public Boolean getFlash() {
        return this.flash;
    }

    public Integer getWidth() {
        return this.width;
    }

    public Integer getHeight() {
        return this.height;
    }

    public Double getFocalLength() {
        return this.focalLength;
    }

    public Integer getWhiteBalance() {
        return this.whiteBalance;
    }

    public String getLightSource() {
        return this.lightSource;
    }

    public String getExposureProgram() {
        return this.exposureProgram;
    }

    public String getGpsLatitude() {
        if (this.gpsLatitude == null) {
            return null;
        }
        return String.valueOf("S".equals(this.gpsLatitudeRef) ? "-" : "") + this.gpsLatitude;
    }

    public String getGpsLongitude() {
        if (this.gpsLongitude == null) {
            return null;
        }
        return String.valueOf("W".equals(this.gpsLongitudeRef) ? "-" : "") + this.gpsLongitude;
    }

    public Exif(URI uRI, InputStream inputStream) throws IOException {
        this.uri = uRI;
        this.name = this.getName(uRI);
        this.read(inputStream, false);
    }

    private String getName(URI uRI) {
        String string = uRI.getPath();
        int n = string.lastIndexOf(47);
        if (n != -1) {
            string = string.substring(n + 1);
        }
        return string;
    }

    public Exif(String string, InputStream inputStream) throws IOException {
        this.name = string;
        this.read(inputStream, false);
    }

    public Exif(String string, InputStream inputStream, boolean bl) throws IOException {
        this.name = string;
        this.read(inputStream, bl);
    }

    private void read(InputStream inputStream, boolean bl) throws IOException {
        try {
            if (inputStream.read() != 255) {
                throw new IllegalArgumentException("Not Exif");
            }
            if (inputStream.read() != 216) {
                throw new IllegalArgumentException("Not Exif");
            }
            if (inputStream.read() != 255) {
                throw new IllegalArgumentException("Not Exif");
            }
            if (inputStream.read() != 225) {
                throw new IllegalArgumentException("Not Exif");
            }
            int n = inputStream.read() & 0xFF;
            if (n == -1) {
                throw new IllegalArgumentException("Unexpected EOF");
            }
            int n2 = inputStream.read() & 0xFF;
            if (n2 == -1) {
                throw new IllegalArgumentException("Unexpected EOF");
            }
            int n3 = (n << 8) + n2;
            if (inputStream.read() != 69) {
                throw new IllegalArgumentException("Not Exif");
            }
            if (inputStream.read() != 120) {
                throw new IllegalArgumentException("Not Exif");
            }
            if (inputStream.read() != 105) {
                throw new IllegalArgumentException("Not Exif");
            }
            if (inputStream.read() != 102) {
                throw new IllegalArgumentException("Not Exif");
            }
            if (inputStream.read() != 0) {
                throw new IllegalArgumentException("Not Exif");
            }
            if (inputStream.read() != 0) {
                throw new IllegalArgumentException("Not Exif");
            }
            byte[] byArray = this.readBytes(inputStream, n3 - 8);
            char c = (char)byArray[0];
            int n4 = this.readInt(byArray, 4, 4, c);
            ArrayList<IFD> arrayList = new ArrayList<IFD>();
            while (n4 != 0) {
                IFD iFD = new IFD();
                n4 = this.readIFD(iFD, byArray, n4, c);
                Entry[] entryArray = iFD.entries;
                int n5 = iFD.entries.length;
                int n6 = 0;
                while (n6 < n5) {
                    Entry entry = entryArray[n6];
                    entry.applyValue(this, false);
                    if ((entry.tag == 34665 || entry.tag == 34853) && entry.data[0] instanceof IFD) {
                        IFD iFD2 = (IFD)entry.data[0];
                        Entry[] entryArray2 = iFD2.entries;
                        int n7 = iFD2.entries.length;
                        int n8 = 0;
                        while (n8 < n7) {
                            Entry entry2 = entryArray2[n8];
                            entry2.applyValue(this, entry.tag == 34853);
                            ++n8;
                        }
                    }
                    ++n6;
                }
                arrayList.add(iFD);
            }
            if (bl) {
                this.ifds = arrayList.toArray(new IFD[arrayList.size()]);
            }
        }
        finally {
            inputStream.close();
        }
    }

    private int readIFD(IFD iFD, byte[] byArray, int n, char c) {
        int n2 = this.readInt(byArray, n, 2, c);
        n += 2;
        iFD.entries = new Entry[n2];
        int n3 = 0;
        while (n3 < n2) {
            IFD iFD2;
            int n4;
            Entry entry = this.readEntry(byArray, n, c);
            n += 12;
            iFD.entries[n3] = entry;
            if (entry.tag == 34665) {
                n4 = (Integer)entry.data[0];
                if (n4 < byArray.length) {
                    iFD2 = new IFD();
                    this.readIFD(iFD2, byArray, n4, c);
                    entry.data[0] = iFD2;
                }
            } else if (entry.tag == 34853 && (n4 = ((Integer)entry.data[0]).intValue()) < byArray.length) {
                iFD2 = new IFD();
                this.readIFD(iFD2, byArray, n4, c);
                entry.data[0] = iFD2;
            }
            ++n3;
        }
        return 0;
    }

    private Entry readEntry(byte[] byArray, int n, char c) {
        int n2 = this.readInt(byArray, n, 2, c);
        int n3 = this.readInt(byArray, n + 2, 2, c);
        int n4 = this.readInt(byArray, n + 4, 4, c);
        Object[] objectArray = new Object[n4];
        int n5 = (new int[]{-1, 1, 1, 2, 4, 8, 1, 1, 2, 4, 8, 4, 8})[n3];
        n = n4 * n5 > 4 ? this.readInt(byArray, n + 8, 4, c) : (n += 8);
        if (n3 == 7) {
            objectArray = new Object[1];
        } else if (n3 == 2) {
            objectArray = new Object[]{new String(byArray, n, n4 - 1)};
        } else {
            int n6 = 0;
            while (n6 < n4) {
                switch (n3) {
                    case 1: {
                        objectArray[n6] = new Byte(byArray[n]);
                        break;
                    }
                    case 3: {
                        objectArray[n6] = new Integer(this.readInt(byArray, n, 2, c));
                        break;
                    }
                    case 4: {
                        objectArray[n6] = new Integer(this.readInt(byArray, n, 4, c));
                        break;
                    }
                    case 5: {
                        objectArray[n6] = new Fraction(this.readInt(byArray, n, 4, c), this.readInt(byArray, n + 4, 4, c));
                        break;
                    }
                    case 6: {
                        objectArray[n6] = new Byte(byArray[n]);
                        break;
                    }
                    case 7: {
                        objectArray[n6] = new Byte(byArray[n]);
                        break;
                    }
                    case 8: {
                        objectArray[n6] = new Integer(this.readInt(byArray, n, 2, c));
                        break;
                    }
                    case 9: {
                        objectArray[n6] = new Integer(this.readInt(byArray, n, 4, c));
                        break;
                    }
                    case 10: {
                        objectArray[n6] = new Fraction(this.readInt(byArray, n, 4, c), this.readInt(byArray, n + 4, 4, c));
                        break;
                    }
                    case 11: {
                        objectArray[n6] = new Float(Float.intBitsToFloat(this.readInt(byArray, n, 4, c)));
                        break;
                    }
                    case 12: {
                        objectArray[n6] = new Float(Float.intBitsToFloat(this.readInt(byArray, n, 8, c)));
                        break;
                    }
                    default: {
                        throw new RuntimeException("unexpected case");
                    }
                }
                n += n5;
                ++n6;
            }
        }
        return new Entry(n2, n3, objectArray);
    }

    private int readInt(byte[] byArray, int n, int n2, char c) {
        if (c == 'M') {
            int n3 = 0;
            int n4 = 0;
            while (n4 < n2) {
                n3 <<= 8;
                n3 |= byArray[n + n4] & 0xFF;
                ++n4;
            }
            return n3;
        }
        int n5 = 0;
        int n6 = n2 - 1;
        while (n6 >= 0) {
            n5 <<= 8;
            n5 |= byArray[n + n6] & 0xFF;
            --n6;
        }
        return n5;
    }

    private byte[] readBytes(InputStream inputStream, int n) throws IOException {
        int n2;
        byte[] byArray = new byte[n];
        int n3 = 0;
        while ((n2 = inputStream.read(byArray, n3, n)) > 0) {
            n -= n2;
            n3 += n2;
        }
        if (n > 0) {
            throw new IOException("Could only read " + n2 + " bytes but expected " + n + " more.");
        }
        return byArray;
    }

    public static void main(String ... stringArray) throws FileNotFoundException, IOException, SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        String string = stringArray[0];
        File file = new File(string);
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            ArrayList<Exif> arrayList = new ArrayList<Exif>();
            int n = 0;
            while (n < fileArray.length) {
                try {
                    arrayList.add(new Exif(fileArray[n].getName(), (InputStream)new FileInputStream(fileArray[n])));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    System.out.println("skipping " + fileArray[n].getName());
                }
                ++n;
            }
            Exif.displayExifs(arrayList.toArray(new Exif[arrayList.size()]));
            return;
        }
        Exif exif = new Exif(string, new FileInputStream(string), true);
        exif.printStuff();
    }

    private static void displayExifs(Exif[] exifArray) throws SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Display display = new Display();
        Shell shell = new Shell(display);
        shell.setLayout((Layout)new FillLayout());
        Table table = new Table((Composite)shell, 65540);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        String[] stringArray = new String[]{"Name", "Make", "Model", "Orientation", "Software", "Timestamp", "Exposure", "Iso", "Aperture", "ExposureComp", "Flash", "Width", "Height", "FocalLength", "WhiteBalance", "LightSource", "ExposureProgram"};
        Method[] methodArray = new Method[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            new TableColumn(table, 0).setText(stringArray[n]);
            methodArray[n] = Exif.class.getDeclaredMethod("get" + stringArray[n], new Class[0]);
            ++n;
        }
        n = 0;
        while (n < exifArray.length) {
            Exif exif = exifArray[n];
            TableItem tableItem = new TableItem(table, 0);
            int n2 = 0;
            while (n2 < methodArray.length) {
                tableItem.setText(n2, "" + methodArray[n2].invoke((Object)exif, new Object[0]));
                ++n2;
            }
            ++n;
        }
        n = 0;
        while (n < table.getColumnCount()) {
            table.getColumn(n).pack();
            ++n;
        }
        shell.pack();
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
    }

    private void printStuff() {
        IFD[] iFDArray = this.ifds;
        int n = this.ifds.length;
        int n2 = 0;
        while (n2 < n) {
            IFD iFD = iFDArray[n2];
            System.out.println("---IFD---");
            Entry[] entryArray = iFD.entries;
            int n3 = iFD.entries.length;
            int n4 = 0;
            while (n4 < n3) {
                Entry entry = entryArray[n4];
                System.out.println(entry);
                if ((entry.tag == 34665 || entry.tag == 34853) && entry.data[0] instanceof IFD) {
                    System.out.println("---Sub-IFD---");
                    IFD iFD2 = (IFD)entry.data[0];
                    Entry[] entryArray2 = iFD2.entries;
                    int n5 = iFD2.entries.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        Entry entry2 = entryArray2[n6];
                        System.out.println(entry2);
                        ++n6;
                    }
                    System.out.println("---End-Sub---");
                }
                ++n4;
            }
            ++n2;
        }
    }

    static class Entry {
        int tag;
        int format;
        Object[] data;

        Entry(int n, int n2, Object[] objectArray) {
            this.tag = n;
            this.format = n2;
            this.data = objectArray;
        }

        void applyValue(Exif exif, boolean bl) {
            block0 : switch (this.tag) {
                case 1: {
                    if (!bl) break;
                    exif.gpsLatitudeRef = (String)this.data[0];
                    break;
                }
                case 2: {
                    if (!bl) break;
                    double d = ((Fraction)this.data[0]).toDouble();
                    double d2 = ((Fraction)this.data[1]).toDouble();
                    double d3 = ((Fraction)this.data[2]).toDouble();
                    if (d3 == 0.0) {
                        exif.gpsLatitude = String.valueOf((int)d) + "\u00b0" + d2 + "'";
                        break;
                    }
                    exif.gpsLatitude = String.valueOf((int)d) + "\u00b0" + (int)d2 + "'" + (int)d3 + "\"";
                    break;
                }
                case 3: {
                    if (!bl) break;
                    exif.gpsLongitudeRef = (String)this.data[0];
                    break;
                }
                case 4: {
                    if (!bl) break;
                    double d = ((Fraction)this.data[0]).toDouble();
                    double d4 = ((Fraction)this.data[1]).toDouble();
                    double d5 = ((Fraction)this.data[2]).toDouble();
                    if (d5 == 0.0) {
                        exif.gpsLongitude = String.valueOf((int)d) + "\u00b0" + d4 + "'";
                        break;
                    }
                    exif.gpsLongitude = String.valueOf((int)d) + "\u00b0" + (int)d4 + "'" + (int)d5 + "\"";
                    break;
                }
                case 271: {
                    exif.make = (String)this.data[0];
                    break;
                }
                case 272: {
                    exif.model = (String)this.data[0];
                    break;
                }
                case 274: {
                    exif.orientation = (Integer)this.data[0];
                    break;
                }
                case 305: {
                    exif.software = (String)this.data[0];
                    break;
                }
                case 306: {
                    exif.timestamp = (String)this.data[0];
                    break;
                }
                case 33434: {
                    exif.exposure = ((Fraction)this.data[0]).toFraction();
                    break;
                }
                case 33437: {
                    exif.aperture = ((Fraction)this.data[0]).toDouble();
                    break;
                }
                case 34850: {
                    switch ((Integer)this.data[0]) {
                        default: {
                            exif.exposureProgram = "Not defined";
                            break block0;
                        }
                        case 1: {
                            exif.exposureProgram = "Manual";
                            break block0;
                        }
                        case 2: {
                            exif.exposureProgram = "Normal program";
                            break block0;
                        }
                        case 3: {
                            exif.exposureProgram = "Aperture priority";
                            break block0;
                        }
                        case 4: {
                            exif.exposureProgram = "Shutter priority";
                            break block0;
                        }
                        case 5: {
                            exif.exposureProgram = "Creative program";
                            break block0;
                        }
                        case 6: {
                            exif.exposureProgram = "Action program";
                            break block0;
                        }
                        case 7: {
                            exif.exposureProgram = "Portrait mode";
                            break block0;
                        }
                        case 8: 
                    }
                    exif.exposureProgram = "Landscape mode";
                    break;
                }
                case 34855: {
                    exif.iso = (Integer)this.data[0];
                    break;
                }
                case 37380: {
                    exif.exposureComp = ((Fraction)this.data[0]).toFraction();
                    break;
                }
                case 37385: {
                    exif.flash = new Boolean(((Integer)this.data[0] & 1) != 0);
                    break;
                }
                case 37386: {
                    exif.focalLength = ((Fraction)this.data[0]).toDouble();
                    break;
                }
                case 40962: {
                    exif.width = (Integer)this.data[0];
                    break;
                }
                case 40963: {
                    exif.height = (Integer)this.data[0];
                    break;
                }
                case 41987: {
                    exif.whiteBalance = (Integer)this.data[0];
                    break;
                }
                case 37384: {
                    switch ((Integer)this.data[0]) {
                        default: {
                            exif.lightSource = "Unknown";
                            break block0;
                        }
                        case 1: {
                            exif.lightSource = "Daylight";
                            break block0;
                        }
                        case 2: {
                            exif.lightSource = "Fluorescent";
                            break block0;
                        }
                        case 3: {
                            exif.lightSource = "Tungsten (incandescent light)";
                            break block0;
                        }
                        case 4: {
                            exif.lightSource = "Flash";
                            break block0;
                        }
                        case 9: {
                            exif.lightSource = "Fine weather";
                            break block0;
                        }
                        case 10: {
                            exif.lightSource = "Cloudy weather";
                            break block0;
                        }
                        case 11: {
                            exif.lightSource = "Shade";
                            break block0;
                        }
                        case 12: {
                            exif.lightSource = "Daylight fluorescent (D 5700 - 7100K)";
                            break block0;
                        }
                        case 13: {
                            exif.lightSource = "Day white fluorescent (N 4600 - 5400K)";
                            break block0;
                        }
                        case 14: {
                            exif.lightSource = "Cool white fluorescent (W 3900 - 4500K)";
                            break block0;
                        }
                        case 15: {
                            exif.lightSource = "White fluorescent (WW 3200 - 3700K)";
                            break block0;
                        }
                        case 17: {
                            exif.lightSource = "Standard light A";
                            break block0;
                        }
                        case 18: {
                            exif.lightSource = "Standard light B";
                            break block0;
                        }
                        case 19: {
                            exif.lightSource = "Standard light C";
                            break block0;
                        }
                        case 20: {
                            exif.lightSource = "D55";
                            break block0;
                        }
                        case 21: {
                            exif.lightSource = "D65";
                            break block0;
                        }
                        case 22: {
                            exif.lightSource = "D75";
                            break block0;
                        }
                        case 23: {
                            exif.lightSource = "D50";
                            break block0;
                        }
                        case 24: {
                            exif.lightSource = "ISO studio tungsten";
                            break block0;
                        }
                        case 255: 
                    }
                    exif.lightSource = "Other light source";
                }
            }
        }

        public String toString() {
            String string = "unknown (" + this.tag + ")";
            switch (this.tag) {
                case 256: {
                    string = "ImageWidth";
                    break;
                }
                case 257: {
                    string = "ImageLength";
                    break;
                }
                case 258: {
                    string = "BitsPerSample";
                    break;
                }
                case 259: {
                    string = "Compression";
                    break;
                }
                case 262: {
                    string = "PhotometricInterpretation";
                    break;
                }
                case 266: {
                    string = "FillOrder";
                    break;
                }
                case 269: {
                    string = "DocumentName";
                    break;
                }
                case 270: {
                    string = "ImageDescription";
                    break;
                }
                case 271: {
                    string = "Make";
                    break;
                }
                case 272: {
                    string = "Model";
                    break;
                }
                case 273: {
                    string = "StripOffsets";
                    break;
                }
                case 274: {
                    string = "Orientation";
                    break;
                }
                case 277: {
                    string = "SamplesPerPixel";
                    break;
                }
                case 278: {
                    string = "RowsPerStrip";
                    break;
                }
                case 279: {
                    string = "StripByteCounts";
                    break;
                }
                case 282: {
                    string = "XResolution";
                    break;
                }
                case 283: {
                    string = "YResolution";
                    break;
                }
                case 284: {
                    string = "PlanarConfiguration";
                    break;
                }
                case 296: {
                    string = "ResolutionUnit";
                    break;
                }
                case 301: {
                    string = "TransferFunction";
                    break;
                }
                case 305: {
                    string = "Software";
                    break;
                }
                case 306: {
                    string = "DateTime";
                    break;
                }
                case 315: {
                    string = "Artist";
                    break;
                }
                case 318: {
                    string = "WhitePoint";
                    break;
                }
                case 319: {
                    string = "PrimaryChromaticities";
                    break;
                }
                case 342: {
                    string = "TransferRange";
                    break;
                }
                case 512: {
                    string = "JPEGProc";
                    break;
                }
                case 513: {
                    string = "JPEGInterchangeFormat";
                    break;
                }
                case 514: {
                    string = "JPEGInterchangeFormatLength";
                    break;
                }
                case 529: {
                    string = "YCbCrCoefficients";
                    break;
                }
                case 530: {
                    string = "YCbCrSubSampling";
                    break;
                }
                case 531: {
                    string = "YCbCrPositioning";
                    break;
                }
                case 532: {
                    string = "ReferenceBlackWhite";
                    break;
                }
                case 33423: {
                    string = "BatteryLevel";
                    break;
                }
                case 33432: {
                    string = "Copyright";
                    break;
                }
                case 33434: {
                    string = "ExposureTime";
                    break;
                }
                case 33437: {
                    string = "FNumber";
                    break;
                }
                case 33723: {
                    string = "IPTC/NAA";
                    break;
                }
                case 34665: {
                    string = "ExifIFDPointer";
                    break;
                }
                case 34675: {
                    string = "InterColorProfile";
                    break;
                }
                case 34850: {
                    string = "ExposureProgram";
                    break;
                }
                case 34852: {
                    string = "SpectralSensitivity";
                    break;
                }
                case 34853: {
                    string = "GPSInfoIFDPointer";
                    break;
                }
                case 34855: {
                    string = "ISOSpeedRatings";
                    break;
                }
                case 34856: {
                    string = "OECF";
                    break;
                }
                case 36864: {
                    string = "ExifVersion";
                    break;
                }
                case 36867: {
                    string = "DateTimeOriginal";
                    break;
                }
                case 36868: {
                    string = "DateTimeDigitized";
                    break;
                }
                case 37121: {
                    string = "ComponentsConfiguration";
                    break;
                }
                case 37122: {
                    string = "CompressedBitsPerPixel";
                    break;
                }
                case 37377: {
                    string = "ShutterSpeedValue";
                    break;
                }
                case 37378: {
                    string = "ApertureValue";
                    break;
                }
                case 37379: {
                    string = "BrightnessValue";
                    break;
                }
                case 37380: {
                    string = "ExposureBiasValue";
                    break;
                }
                case 37381: {
                    string = "MaxApertureValue";
                    break;
                }
                case 37382: {
                    string = "SubjectDistance";
                    break;
                }
                case 37383: {
                    string = "MeteringMode";
                    break;
                }
                case 37384: {
                    string = "LightSource";
                    break;
                }
                case 37385: {
                    string = "Flash";
                    break;
                }
                case 37386: {
                    string = "FocalLength";
                    break;
                }
                case 37396: {
                    string = "SubjectArea";
                    break;
                }
                case 37500: {
                    string = "MakerNote";
                    break;
                }
                case 37510: {
                    string = "UserComment";
                    break;
                }
                case 37520: {
                    string = "SubSecTime";
                    break;
                }
                case 37521: {
                    string = "SubSecTimeOriginal";
                    break;
                }
                case 37522: {
                    string = "SubSecTimeDigitized";
                    break;
                }
                case 40960: {
                    string = "FlashPixVersion";
                    break;
                }
                case 40961: {
                    string = "ColorSpace";
                    break;
                }
                case 40962: {
                    string = "PixelXDimension";
                    break;
                }
                case 40963: {
                    string = "PixelYDimension";
                    break;
                }
                case 40964: {
                    string = "RelatedSoundFile";
                    break;
                }
                case 40965: {
                    string = "InteroperabilityIFDPointer";
                    break;
                }
                case 41483: {
                    string = "FlashEnergy";
                    break;
                }
                case 41484: {
                    string = "SpatialFrequencyResponse";
                    break;
                }
                case 41486: {
                    string = "FocalPlaneXResolution";
                    break;
                }
                case 41487: {
                    string = "FocalPlaneYResolution";
                    break;
                }
                case 41488: {
                    string = "FocalPlaneResolutionUnit";
                    break;
                }
                case 41492: {
                    string = "SubjectLocation";
                    break;
                }
                case 41493: {
                    string = "ExposureIndex";
                    break;
                }
                case 41495: {
                    string = "SensingMethod";
                    break;
                }
                case 41728: {
                    string = "FileSource";
                    break;
                }
                case 41729: {
                    string = "SceneType";
                    break;
                }
                case 41730: {
                    string = "CFAPattern";
                    break;
                }
                case 41985: {
                    string = "CustomRendered";
                    break;
                }
                case 41986: {
                    string = "ExposureMode";
                    break;
                }
                case 41987: {
                    string = "WhiteBalance";
                    break;
                }
                case 41988: {
                    string = "DigitalZoomRatio";
                    break;
                }
                case 41989: {
                    string = "FocalLengthIn35mmFilm";
                    break;
                }
                case 41990: {
                    string = "SceneCaptureType";
                    break;
                }
                case 41991: {
                    string = "GainControl";
                    break;
                }
                case 41992: {
                    string = "Contrast";
                    break;
                }
                case 41993: {
                    string = "Saturation";
                    break;
                }
                case 41994: {
                    string = "Sharpness";
                    break;
                }
                case 41995: {
                    string = "DeviceSettingDescription";
                    break;
                }
                case 41996: {
                    string = "SubjectDistanceRange";
                    break;
                }
                case 42016: {
                    string = "ImageUniqueID";
                }
            }
            return String.valueOf(string) + ": " + this.toString(this.data);
        }

        private String toString(Object[] objectArray) {
            if (objectArray.length == 0) {
                return "[]";
            }
            if (objectArray.length == 1) {
                return "" + objectArray[0];
            }
            StringBuffer stringBuffer = new StringBuffer("[");
            int n = 0;
            while (n < objectArray.length) {
                if (n > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append("" + objectArray[n]);
                ++n;
            }
            stringBuffer.append("]");
            return stringBuffer.toString();
        }
    }

    static class Fraction {
        int num;
        int den;

        Fraction(int n, int n2) {
            this.num = n;
            this.den = n2;
        }

        public String toFraction() {
            if (this.num == 0) {
                return "0";
            }
            int n = this.gcd(this.num, this.den);
            return String.valueOf(this.num / n) + "/" + this.den / n;
        }

        private int gcd(int n, int n2) {
            if (n2 == 0) {
                return n;
            }
            return this.gcd(n2, n % n2);
        }

        public Double toDouble() {
            return new Double((double)this.num / (double)this.den);
        }

        public String toString() {
            return String.valueOf(this.num) + "/" + this.den;
        }
    }

    static class IFD {
        Entry[] entries;

        IFD() {
        }
    }
}

