/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.demo.e4photo;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.databinding.beans.PojoObservables;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.e4.core.services.JSONObject;
import org.eclipse.e4.core.services.Logger;
import org.eclipse.e4.demo.e4photo.Exif;
import org.eclipse.e4.demo.e4photo.annotations.In;
import org.eclipse.e4.demo.e4photo.annotations.Out;
import org.eclipse.e4.demo.e4photo.annotations.PostConstruct;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.databinding.viewers.ObservableMapLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableColumn;

public class ExifTable {
    private PropertyChangeSupport changeSupport = new PropertyChangeSupport(this);
    private WritableList inputList = new WritableList();
    private IContainer input;
    private Exif selection;
    private String persistedState;
    @In
    private Composite parent;
    @In
    private Logger logger;

    @Out
    public String getPersistedState() {
        return this.persistedState;
    }

    @Out
    public Exif getSelection() {
        return this.selection;
    }

    @In
    void setInput(IResource iResource) {
        if (iResource == null) {
            return;
        }
        IContainer iContainer = iResource instanceof IContainer ? (IContainer)iResource : iResource.getParent();
        if (iContainer == this.input) {
            return;
        }
        this.input = iContainer;
        this.inputList.clear();
        try {
            IResource[] iResourceArray = this.input.members();
            int n = 0;
            while (n < iResourceArray.length) {
                block17: {
                    IResource iResource2 = iResourceArray[n];
                    if (iResource2.getType() == 1) {
                        InputStream inputStream = ((IFile)iResource2).getContents();
                        try {
                            try {
                                Exif exif = new Exif(iResource2.getLocationURI(), inputStream);
                                this.inputList.add((Object)exif);
                            }
                            catch (Exception exception) {
                                this.logger.warn(((IFile)iResource2).getFullPath() + ": " + exception.getMessage());
                                try {
                                    inputStream.close();
                                }
                                catch (IOException iOException) {
                                    this.logger.warn((Throwable)iOException, "Could not close stream");
                                }
                                break block17;
                            }
                        }
                        catch (Throwable throwable) {
                            try {
                                inputStream.close();
                            }
                            catch (IOException iOException) {
                                this.logger.warn((Throwable)iOException, "Could not close stream");
                            }
                            throw throwable;
                        }
                        try {
                            inputStream.close();
                        }
                        catch (IOException iOException) {
                            this.logger.warn((Throwable)iOException, "Could not close stream");
                        }
                    }
                }
                ++n;
            }
        }
        catch (CoreException coreException) {
            coreException.printStackTrace();
        }
    }

    @In
    void setPersistedState(String string) {
        this.persistedState = string;
        this.changeSupport.firePropertyChange("persistedState", this.persistedState, this.persistedState);
    }

    private void setSelection(Exif exif) {
        this.selection = exif;
        this.changeSupport.firePropertyChange("selection", this.selection, this.selection);
    }

    @PostConstruct
    void init() {
        this.parent.setLayout((Layout)new FillLayout());
        TableViewer tableViewer = new TableViewer(this.parent, 68356);
        tableViewer.getTable().setHeaderVisible(true);
        tableViewer.getTable().setLinesVisible(true);
        tableViewer.getTable().setData("org.eclipse.e4.ui.css.id", (Object)"exif");
        tableViewer.getTable().setData("org.eclipse.e4.ui.css.CssClassName", (Object)"properties");
        final JSONObject jSONObject = this.persistedState == null ? new JSONObject() : JSONObject.deserialize((String)this.persistedState);
        String[] stringArray = new String[]{"name", "make", "model", "orientation", "software", "timestamp", "gpsLatitude", "gpsLongitude", "exposure", "iso", "aperture", "exposureComp", "flash", "width", "height", "focalLength", "whiteBalance", "lightSource", "exposureProgram"};
        int n = 0;
        while (n < stringArray.length) {
            TableViewerColumn tableViewerColumn = new TableViewerColumn(tableViewer, 0);
            final TableColumn tableColumn = tableViewerColumn.getColumn();
            final String string = stringArray[n];
            tableColumn.setText(string);
            String string2 = jSONObject.getString(string);
            if (string2 != null) {
                tableColumn.setWidth(Integer.parseInt(string2));
            } else {
                tableColumn.pack();
            }
            tableColumn.addControlListener((ControlListener)new ControlAdapter(){

                public void controlResized(ControlEvent controlEvent) {
                    jSONObject.set(string, String.valueOf(tableColumn.getWidth()));
                    ExifTable.this.setPersistedState(jSONObject.serialize());
                }
            });
            ++n;
        }
        ObservableListContentProvider observableListContentProvider = new ObservableListContentProvider();
        tableViewer.setContentProvider((IContentProvider)observableListContentProvider);
        tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                ExifTable.this.setSelection((Exif)((StructuredSelection)selectionChangedEvent.getSelection()).getFirstElement());
            }
        });
        tableViewer.setLabelProvider((IBaseLabelProvider)new ObservableMapLabelProvider(PojoObservables.observeMaps((IObservableSet)observableListContentProvider.getKnownElements(), Exif.class, (String[])stringArray)));
        tableViewer.setInput((Object)this.inputList);
    }

    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.changeSupport.addPropertyChangeListener(string, propertyChangeListener);
    }

    public void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.changeSupport.removePropertyChangeListener(string, propertyChangeListener);
    }

    void dispose() {
        System.out.println("dispose called!");
    }
}

