/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.demo.e4photo;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.Observables;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.masterdetail.IObservableFactory;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.set.WritableSet;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.e4.core.services.IDisposable;
import org.eclipse.e4.core.services.context.IEclipseContext;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.databinding.viewers.ObservableSetTreeContentProvider;
import org.eclipse.jface.databinding.viewers.TreeStructureAdvisor;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.osgi.service.prefs.BackingStoreException;

public class Library
implements IDisposable {
    Map<IContainer, IObservableSet> observableSets = new HashMap<IContainer, IObservableSet>();
    private IResourceChangeListener listener = new IResourceChangeListener(){

        public void resourceChanged(IResourceChangeEvent iResourceChangeEvent) {
            if (iResourceChangeEvent.getType() == 1) {
                try {
                    iResourceChangeEvent.getDelta().accept(new IResourceDeltaVisitor(){

                        public boolean visit(IResourceDelta iResourceDelta) throws CoreException {
                            if (iResourceDelta.getKind() == 1) {
                                this.handleChange(iResourceDelta.getResource(), iResourceDelta.getResource().getParent(), true);
                            } else if (iResourceDelta.getKind() == 2) {
                                this.handleChange(iResourceDelta.getResource(), iResourceDelta.getResource().getParent(), false);
                            }
                            return true;
                        }

                        private void handleChange(final IResource iResource, IContainer iContainer, final boolean bl) {
                            final IObservableSet iObservableSet = (this).Library.this.observableSets.get(iContainer);
                            if (iObservableSet != null) {
                                iObservableSet.getRealm().asyncExec(new Runnable(){

                                    public void run() {
                                        if (bl) {
                                            iObservableSet.add((Object)iResource);
                                        } else {
                                            iObservableSet.remove((Object)iResource);
                                        }
                                    }
                                });
                            }
                        }
                    });
                }
                catch (CoreException coreException) {
                    coreException.printStackTrace();
                }
            }
        }
    };
    private final IWorkspace workspace;
    static int counter;

    public Library(Composite composite, IWorkspace iWorkspace, final IEclipseContext iEclipseContext) {
        final Realm realm = SWTObservables.getRealm((Display)composite.getDisplay());
        this.workspace = iWorkspace;
        this.initializeWorkspace();
        TreeViewer treeViewer = new TreeViewer(composite, 770);
        treeViewer.getTree().setData("org.eclipse.e4.ui.css.id", (Object)"library");
        treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                StructuredSelection structuredSelection = (StructuredSelection)selectionChangedEvent.getSelection();
                iEclipseContext.set("selection", (Object)(structuredSelection.size() == 1 ? structuredSelection.getFirstElement() : structuredSelection.toArray()));
            }
        });
        IObservableFactory iObservableFactory = new IObservableFactory(){

            public IObservable createObservable(Object object) {
                if (object instanceof IContainer && ((IContainer)object).exists()) {
                    IObservableSet iObservableSet = Library.this.observableSets.get(object);
                    if (iObservableSet == null) {
                        iObservableSet = new WritableSet(realm);
                        try {
                            iObservableSet.addAll(Arrays.asList(((IContainer)object).members()));
                        }
                        catch (CoreException coreException) {
                            coreException.printStackTrace();
                        }
                        Library.this.observableSets.put((IContainer)object, iObservableSet);
                    }
                    return iObservableSet;
                }
                return Observables.emptyObservableSet();
            }
        };
        treeViewer.setContentProvider((IContentProvider)new ObservableSetTreeContentProvider(iObservableFactory, new TreeStructureAdvisor(){

            public Boolean hasChildren(Object object) {
                return object instanceof IContainer;
            }
        }));
        treeViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object object) {
                if (object instanceof IResource) {
                    return ((IResource)object).getName();
                }
                return object == null ? "" : object.toString();
            }
        });
        treeViewer.setSorter(new ViewerSorter());
        treeViewer.setInput((Object)iWorkspace.getRoot());
        GridLayoutFactory.fillDefaults().generateLayout(composite);
    }

    private void initializeWorkspace() {
        this.workspace.addResourceChangeListener(this.listener);
        IEclipsePreferences iEclipsePreferences = new InstanceScope().getNode("org.eclipse.core.resources");
        iEclipsePreferences.putBoolean("refresh.enabled", true);
        try {
            iEclipsePreferences.flush();
        }
        catch (BackingStoreException backingStoreException) {
            backingStoreException.printStackTrace();
        }
    }

    public void dispose() {
        this.workspace.removeResourceChangeListener(this.listener);
    }
}

