/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.demo.e4photo;

import java.io.InputStream;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.ComputedValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.resources.IFile;
import org.eclipse.e4.demo.e4photo.annotations.In;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class Preview {
    private static int topImageMargin = 16;
    private static int bottomImageMargin = 16;
    private static int frameWidth = 6;
    private final Composite parent;
    private Image currentImage;
    private IObservableValue parentSize;
    private IObservableValue inputFile;
    private IObservableValue rawImageData;
    private IObservableValue scaledImageData;
    private final Realm bgRealm;
    private Color borderColor;

    public Preview(Composite composite, Realm realm) {
        this.parent = composite;
        this.parent.setData("org.eclipse.e4.ui.css.id", (Object)"preview");
        this.bgRealm = realm;
        this.inputFile = new WritableValue(this.bgRealm);
        this.rawImageData = new ComputedValue(this.bgRealm){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            protected Object calculate() {
                IFile iFile = (IFile)Preview.this.inputFile.getValue();
                if (iFile == null) {
                    return null;
                }
                try {
                    InputStream inputStream = iFile.getContents();
                    try {
                        ImageData imageData = new ImageData(inputStream);
                        return imageData;
                    }
                    catch (SWTException sWTException) {
                        return null;
                    }
                    finally {
                        inputStream.close();
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                return null;
            }
        };
        this.parentSize = new WritableValue(this.bgRealm);
        this.scaledImageData = new ComputedValue(this.bgRealm){

            protected Object calculate() {
                ImageData imageData = (ImageData)Preview.this.rawImageData.getValue();
                Point point = (Point)Preview.this.parentSize.getValue();
                if (imageData == null || point == null) {
                    return null;
                }
                Point point2 = Preview.this.getBestSize(imageData.width, imageData.height, point.x, point.y);
                return imageData.scaledTo(point2.x, point2.y);
            }
        };
        this.scaledImageData.addChangeListener(new IChangeListener(){

            public void handleChange(ChangeEvent changeEvent) {
                ImageData imageData = (ImageData)Preview.this.scaledImageData.getValue();
                if (imageData == null) {
                    return;
                }
                if (Preview.this.currentImage != null) {
                    Preview.this.currentImage.dispose();
                    Preview.this.currentImage = null;
                }
                Preview.this.currentImage = new Image((Device)Preview.this.parent.getDisplay(), imageData);
                Preview.this.parent.getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        Preview.this.parent.redraw();
                    }
                });
            }
        });
        this.parent.setLayout((Layout)new FillLayout());
        this.parent.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent paintEvent) {
                if (paintEvent.gc.isDisposed()) {
                    return;
                }
                paintEvent.gc.fillRectangle(new Rectangle(paintEvent.x, paintEvent.y, paintEvent.width, paintEvent.height));
                Image image = Preview.this.currentImage;
                if (image != null && !image.isDisposed()) {
                    Rectangle rectangle = Preview.this.currentImage.getBounds();
                    int n = (((Preview)Preview.this).parent.getBounds().width - rectangle.width) / 2;
                    int n2 = bottomImageMargin;
                    if (Preview.this.borderColor == null) {
                        Preview.this.borderColor = new Color(paintEvent.gc.getDevice(), 229, 229, 229);
                    }
                    Color color = paintEvent.gc.getBackground();
                    paintEvent.gc.setBackground(Preview.this.borderColor);
                    paintEvent.gc.fillRoundRectangle(n, n2, rectangle.width + frameWidth * 2, rectangle.height + frameWidth * 2, frameWidth, frameWidth);
                    paintEvent.gc.setBackground(color);
                    paintEvent.gc.drawImage(image, n + frameWidth, n2 + frameWidth);
                }
            }
        });
        this.parent.addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent controlEvent) {
            }

            public void controlResized(ControlEvent controlEvent) {
                final Point point = Preview.this.parent.getSize();
                Preview.this.bgRealm.asyncExec(new Runnable(){

                    public void run() {
                        Preview.this.parentSize.setValue((Object)point);
                    }
                });
            }
        });
    }

    @In
    public void setInput(final IFile iFile) {
        this.bgRealm.asyncExec(new Runnable(){

            public void run() {
                Preview.this.inputFile.setValue((Object)iFile);
            }
        });
    }

    private Point getBestSize(int n, int n2, int n3, int n4) {
        double d = (double)n / (double)n3;
        double d2 = (double)n2 / (double)n4;
        double d3 = d > d2 ? d : d2;
        int n5 = (int)((double)n / d3) - frameWidth * 2;
        int n6 = (int)((double)n2 / d3) - (topImageMargin + bottomImageMargin + frameWidth * 2);
        return new Point(n5, n6);
    }
}

