/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.demo.e4photo;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.e4.core.services.IBackgroundRunner;
import org.eclipse.e4.core.services.context.IEclipseContext;
import org.eclipse.e4.demo.e4photo.annotations.In;
import org.eclipse.e4.ui.services.IStylingEngine;
import org.eclipse.nebula.widgets.gallery.AbstractGalleryGroupRenderer;
import org.eclipse.nebula.widgets.gallery.AbstractGalleryItemRenderer;
import org.eclipse.nebula.widgets.gallery.DefaultGalleryItemRenderer;
import org.eclipse.nebula.widgets.gallery.Gallery;
import org.eclipse.nebula.widgets.gallery.GalleryItem;
import org.eclipse.nebula.widgets.gallery.NoGroupRenderer;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class Thumbnails {
    private Gallery gallery;
    private GalleryItem group;
    private final IEclipseContext outputContext;
    private final IBackgroundRunner backgroundRunner;
    private IContainer input;
    private volatile Runnable runnable;
    private final IStylingEngine stylingEngine;

    public Thumbnails(Composite composite, final IEclipseContext iEclipseContext, IBackgroundRunner iBackgroundRunner, IStylingEngine iStylingEngine) {
        this.outputContext = iEclipseContext;
        this.backgroundRunner = iBackgroundRunner;
        this.stylingEngine = iStylingEngine;
        composite.setLayout((Layout)new FillLayout());
        this.gallery = new Gallery(composite, 514);
        this.gallery.setData("org.eclipse.e4.ui.css.id", (Object)"thumbnails");
        new Image((Device)composite.getDisplay(), Program.findProgram((String)"jpg").getImageData());
        this.gallery.setGroupRenderer((AbstractGalleryGroupRenderer)new NoGroupRenderer());
        DefaultGalleryItemRenderer defaultGalleryItemRenderer = new DefaultGalleryItemRenderer();
        defaultGalleryItemRenderer.setShowLabels(false);
        defaultGalleryItemRenderer.setDropShadowsSize(0);
        defaultGalleryItemRenderer.setShowRoundedSelectionCorners(false);
        this.gallery.setItemRenderer((AbstractGalleryItemRenderer)defaultGalleryItemRenderer);
        this.group = new GalleryItem(this.gallery, 0);
        this.group.setExpanded(true);
        this.gallery.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                Object object = selectionEvent.item.getData();
                iEclipseContext.set("selection", object);
            }
        });
    }

    private Point getBestSize(int n, int n2, int n3, int n4) {
        double d = (double)n / (double)n3;
        double d2 = (double)n2 / (double)n4;
        double d3 = d > d2 ? d : d2;
        int n5 = (int)((double)n / d3);
        int n6 = (int)((double)n2 / d3);
        return new Point(n5, n6);
    }

    @In
    public void setInput(IResource iResource) {
        if (iResource == null) {
            return;
        }
        IContainer iContainer = iResource instanceof IContainer ? (IContainer)iResource : iResource.getParent();
        if (iContainer != this.input) {
            this.input = iContainer;
            this.runnable = null;
            try {
                IContainer iContainer2 = this.input;
                IResource[] iResourceArray = iContainer2.members();
                this.gallery.removeAll();
                this.group = new GalleryItem(this.gallery, 0);
                this.group.setExpanded(true);
                final ArrayList<IResource> arrayList = new ArrayList<IResource>();
                int n = 0;
                while (n < iResourceArray.length) {
                    IResource iResource2 = iResourceArray[n];
                    if (iResource2.getType() == 1) {
                        arrayList.add(iResource2);
                    }
                    ++n;
                }
                if (arrayList.size() == 0) {
                    return;
                }
                final int[] nArray = new int[1];
                this.runnable = new Runnable(){

                    public void run() {
                        if (Thumbnails.this.runnable != this) {
                            return;
                        }
                        int n = nArray[0];
                        nArray[0] = n + 1;
                        Thumbnails.this.addImage((IFile)arrayList.get(n));
                        if (Thumbnails.this.gallery != null && !Thumbnails.this.gallery.isDisposed() && nArray[0] < arrayList.size()) {
                            Thumbnails.this.gallery.getDisplay().asyncExec((Runnable)this);
                        }
                    }
                };
                this.gallery.getDisplay().asyncExec(this.runnable);
            }
            catch (CoreException coreException) {
                coreException.printStackTrace();
            }
        }
    }

    private void addImage(IFile iFile) {
        try {
            InputStream inputStream = iFile.getContents();
            try {
                try {
                    ImageData imageData = new ImageData(inputStream);
                    Point point = this.getBestSize(imageData.width, imageData.height, 100, 100);
                    ImageData imageData2 = imageData.scaledTo(point.x, point.y);
                    GalleryItem galleryItem = new GalleryItem(this.group, 0);
                    galleryItem.setText(iFile.getName());
                    Image image = new Image((Device)this.gallery.getDisplay(), imageData2);
                    galleryItem.setImage(image);
                    galleryItem.setData((Object)iFile);
                    this.stylingEngine.setId((Object)galleryItem, null);
                    this.gallery.redraw();
                }
                catch (SWTException sWTException) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        catch (CoreException coreException) {
            coreException.printStackTrace();
        }
    }
}

