/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.indexing;

import org.eclipse.core.internal.indexing.Buffer;
import org.eclipse.core.internal.indexing.Field;
import org.eclipse.core.internal.indexing.IndexedStoreObject;
import org.eclipse.core.internal.indexing.ObjectAddress;
import org.eclipse.core.internal.indexing.ObjectStore;
import org.eclipse.core.internal.indexing.ObjectStoreException;

class BinarySmallObject
extends IndexedStoreObject {
    public static final int TYPE = 5;
    public static final int VALUE_OFFSET = 2;
    protected byte[] value;

    public BinarySmallObject(byte[] byArray) {
        this.value = new Buffer(byArray).get();
    }

    public BinarySmallObject(Field field, ObjectStore objectStore, ObjectAddress objectAddress) throws ObjectStoreException {
        super(field, objectStore, objectAddress);
    }

    protected void insertValues(Field field) {
        super.insertValues(field);
        field.subfield(2).put(this.value);
    }

    protected void extractValues(Field field) throws ObjectStoreException {
        super.extractValues(field);
        this.value = field.subfield(2).get();
    }

    protected int getMaximumSize() {
        return 6002;
    }

    protected int length() {
        return this.value.length + 2;
    }

    protected int getMinimumSize() {
        return 2;
    }

    protected int getRequiredType() {
        return 5;
    }

    public byte[] getValue() {
        return new Field(this.value).get();
    }

    public String toString() {
        int n = 10;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("BSOB(");
        stringBuffer.append(this.value.length);
        stringBuffer.append(" [");
        int n2 = 0;
        while (n2 < this.value.length) {
            if (n2 > 0) {
                stringBuffer.append(" ");
            }
            if (n2 == n) break;
            stringBuffer.append(this.value[n2]);
            ++n2;
        }
        if (this.value.length > n) {
            stringBuffer.append(" ...");
        }
        stringBuffer.append("])");
        return stringBuffer.toString();
    }
}

