/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.indexing;

import org.eclipse.core.internal.indexing.Field;
import org.eclipse.core.internal.indexing.Insertable;

public class Buffer {
    protected byte[] contents;
    private static final byte[] ZEROES = new byte[1024];

    public Buffer(byte[] byArray) {
        this.contents = byArray;
    }

    public Buffer(int n) {
        this.contents = new byte[n];
    }

    public Buffer(Insertable insertable) {
        this.contents = insertable.toByteArray();
    }

    public void clear() {
        Buffer.clear(this.contents, 0, this.contents.length);
    }

    private static void clear(byte[] byArray, int n, int n2) {
        int n3 = n2;
        int n4 = n;
        while (n3 > 0) {
            int n5 = Math.min(ZEROES.length, n3);
            System.arraycopy(ZEROES, 0, byArray, n4, n5);
            n4 += n5;
            n3 -= n5;
        }
    }

    public void clear(int n, int n2) {
        Buffer.clear(this.contents, n, n2);
    }

    private static int compare(byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4) {
        if (n2 < n4) {
            return -Buffer.compare(byArray2, n3, n4, byArray, n, n2);
        }
        int n5 = 0;
        while (n5 < n4) {
            int n6 = byArray[n + n5] & 0xFF;
            int n7 = byArray2[n3 + n5] & 0xFF;
            if (n6 > n7) {
                return 1;
            }
            if (n6 < n7) {
                return -1;
            }
            ++n5;
        }
        if (n2 > n4) {
            return 1;
        }
        return 0;
    }

    public static int compare(Buffer buffer, int n, int n2, Buffer buffer2, int n3, int n4) {
        return Buffer.compare(buffer.contents, n, n2, buffer2.contents, n3, n4);
    }

    public void copyInternal(int n, int n2, int n3) {
        System.arraycopy(this.contents, n, this.contents, n2, n3);
    }

    public void copyTo(byte[] byArray) {
        int n = Math.min(byArray.length, this.contents.length);
        System.arraycopy(this.contents, 0, byArray, 0, n);
    }

    public void copyFrom(byte[] byArray) {
        int n = Math.min(byArray.length, this.contents.length);
        System.arraycopy(byArray, 0, this.contents, 0, n);
    }

    public byte[] get() {
        return this.get(0, this.contents.length);
    }

    public byte[] get(int n, int n2) {
        byte[] byArray = new byte[n2];
        System.arraycopy(this.contents, n, byArray, 0, n2);
        return byArray;
    }

    public Field getField(int n, int n2) {
        return new Field(this, n, n2);
    }

    public byte getByte(int n) {
        return this.contents[n];
    }

    public int getInt(int n, int n2) {
        return (int)this.getLong(n, n2);
    }

    public int getUInt(int n, int n2) {
        int n3 = Math.max(0, 32 - n2 * 8);
        int n4 = -1 >>> n3 & Integer.MAX_VALUE;
        return this.getInt(n, n2) & n4;
    }

    public long getLong(int n, int n2) {
        if (n2 <= 0) {
            return 0L;
        }
        long l = this.contents[n];
        int n3 = n + 1;
        while (n3 < n + n2) {
            l = l << 8 | (long)(this.contents[n3] & 0xFF);
            ++n3;
        }
        return l;
    }

    public byte[] getByteArray() {
        return this.contents;
    }

    public int length() {
        return this.contents.length;
    }

    public void put(int n, byte by) {
        this.contents[n] = by;
    }

    public void put(int n, byte[] byArray) {
        System.arraycopy(byArray, 0, this.contents, n, byArray.length);
    }

    public void put(int n, int n2, byte[] byArray) {
        int n3 = Math.min(n2, byArray.length);
        System.arraycopy(byArray, 0, this.contents, n, n3);
    }

    public void put(int n, int n2, long l) {
        long l2 = l;
        int n3 = n + n2;
        while (n3 > n) {
            this.contents[--n3] = (byte)l2;
            l2 >>>= 8;
        }
    }

    public void put(int n, int n2, int n3) {
        this.put(n, n2, (long)n3);
    }

    public void put(int n, Insertable insertable) {
        this.put(n, insertable.toByteArray());
    }
}

