/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.indexing;

import org.eclipse.core.internal.indexing.Buffer;
import org.eclipse.core.internal.indexing.FieldDef;
import org.eclipse.core.internal.indexing.Insertable;
import org.eclipse.core.internal.indexing.Pointer;

public class Field
implements Insertable {
    protected Buffer buffer;
    protected int offset;
    protected int length;

    public Field(byte[] byArray) {
        this.buffer = new Buffer(byArray);
        this.offset = 0;
        this.length = byArray.length;
    }

    public Field(int n) {
        this.buffer = new Buffer(n);
        this.offset = 0;
        this.length = n;
    }

    public Field(Buffer buffer, int n, int n2) {
        this.buffer = buffer;
        this.offset = n;
        this.length = n2;
    }

    public Field(Insertable insertable) {
        this.buffer = new Buffer(insertable);
        this.offset = 0;
        this.length = this.buffer.length();
    }

    public Field clear() {
        this.buffer.clear(this.offset, this.length);
        return this;
    }

    public int compareTo(Field field) {
        return Buffer.compare(this.buffer, this.offset, this.length, field.buffer, field.offset, field.length);
    }

    public Field subfield(int n, int n2) {
        if (n + n2 > this.length) {
            throw new IllegalArgumentException();
        }
        return this.buffer.getField(this.offset + n, n2);
    }

    public Field subfield(FieldDef fieldDef) {
        if (fieldDef.offset + fieldDef.length > this.length) {
            throw new IllegalArgumentException();
        }
        return this.buffer.getField(this.offset + fieldDef.offset, fieldDef.length);
    }

    public Field subfield(int n) {
        return this.subfield(n, this.length - n);
    }

    public byte[] get() {
        return this.buffer.get(this.offset, this.length);
    }

    public int getInt() {
        return this.buffer.getInt(this.offset, this.length);
    }

    public long getLong() {
        return this.buffer.getLong(this.offset, this.length);
    }

    public int getUInt() {
        return this.buffer.getUInt(this.offset, this.length);
    }

    public byte[] get(FieldDef fieldDef) {
        return this.subfield(fieldDef).get();
    }

    public int getInt(FieldDef fieldDef) {
        return this.subfield(fieldDef).getInt();
    }

    public int length() {
        return this.length;
    }

    public Pointer pointTo(int n) {
        return new Pointer(this.buffer, this.offset + n);
    }

    public Field put(byte[] byArray) {
        this.buffer.put(this.offset, this.length, byArray);
        return this;
    }

    public Field put(int n) {
        this.buffer.put(this.offset, this.length, n);
        return this;
    }

    public Field put(long l) {
        this.buffer.put(this.offset, this.length, l);
        return this;
    }

    public Field put(Insertable insertable) {
        this.put(insertable.toByteArray());
        return this;
    }

    public Field put(FieldDef fieldDef, int n) {
        this.subfield(fieldDef).put(n);
        return this;
    }

    public Field put(FieldDef fieldDef, Insertable insertable) {
        this.subfield(fieldDef).put(insertable.toByteArray());
        return this;
    }

    public byte[] toByteArray() {
        return this.get();
    }
}

