/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.indexing;

import org.eclipse.core.internal.indexing.Buffer;
import org.eclipse.core.internal.indexing.Field;

class FieldArray {
    protected Buffer buffer;
    protected int offset;
    protected int length;
    protected int stride;
    protected int count;

    public FieldArray(Buffer buffer, int n, int n2, int n3, int n4) {
        this.buffer = buffer;
        this.offset = n;
        this.length = n2;
        this.stride = n3;
        this.count = n4;
    }

    public Field fieldAt(int n) {
        if (n >= this.count) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return new Field(this.buffer, this.offset + n * this.stride, this.length);
    }

    public Field insert(int n) {
        ++this.count;
        if (n >= this.count) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int n2 = this.offset + n * this.stride;
        int n3 = n2 + this.stride;
        int n4 = (this.count - (n + 1)) * this.stride;
        this.buffer.copyInternal(n2, n3, n4);
        return this.fieldAt(n).clear();
    }

    public void remove(int n) {
        if (n >= this.count) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int n2 = this.offset + (n + 1) * this.stride;
        int n3 = n2 - this.stride;
        int n4 = (this.count - (n + 1)) * this.stride;
        this.buffer.copyInternal(n2, n3, n4);
        this.fieldAt(this.count - 1).clear();
        --this.count;
    }
}

