/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.indexing;

import java.util.Vector;
import org.eclipse.core.internal.indexing.Convert;
import org.eclipse.core.internal.indexing.IndexAnchor;
import org.eclipse.core.internal.indexing.IndexCursor;
import org.eclipse.core.internal.indexing.IndexedStore;
import org.eclipse.core.internal.indexing.IndexedStoreException;
import org.eclipse.core.internal.indexing.Insertable;
import org.eclipse.core.internal.indexing.ObjectAddress;
import org.eclipse.core.internal.indexing.ObjectID;

public class Index {
    private IndexedStore store;
    private ObjectAddress anchorAddress;

    Index(IndexedStore indexedStore, ObjectAddress objectAddress) {
        this.store = indexedStore;
        this.anchorAddress = objectAddress;
    }

    public synchronized Vector getObjectIdentifiersMatching(byte[] byArray) throws IndexedStoreException {
        IndexCursor indexCursor = this.open();
        indexCursor.find(byArray);
        Vector<ObjectID> vector = new Vector<ObjectID>(20);
        while (indexCursor.keyMatches(byArray)) {
            vector.addElement(indexCursor.getValueAsObjectID());
            indexCursor.next();
        }
        indexCursor.close();
        return vector;
    }

    public synchronized void insert(byte[] byArray, byte[] byArray2) throws IndexedStoreException {
        if (byArray.length > 1024) {
            throw new IndexedStoreException(1);
        }
        if (byArray2.length > 2048) {
            throw new IndexedStoreException(3);
        }
        IndexAnchor indexAnchor = this.store.acquireAnchor(this.anchorAddress);
        indexAnchor.insert(byArray, byArray2);
        indexAnchor.release();
    }

    public synchronized void insert(byte[] byArray, Insertable insertable) throws IndexedStoreException {
        this.insert(byArray, insertable.toByteArray());
    }

    public synchronized void insert(String string, byte[] byArray) throws IndexedStoreException {
        this.insert(Convert.toUTF8(string), byArray);
    }

    public synchronized IndexCursor open() throws IndexedStoreException {
        IndexCursor indexCursor = new IndexCursor(this.store, this.anchorAddress);
        return indexCursor;
    }
}

