/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.indexing;

import org.eclipse.core.internal.indexing.Field;
import org.eclipse.core.internal.indexing.IndexCursor;
import org.eclipse.core.internal.indexing.IndexNode;
import org.eclipse.core.internal.indexing.IndexedStoreException;
import org.eclipse.core.internal.indexing.IndexedStoreObject;
import org.eclipse.core.internal.indexing.ObjectAddress;
import org.eclipse.core.internal.indexing.ObjectStore;
import org.eclipse.core.internal.indexing.ObjectStoreException;

class IndexAnchor
extends IndexedStoreObject {
    public static final int SIZE = 32;
    public static final int TYPE = 1;
    protected static final int RootNodeAddressOffset = 2;
    protected static final int RootNodeAddressLength = 4;
    protected static final int NumberOfEntriesOffset = 14;
    protected static final int NumberOfEntriesLength = 4;
    protected Field numberOfEntriesField;
    protected int numberOfEntries;
    protected Field rootNodeAddressField;
    protected ObjectAddress rootNodeAddress;

    public IndexAnchor() {
        this.numberOfEntries = 0;
        this.rootNodeAddress = ObjectAddress.Null;
    }

    public IndexAnchor(Field field, ObjectStore objectStore, ObjectAddress objectAddress) throws ObjectStoreException {
        super(field, objectStore, objectAddress);
    }

    private void setFields(Field field) {
        this.rootNodeAddressField = field.subfield(2, 4);
        this.numberOfEntriesField = field.subfield(14, 4);
    }

    protected void insertValues(Field field) {
        super.insertValues(field);
        this.setFields(field);
        this.numberOfEntriesField.put(this.numberOfEntries);
        this.rootNodeAddressField.put(this.rootNodeAddress);
    }

    protected void extractValues(Field field) throws ObjectStoreException {
        super.extractValues(field);
        this.setFields(field);
        this.numberOfEntries = this.numberOfEntriesField.getInt();
        this.rootNodeAddress = new ObjectAddress(this.rootNodeAddressField.get());
    }

    protected int getMinimumSize() {
        return 32;
    }

    protected int getRequiredType() {
        return 1;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Anchor(");
        stringBuffer.append(this.numberOfEntries);
        stringBuffer.append(",");
        stringBuffer.append(this.rootNodeAddress);
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    void entryInserted(IndexNode indexNode) {
        if (indexNode.isLeaf()) {
            ++this.numberOfEntries;
            this.setChanged();
        }
    }

    void entryRemoved(IndexNode indexNode) {
        if (indexNode.isLeaf()) {
            --this.numberOfEntries;
            this.setChanged();
        }
    }

    void setRootNodeAddress(ObjectAddress objectAddress) {
        this.rootNodeAddress = objectAddress;
        this.setChanged();
    }

    void find(byte[] byArray, IndexCursor indexCursor) throws IndexedStoreException {
        if (this.rootNodeAddress.isNull()) {
            indexCursor.reset();
        } else {
            IndexNode indexNode = this.acquireNode(this.rootNodeAddress);
            indexNode.find(byArray, indexCursor);
            indexNode.release();
        }
    }

    void findFirstEntry(IndexCursor indexCursor) throws IndexedStoreException {
        if (this.rootNodeAddress.isNull()) {
            indexCursor.reset();
        } else {
            IndexNode indexNode = this.acquireNode(this.rootNodeAddress);
            indexNode.findFirstEntry(indexCursor);
            indexNode.release();
        }
    }

    void insert(byte[] byArray, byte[] byArray2) throws IndexedStoreException {
        IndexNode indexNode;
        if (this.rootNodeAddress.isNull()) {
            indexNode = new IndexNode(this.address);
            try {
                this.store.insertObject(indexNode);
            }
            catch (ObjectStoreException objectStoreException) {
                throw new IndexedStoreException(8, (Throwable)objectStoreException);
            }
            this.rootNodeAddress = indexNode.getAddress();
        }
        indexNode = this.acquireNode(this.rootNodeAddress);
        indexNode.insertEntry(byArray, byArray2);
        indexNode.release();
    }
}

