/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.indexing;

import org.eclipse.core.internal.indexing.Convert;
import org.eclipse.core.internal.indexing.IndexAnchor;
import org.eclipse.core.internal.indexing.IndexNode;
import org.eclipse.core.internal.indexing.IndexedStore;
import org.eclipse.core.internal.indexing.IndexedStoreException;
import org.eclipse.core.internal.indexing.Insertable;
import org.eclipse.core.internal.indexing.ObjectAddress;
import org.eclipse.core.internal.indexing.ObjectID;

public class IndexCursor {
    private IndexedStore store;
    private ObjectAddress anchorAddress;
    private int entryNumber;
    private IndexNode leafNode;
    private boolean entryRemoved;

    IndexCursor(IndexedStore indexedStore, ObjectAddress objectAddress) {
        this.anchorAddress = objectAddress;
        this.store = indexedStore;
        this.leafNode = null;
        this.entryNumber = -1;
    }

    private void adjust() throws IndexedStoreException {
        if (this.leafNode == null) {
            return;
        }
        if (this.entryNumber >= this.leafNode.getNumberOfEntries()) {
            ObjectAddress objectAddress = this.leafNode.getNextAddress();
            int n = this.entryNumber - this.leafNode.getNumberOfEntries();
            this.set(objectAddress, n);
        } else if (this.entryNumber < 0) {
            ObjectAddress objectAddress = this.leafNode.getPreviousAddress();
            int n = this.entryNumber;
            this.set(objectAddress, n);
        }
    }

    public void close() throws IndexedStoreException {
        this.reset();
    }

    void entryInserted(int n) throws IndexedStoreException {
        if (this.entryNumber >= n) {
            ++this.entryNumber;
        }
        this.adjust();
    }

    void entryRemoved(int n) throws IndexedStoreException {
        boolean bl = this.entryRemoved = this.entryNumber == n;
        if (this.entryNumber > n) {
            --this.entryNumber;
        }
        this.adjust();
    }

    public synchronized IndexCursor find(byte[] byArray) throws IndexedStoreException {
        IndexAnchor indexAnchor = this.store.acquireAnchor(this.anchorAddress);
        indexAnchor.find(byArray, this);
        indexAnchor.release();
        this.entryRemoved = false;
        return this;
    }

    public synchronized IndexCursor find(String string) throws IndexedStoreException {
        return this.find(Convert.toUTF8(string));
    }

    public synchronized IndexCursor findFirstEntry() throws IndexedStoreException {
        IndexAnchor indexAnchor = this.store.acquireAnchor(this.anchorAddress);
        indexAnchor.findFirstEntry(this);
        indexAnchor.release();
        this.entryRemoved = false;
        return this;
    }

    public synchronized byte[] getKey() throws IndexedStoreException {
        if (this.entryRemoved) {
            throw new IndexedStoreException(33);
        }
        if (this.leafNode == null) {
            return null;
        }
        byte[] byArray = this.leafNode.getKey(this.entryNumber);
        return byArray;
    }

    public synchronized byte[] getValue() throws IndexedStoreException {
        if (this.entryRemoved) {
            throw new IndexedStoreException(33);
        }
        if (this.leafNode == null) {
            return null;
        }
        byte[] byArray = this.leafNode.getValue(this.entryNumber);
        return byArray;
    }

    ObjectAddress getValueAsObjectAddress() throws IndexedStoreException {
        byte[] byArray = this.getValue();
        if (byArray == null) {
            return null;
        }
        return new ObjectAddress(byArray);
    }

    public synchronized ObjectID getValueAsObjectID() throws IndexedStoreException {
        byte[] byArray = this.getValue();
        if (byArray == null) {
            return null;
        }
        return new ObjectID(byArray);
    }

    public synchronized boolean isAtBeginning() throws IndexedStoreException {
        if (this.entryRemoved) {
            throw new IndexedStoreException(33);
        }
        return this.leafNode == null;
    }

    public synchronized boolean isSet() throws IndexedStoreException {
        if (this.entryRemoved) {
            throw new IndexedStoreException(33);
        }
        return this.leafNode != null;
    }

    public synchronized boolean keyEquals(byte[] byArray) throws IndexedStoreException {
        if (this.entryRemoved) {
            throw new IndexedStoreException(33);
        }
        if (this.leafNode == null) {
            return false;
        }
        byte[] byArray2 = this.leafNode.getKey(this.entryNumber);
        if (byArray.length != byArray2.length) {
            return false;
        }
        int n = 0;
        while (n < byArray.length) {
            if (byArray2[n] != byArray[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public synchronized boolean keyMatches(byte[] byArray) throws IndexedStoreException {
        if (this.entryRemoved) {
            throw new IndexedStoreException(33);
        }
        if (this.leafNode == null) {
            return false;
        }
        byte[] byArray2 = this.leafNode.getKey(this.entryNumber);
        if (byArray2.length < byArray.length) {
            return false;
        }
        int n = 0;
        while (n < byArray.length) {
            if (byArray2[n] != byArray[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public synchronized boolean keyMatches(String string) throws IndexedStoreException {
        return this.keyMatches(Convert.toUTF8(string));
    }

    public synchronized IndexCursor next() throws IndexedStoreException {
        if (this.isAtBeginning()) {
            this.findFirstEntry();
        } else {
            ++this.entryNumber;
            this.adjust();
        }
        return this;
    }

    void nodeSplit() throws IndexedStoreException {
        this.adjust();
    }

    public synchronized void remove() throws IndexedStoreException {
        this.removeEntry();
    }

    void removeEntry() throws IndexedStoreException {
        if (this.entryRemoved) {
            throw new IndexedStoreException(33);
        }
        if (this.leafNode == null) {
            return;
        }
        ObjectAddress objectAddress = this.leafNode.getAddress();
        this.leafNode.removeEntry(this.entryNumber);
        this.entryRemoved = false;
        while (!objectAddress.isNull()) {
            IndexNode indexNode = this.store.acquireNode(objectAddress);
            if (indexNode.getNumberOfEntries() > 0) {
                indexNode.release();
                break;
            }
            ObjectAddress objectAddress2 = indexNode.getParentAddress();
            indexNode.unlink();
            indexNode.release();
            this.store.removeObject(objectAddress);
            objectAddress = objectAddress2;
        }
    }

    public synchronized void reset() throws IndexedStoreException {
        this.unset();
        this.entryRemoved = false;
    }

    void set(ObjectAddress objectAddress, int n) throws IndexedStoreException {
        this.unset();
        if (objectAddress.isNull()) {
            return;
        }
        this.leafNode = this.store.acquireNode(objectAddress);
        this.leafNode.addCursor(this);
        this.entryNumber = n >= 0 ? n : this.leafNode.getNumberOfEntries() + n;
        this.adjust();
    }

    private void unset() throws IndexedStoreException {
        if (this.leafNode != null) {
            this.leafNode.removeCursor(this);
            this.leafNode.release();
        }
        this.entryNumber = -1;
        this.leafNode = null;
        this.entryRemoved = false;
    }

    void updateEntry(byte[] byArray) throws IndexedStoreException {
        if (this.entryRemoved) {
            throw new IndexedStoreException(33);
        }
        if (byArray.length > 2048) {
            throw new IndexedStoreException(3);
        }
        if (this.leafNode == null) {
            return;
        }
        this.leafNode.updateValueAt(this.entryNumber, byArray);
    }

    public synchronized void updateValue(byte[] byArray) throws IndexedStoreException {
        this.updateEntry(byArray);
    }

    public synchronized void updateValue(Insertable insertable) throws IndexedStoreException {
        this.updateValue(insertable.toByteArray());
    }
}

