/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.indexing;

import java.util.HashSet;
import org.eclipse.core.internal.indexing.Buffer;
import org.eclipse.core.internal.indexing.Field;
import org.eclipse.core.internal.indexing.FieldArray;
import org.eclipse.core.internal.indexing.FieldDef;
import org.eclipse.core.internal.indexing.IndexAnchor;
import org.eclipse.core.internal.indexing.IndexCursor;
import org.eclipse.core.internal.indexing.IndexedStoreException;
import org.eclipse.core.internal.indexing.IndexedStoreObject;
import org.eclipse.core.internal.indexing.Insertable;
import org.eclipse.core.internal.indexing.ObjectAddress;
import org.eclipse.core.internal.indexing.ObjectStore;
import org.eclipse.core.internal.indexing.ObjectStoreException;
import org.eclipse.core.internal.indexing.Pointer;

class IndexNode
extends IndexedStoreObject {
    public static final int SIZE = 7612;
    public static final int TYPE = 3;
    private static final int EntriesFieldOffset = 64;
    private static final int EntriesFieldSize = 7548;
    private static final FieldDef NodeType = new FieldDef(2, 2, 2);
    private static final FieldDef AnchorAddress = new FieldDef(5, 4, 4);
    private static final FieldDef ParentAddress = new FieldDef(5, 8, 4);
    private static final FieldDef PreviousAddress = new FieldDef(5, 12, 4);
    private static final FieldDef NextAddress = new FieldDef(5, 16, 4);
    private static final FieldDef NumberOfEntries = new FieldDef(2, 20, 2);
    private static final FieldDef UsedSpace = new FieldDef(2, 22, 2);
    private static final FieldDef UsedSpaceMax = new FieldDef(2, 24, 2);
    private static final FieldDef EntriesField = new FieldDef(5, 64, 7548);
    private int nodeType;
    private ObjectAddress anchorAddress;
    private ObjectAddress parentAddress;
    private ObjectAddress previousAddress;
    private ObjectAddress nextAddress;
    private int numberOfEntries;
    private int usedSpace;
    private int usedSpaceMax;
    private Field entriesField;
    private static final int RootNode = 1;
    private static final int InteriorNode = 2;
    private static final int LeafNode = 3;
    private static final int DescriptorLength = 6;
    private HashSet cursors = new HashSet();

    IndexNode(Field field, ObjectStore objectStore, ObjectAddress objectAddress) throws ObjectStoreException {
        super(field, objectStore, objectAddress);
    }

    IndexNode(ObjectAddress objectAddress) {
        this.anchorAddress = objectAddress;
        this.parentAddress = ObjectAddress.Null;
        this.previousAddress = ObjectAddress.Null;
        this.nextAddress = ObjectAddress.Null;
        this.usedSpace = 0;
        this.usedSpaceMax = 0;
        this.numberOfEntries = 0;
        this.nodeType = 1;
        this.entriesField = new Field(7548);
    }

    IndexNode(ObjectAddress objectAddress, ObjectAddress objectAddress2) {
        this(objectAddress);
        this.parentAddress = objectAddress2;
        this.nodeType = 2;
    }

    IndexNode(ObjectAddress objectAddress, ObjectAddress objectAddress2, ObjectAddress objectAddress3, ObjectAddress objectAddress4) {
        this(objectAddress, objectAddress2);
        this.previousAddress = objectAddress3;
        this.nextAddress = objectAddress4;
        this.nodeType = 3;
    }

    void addCursor(IndexCursor indexCursor) {
        this.cursors.add(indexCursor);
    }

    private int compareEntryToKey(int n, byte[] byArray) throws IndexedStoreException {
        Field field = new Field(byArray);
        Field field2 = this.getKeyField(n);
        return field2.compareTo(field);
    }

    private void compress() throws IndexedStoreException {
        int n = this.entriesField.length();
        int n2 = this.numberOfEntries * 6;
        Field field = new Field(this.entriesField.length());
        IndexNode.copyEntries(this.entriesField, 0, this.numberOfEntries, field);
        this.entriesField.put(field.get());
        this.usedSpaceMax = this.usedSpace;
        int n3 = n - (n2 + this.usedSpaceMax);
        Field field2 = this.entriesField.subfield(n2, n3);
        field2.clear();
        this.setChanged();
    }

    private void compress(int n) throws IndexedStoreException {
        int n2;
        int n3 = this.entriesField.length();
        int n4 = n3 - ((n2 = this.numberOfEntries * 6) + this.usedSpaceMax);
        if (n4 >= n) {
            return;
        }
        this.compress();
    }

    private static int copyEntries(Field field, int n, int n2, Field field2) {
        Pointer pointer = field2.pointTo(0);
        Pointer pointer2 = field.pointTo(n * 6);
        int n3 = field2.length();
        int n4 = 0;
        while (n4 < n2) {
            int n5 = pointer2.getField(0, 2).getUInt();
            int n6 = pointer2.getField(2, 2).getUInt();
            int n7 = pointer2.getField(4, 2).getUInt();
            int n8 = n6 + n7;
            Field field3 = field.subfield(n5, n8);
            Field field4 = field2.subfield(n3 -= n8, n8);
            field4.put(field3.get());
            pointer.getField(0, 2).put(n3);
            pointer.getField(2, 2).put(n6);
            pointer.getField(4, 2).put(n7);
            pointer.inc(6);
            pointer2.inc(6);
            ++n4;
        }
        return field2.length() - n3;
    }

    protected void insertValues(Field field) {
        super.insertValues(field);
        field.put(AnchorAddress, this.anchorAddress);
        field.put(ParentAddress, this.parentAddress);
        field.put(NextAddress, this.nextAddress);
        field.put(PreviousAddress, this.previousAddress);
        field.put(NodeType, this.nodeType);
        field.put(NumberOfEntries, this.numberOfEntries);
        field.put(UsedSpace, this.usedSpace);
        field.put(UsedSpaceMax, this.usedSpaceMax);
        field.put(EntriesField, this.entriesField);
    }

    void destroyChildren() throws IndexedStoreException {
        if (!this.isLeaf()) {
            int n = 0;
            while (n < this.numberOfEntries) {
                ObjectAddress objectAddress = new ObjectAddress(this.getValue(n));
                IndexNode indexNode = this.acquireNode(objectAddress);
                indexNode.destroyChildren();
                indexNode.release();
                this.removeObject(objectAddress);
                ++n;
            }
        }
    }

    void find(byte[] byArray, IndexCursor indexCursor) throws IndexedStoreException {
        int n = this.findLastEntryLT(byArray);
        if (this.isLeaf()) {
            indexCursor.set(this.address, n + 1);
        } else if (n >= 0) {
            IndexNode indexNode = this.acquireNode(new ObjectAddress(this.getValue(n)));
            indexNode.find(byArray, indexCursor);
            indexNode.release();
        } else if (this.numberOfEntries > 0) {
            IndexNode indexNode = this.acquireNode(new ObjectAddress(this.getValue(0)));
            indexNode.find(byArray, indexCursor);
            indexNode.release();
        } else {
            indexCursor.reset();
        }
    }

    void findFirstEntry(IndexCursor indexCursor) throws IndexedStoreException {
        if (this.numberOfEntries == 0) {
            indexCursor.reset();
        } else if (!this.isLeaf()) {
            IndexNode indexNode = this.acquireNode(new ObjectAddress(this.getValue(0)));
            indexNode.findFirstEntry(indexCursor);
            indexNode.release();
        } else {
            indexCursor.set(this.address, 0);
        }
    }

    private int findFirstEntryGT(byte[] byArray) throws IndexedStoreException {
        int n = 0;
        int n2 = this.numberOfEntries - 1;
        while (n <= n2) {
            int n3 = (n + n2) / 2;
            int n4 = this.compareEntryToKey(n3, byArray);
            if (n4 <= 0) {
                n = n3 + 1;
                continue;
            }
            n2 = n3 - 1;
        }
        return n;
    }

    void findLastEntry(IndexCursor indexCursor) throws IndexedStoreException {
        if (this.numberOfEntries == 0) {
            indexCursor.reset();
            return;
        }
        int n = this.numberOfEntries - 1;
        if (!this.isLeaf()) {
            IndexNode indexNode = this.acquireNode(new ObjectAddress(this.getValue(n)));
            indexNode.findLastEntry(indexCursor);
            indexNode.release();
        } else {
            indexCursor.set(this.address, n);
        }
    }

    private int findLastEntryLT(byte[] byArray) throws IndexedStoreException {
        int n = 0;
        int n2 = this.numberOfEntries - 1;
        Field field = new Field(byArray);
        while (n <= n2) {
            int n3 = (n + n2) / 2;
            int n4 = this.getKeyField(n3).compareTo(field);
            if (n4 < 0) {
                n = n3 + 1;
                continue;
            }
            n2 = n3 - 1;
        }
        return n2;
    }

    private Field getDescriptor(int n) {
        return this.entriesField.subfield(n * 6, 6);
    }

    private FieldArray getDescriptorArray() {
        return this.entriesField.pointTo(0).getArray(6, 6, this.numberOfEntries);
    }

    private Field getEntriesField() {
        return this.entriesField;
    }

    byte[] getKey(int n) {
        return this.getKeyField(n).get();
    }

    private Field getKeyField(int n) {
        int n2 = n * 6;
        Buffer buffer = this.entriesField.buffer;
        return this.entriesField.subfield(buffer.getUInt(n2, 2), buffer.getUInt(n2 + 2, 2));
    }

    private Field getKeyValueField(int n) {
        Field field = this.getDescriptor(n);
        int n2 = field.subfield(0, 2).getUInt();
        int n3 = field.subfield(2, 2).getUInt();
        int n4 = field.subfield(4, 2).getUInt();
        return this.entriesField.subfield(n2, n3 + n4);
    }

    private byte[] getLowKey() {
        if (this.numberOfEntries == 0) {
            return new byte[0];
        }
        return this.getKey(0);
    }

    protected int getMinimumSize() {
        return 7612;
    }

    ObjectAddress getNextAddress() {
        return this.nextAddress;
    }

    int getNumberOfEntries() {
        return this.numberOfEntries;
    }

    int getNumberOfNodes() throws IndexedStoreException {
        if (this.isLeaf()) {
            return 1;
        }
        int n = 0;
        int n2 = 0;
        while (n2 < this.numberOfEntries) {
            ObjectAddress objectAddress = new ObjectAddress(this.getValue(n2));
            IndexNode indexNode = this.acquireNode(objectAddress);
            n += indexNode.getNumberOfNodes();
            indexNode.release();
            ++n2;
        }
        return n + 1;
    }

    ObjectAddress getParentAddress() {
        return this.parentAddress;
    }

    ObjectAddress getPreviousAddress() {
        return this.previousAddress;
    }

    protected int getRequiredType() {
        return 3;
    }

    private int getUsedSpace() {
        return this.usedSpace;
    }

    byte[] getValue(int n) {
        return this.getValueField(n).get();
    }

    private Field getValueField(int n) {
        Field field = this.getDescriptor(n);
        int n2 = field.subfield(0, 2).getUInt();
        int n3 = field.subfield(2, 2).getUInt();
        int n4 = field.subfield(4, 2).getUInt();
        int n5 = n2 + n3;
        return this.entriesField.subfield(n5, n4);
    }

    void insertEntry(byte[] byArray, byte[] byArray2) throws IndexedStoreException {
        int n = this.findFirstEntryGT(byArray);
        if (this.isLeaf()) {
            this.insertEntryBefore(n, byArray, byArray2);
            Object[] objectArray = this.cursors.toArray();
            int n2 = 0;
            while (n2 < objectArray.length) {
                IndexCursor indexCursor = (IndexCursor)objectArray[n2];
                indexCursor.entryInserted(n);
                ++n2;
            }
            IndexAnchor indexAnchor = this.acquireAnchor(this.anchorAddress);
            indexAnchor.entryInserted(this);
            indexAnchor.release();
        } else {
            IndexNode indexNode;
            ObjectAddress objectAddress = null;
            if (this.getNumberOfEntries() == 0) {
                indexNode = new IndexNode(this.anchorAddress, this.address, ObjectAddress.Null, ObjectAddress.Null);
                objectAddress = this.insertObject(indexNode);
            } else {
                objectAddress = new ObjectAddress(this.getValue(Math.max(0, n - 1)));
            }
            indexNode = this.acquireNode(objectAddress);
            indexNode.insertEntry(byArray, byArray2);
            indexNode.release();
        }
    }

    private void insertEntryBefore(int n, byte[] byArray, byte[] byArray2) throws IndexedStoreException {
        int n2;
        int n3;
        Field field = this.entriesField;
        int n4 = field.length();
        int n5 = n4 - (this.numberOfEntries * 6 + this.usedSpace);
        if (n5 < (n3 = (n2 = byArray.length + byArray2.length) + 6)) {
            ObjectAddress objectAddress = this.split();
            if (n > this.numberOfEntries) {
                Insertable insertable;
                if (!this.isLeaf()) {
                    insertable = new ObjectAddress(byArray2);
                    IndexNode indexNode = this.acquireNode((ObjectAddress)insertable);
                    indexNode.setParentAddress(objectAddress);
                    indexNode.release();
                }
                insertable = this.acquireNode(objectAddress);
                ((IndexNode)insertable).insertEntryBefore(n - this.getNumberOfEntries(), byArray, byArray2);
                ((IndexedStoreObject)insertable).release();
            } else {
                this.insertEntryBefore(n, byArray, byArray2);
            }
            return;
        }
        this.compress(n3);
        Pointer pointer = field.pointTo(n4 - this.usedSpaceMax);
        pointer.dec(byArray2.length).put(byArray2);
        pointer.dec(byArray.length).put(byArray);
        this.usedSpaceMax += n2;
        this.usedSpace += n2;
        Field field2 = this.getDescriptorArray().insert(n);
        ++this.numberOfEntries;
        field2.subfield(0, 2).put(n4 - this.usedSpaceMax);
        field2.subfield(2, 2).put(byArray.length);
        field2.subfield(4, 2).put(byArray2.length);
        if (n == 0 && !this.parentAddress.isNull()) {
            IndexNode indexNode = this.acquireNode(this.parentAddress);
            if (this.numberOfEntries == 1) {
                indexNode.insertKeyForChild(this.address, byArray);
            } else {
                indexNode.updateKeyForChild(this.getKey(1), this.address, byArray);
            }
            indexNode.release();
        }
        this.setChanged();
    }

    private void insertKeyForChild(ObjectAddress objectAddress, byte[] byArray) throws IndexedStoreException {
        int n = this.findFirstEntryGT(byArray);
        this.insertEntryBefore(n, byArray, objectAddress.toByteArray());
        if (n == 0 && !this.parentAddress.isNull()) {
            IndexNode indexNode = this.acquireNode(this.parentAddress);
            indexNode.updateKeyForChild(this.getKey(1), this.address, byArray);
            indexNode.release();
        }
    }

    boolean isInterior() {
        return this.nodeType == 2;
    }

    boolean isLeaf() {
        return this.nodeType == 3;
    }

    boolean isRoot() {
        return this.nodeType == 1;
    }

    protected void extractValues(Field field) throws ObjectStoreException {
        super.extractValues(field);
        this.anchorAddress = new ObjectAddress(field.get(AnchorAddress));
        this.parentAddress = new ObjectAddress(field.get(ParentAddress));
        this.nextAddress = new ObjectAddress(field.get(NextAddress));
        this.previousAddress = new ObjectAddress(field.get(PreviousAddress));
        this.nodeType = field.getInt(NodeType);
        this.numberOfEntries = field.getInt(NumberOfEntries);
        this.usedSpace = field.getInt(UsedSpace);
        this.usedSpaceMax = field.getInt(UsedSpaceMax);
        this.entriesField = new Field(field.get(EntriesField));
    }

    void removeCursor(IndexCursor indexCursor) {
        this.cursors.remove(indexCursor);
    }

    void removeEntry(int n) throws IndexedStoreException {
        Object object;
        byte[] byArray = this.getKey(n);
        Field field = this.getKeyValueField(n);
        field.clear();
        this.usedSpace -= field.length();
        this.getDescriptorArray().remove(n);
        --this.numberOfEntries;
        if (n == 0 && !this.parentAddress.isNull()) {
            object = this.acquireNode(this.parentAddress);
            if (this.numberOfEntries > 0) {
                super.updateKeyForChild(byArray, this.address, this.getKey(0));
            } else {
                super.removeKeyForChild(this.address);
            }
            ((IndexedStoreObject)object).release();
        }
        object = this.cursors.toArray();
        int n2 = 0;
        while (n2 < ((Object[])object).length) {
            IndexCursor indexCursor = (IndexCursor)object[n2];
            indexCursor.entryRemoved(n);
            ++n2;
        }
        IndexAnchor indexAnchor = this.acquireAnchor(this.anchorAddress);
        indexAnchor.entryRemoved(this);
        indexAnchor.release();
        this.setChanged();
    }

    private void removeKeyForChild(ObjectAddress objectAddress) throws IndexedStoreException {
        Field field = new Field(objectAddress);
        int n = 0;
        while (n < this.numberOfEntries) {
            if (this.getValueField(n).compareTo(field) == 0) break;
            ++n;
        }
        if (n < this.numberOfEntries) {
            this.removeEntry(n);
        }
    }

    private void setNextAddress(ObjectAddress objectAddress) {
        this.nextAddress = objectAddress;
        this.setChanged();
    }

    private void setNodeType(int n) {
        this.nodeType = n;
        this.setChanged();
    }

    private void setNumberOfEntries(int n) {
        this.numberOfEntries = n;
        this.setChanged();
    }

    private void setParentAddress(ObjectAddress objectAddress) {
        this.parentAddress = objectAddress;
        this.setChanged();
    }

    private void setPreviousAddress(ObjectAddress objectAddress) {
        this.previousAddress = objectAddress;
        this.setChanged();
    }

    private void setUsedSpace(int n) {
        this.usedSpace = n;
        this.setChanged();
    }

    private void setUsedSpaceMax(int n) {
        this.usedSpaceMax = n;
        this.setChanged();
    }

    private ObjectAddress split() throws IndexedStoreException {
        Object[] objectArray;
        IndexNode indexNode;
        Insertable insertable;
        IndexNode indexNode2;
        ObjectAddress objectAddress;
        int n = this.numberOfEntries;
        if (n < 2) {
            throw new IndexedStoreException(7);
        }
        if (this.isRoot()) {
            this.parentAddress = objectAddress = this.insertObject(new IndexNode(this.anchorAddress));
            this.nodeType = 2;
            indexNode2 = this.acquireNode(objectAddress);
            indexNode2.insertKeyForChild(this.address, this.getLowKey());
            indexNode2.release();
            insertable = this.acquireAnchor(this.anchorAddress);
            ((IndexAnchor)insertable).setRootNodeAddress(objectAddress);
            ((IndexedStoreObject)insertable).release();
        }
        objectAddress = this.insertObject(new IndexNode(this.anchorAddress, this.parentAddress));
        indexNode2 = this.acquireNode(objectAddress);
        insertable = this.entriesField;
        Field field = indexNode2.getEntriesField();
        int n2 = n / 2;
        indexNode2.setUsedSpace(IndexNode.copyEntries((Field)insertable, n - n2, n2, field));
        indexNode2.setUsedSpaceMax(indexNode2.getUsedSpace());
        indexNode2.setNumberOfEntries(n2);
        this.usedSpace -= indexNode2.getUsedSpace();
        this.numberOfEntries = n - n2;
        this.compress();
        if (this.isLeaf()) {
            indexNode2.setNodeType(3);
            indexNode2.setNextAddress(this.nextAddress);
            indexNode2.setPreviousAddress(this.address);
            if (!this.nextAddress.isNull()) {
                indexNode = this.acquireNode(this.nextAddress);
                indexNode.setPreviousAddress(objectAddress);
                indexNode.release();
            }
            this.nextAddress = objectAddress;
        }
        if (!this.isLeaf()) {
            int n3 = 0;
            while (n3 < n2) {
                objectArray = new ObjectAddress(indexNode2.getValue(n3));
                IndexNode indexNode3 = this.acquireNode((ObjectAddress)objectArray);
                indexNode3.setParentAddress(objectAddress);
                indexNode3.release();
                ++n3;
            }
        }
        indexNode = this.acquireNode(this.parentAddress);
        indexNode.insertKeyForChild(objectAddress, indexNode2.getLowKey());
        indexNode.release();
        indexNode2.release();
        objectArray = this.cursors.toArray();
        int n4 = 0;
        while (n4 < objectArray.length) {
            IndexCursor indexCursor = (IndexCursor)objectArray[n4];
            indexCursor.nodeSplit();
            ++n4;
        }
        this.setChanged();
        return objectAddress;
    }

    void unlink() throws IndexedStoreException {
        IndexedStoreObject indexedStoreObject;
        if (this.isRoot()) {
            indexedStoreObject = this.acquireAnchor(this.anchorAddress);
            ((IndexAnchor)indexedStoreObject).setRootNodeAddress(ObjectAddress.Null);
            indexedStoreObject.release();
        }
        if (!this.parentAddress.isNull()) {
            indexedStoreObject = this.acquireNode(this.parentAddress);
            super.removeKeyForChild(this.address);
            indexedStoreObject.release();
        }
        if (!this.nextAddress.isNull()) {
            indexedStoreObject = this.acquireNode(this.nextAddress);
            super.setPreviousAddress(this.previousAddress);
            indexedStoreObject.release();
        }
        if (!this.previousAddress.isNull()) {
            indexedStoreObject = this.acquireNode(this.previousAddress);
            super.setNextAddress(this.nextAddress);
            indexedStoreObject.release();
        }
    }

    private void updateEntry(int n, byte[] byArray, byte[] byArray2) throws IndexedStoreException {
        int n2;
        int n3;
        int n4;
        Field field = this.entriesField;
        int n5 = field.length();
        int n6 = n5 - (this.numberOfEntries * 6 + this.usedSpace);
        if (n6 < (n4 = (n3 = byArray.length + byArray2.length) - (n2 = this.getKeyValueField(n).length()))) {
            ObjectAddress objectAddress = this.split();
            if (n >= this.numberOfEntries) {
                IndexNode indexNode = this.acquireNode(objectAddress);
                indexNode.updateEntry(n - this.getNumberOfEntries(), byArray, byArray2);
                indexNode.release();
            } else {
                this.updateEntry(n, byArray, byArray2);
            }
            return;
        }
        Field field2 = this.getKeyValueField(n);
        field2.clear();
        Field field3 = this.getDescriptor(n);
        field3.clear();
        this.usedSpace -= n2;
        this.compress(n3);
        Pointer pointer = field.pointTo(n5 - this.usedSpaceMax);
        pointer.dec(byArray2.length).put(byArray2);
        pointer.dec(byArray.length).put(byArray);
        this.usedSpaceMax += n3;
        this.usedSpace += n3;
        field3.subfield(0, 2).put(n5 - this.usedSpaceMax);
        field3.subfield(2, 2).put(byArray.length);
        field3.subfield(4, 2).put(byArray2.length);
        this.setChanged();
    }

    private void updateKeyAt(int n, byte[] byArray) throws IndexedStoreException {
        this.updateEntry(n, byArray, this.getValue(n));
    }

    private void updateKeyForChild(byte[] byArray, ObjectAddress objectAddress, byte[] byArray2) throws IndexedStoreException {
        Field field = new Field(objectAddress.toByteArray());
        int n = this.findLastEntryLT(byArray) + 1;
        while (n < this.numberOfEntries) {
            if (this.getValueField(n).compareTo(field) == 0) break;
            ++n;
        }
        if (n < this.numberOfEntries) {
            this.updateKeyAt(n, byArray2);
            if (n == 0 && !this.parentAddress.isNull()) {
                IndexNode indexNode = this.acquireNode(this.parentAddress);
                indexNode.updateKeyForChild(byArray, this.address, byArray2);
                indexNode.release();
            }
        }
    }

    void updateValueAt(int n, byte[] byArray) throws IndexedStoreException {
        this.updateEntry(n, this.getKey(n), byArray);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.isLeaf()) {
            stringBuffer.append("LeafNode");
        }
        if (this.isRoot()) {
            stringBuffer.append("RootNode");
        }
        if (this.isInterior()) {
            stringBuffer.append("InteriorNode");
        }
        stringBuffer.append("\n  Address = ");
        stringBuffer.append(this.address);
        stringBuffer.append("\n  AnchorAddress = ");
        stringBuffer.append(this.anchorAddress);
        stringBuffer.append("\n  ParentAddress = ");
        stringBuffer.append(this.parentAddress);
        stringBuffer.append("\n  PreviousAddress = ");
        stringBuffer.append(this.previousAddress);
        stringBuffer.append("\n  NextAddress = ");
        stringBuffer.append(this.nextAddress);
        stringBuffer.append("\n  NumberOfEntries = ");
        stringBuffer.append(this.numberOfEntries);
        stringBuffer.append("\n  UsedSpace = ");
        stringBuffer.append(this.usedSpace);
        stringBuffer.append("\n  UsedSpaceMax = ");
        stringBuffer.append(this.usedSpaceMax);
        return stringBuffer.toString();
    }
}

