/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.indexing;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.internal.indexing.BinarySmallObject;
import org.eclipse.core.internal.indexing.Buffer;
import org.eclipse.core.internal.indexing.Convert;
import org.eclipse.core.internal.indexing.Field;
import org.eclipse.core.internal.indexing.Index;
import org.eclipse.core.internal.indexing.IndexAnchor;
import org.eclipse.core.internal.indexing.IndexCursor;
import org.eclipse.core.internal.indexing.IndexNode;
import org.eclipse.core.internal.indexing.IndexedStoreContext;
import org.eclipse.core.internal.indexing.IndexedStoreException;
import org.eclipse.core.internal.indexing.IndexedStoreObjectPolicy;
import org.eclipse.core.internal.indexing.ObjectAddress;
import org.eclipse.core.internal.indexing.ObjectID;
import org.eclipse.core.internal.indexing.ObjectStore;
import org.eclipse.core.internal.indexing.ObjectStoreException;
import org.eclipse.core.internal.indexing.StoredObject;

public class IndexedStore {
    private static final int CurrentVersion = 1;
    private static final int MetadataID = 2;
    private static final Map registry = Collections.synchronizedMap(new HashMap());
    private static final ObjectAddress ContextAddress10 = new ObjectAddress(1, 0);
    private static final ObjectAddress ContextAddress11 = new ObjectAddress(1, 1);
    private ObjectAddress objectDirectoryAddress;
    private Index objectDirectory;
    private IndexCursor objectDirectoryCursor;
    private ObjectAddress indexDirectoryAddress;
    private Index indexDirectory;
    private IndexCursor indexDirectoryCursor;
    private ObjectAddress contextAddress;
    private ObjectStore objectStore;
    private String name;

    IndexAnchor acquireAnchor(ObjectAddress objectAddress) throws IndexedStoreException {
        return (IndexAnchor)this.acquireObject(objectAddress);
    }

    IndexedStoreContext acquireContext(ObjectAddress objectAddress) {
        try {
            return (IndexedStoreContext)this.acquireObject(objectAddress);
        }
        catch (IndexedStoreException indexedStoreException) {
            return null;
        }
    }

    IndexNode acquireNode(ObjectAddress objectAddress) throws IndexedStoreException {
        return (IndexNode)this.acquireObject(objectAddress);
    }

    private StoredObject acquireObject(ObjectAddress objectAddress) throws IndexedStoreException {
        StoredObject storedObject;
        try {
            storedObject = this.objectStore.acquireObject(objectAddress);
        }
        catch (ObjectStoreException objectStoreException) {
            throw new IndexedStoreException(14, (Throwable)objectStoreException);
        }
        return storedObject;
    }

    BinarySmallObject acquireBinarySmallObject(ObjectAddress objectAddress) throws IndexedStoreException {
        return (BinarySmallObject)this.acquireObject(objectAddress);
    }

    private void checkMetadata() throws IndexedStoreException {
        Buffer buffer = this.getMetadataArea(2);
        Field field = buffer.getField(0, 4);
        int n = field.getInt();
        if (n == 0) {
            field.put(1);
            this.putMetadataArea(2, buffer);
            return;
        }
        if (n == 1) {
            return;
        }
        this.convert(n);
    }

    public synchronized void close() throws IndexedStoreException {
        if (this.name == null) {
            return;
        }
        try {
            this.commit();
            if (this.objectDirectoryCursor != null) {
                this.objectDirectoryCursor.close();
            }
            if (this.indexDirectoryCursor != null) {
                this.indexDirectoryCursor.close();
            }
        }
        catch (IndexedStoreException indexedStoreException) {
            try {
                this.objectStore.close();
            }
            catch (ObjectStoreException objectStoreException) {}
            throw indexedStoreException;
        }
        try {
            this.objectStore.close();
        }
        catch (ObjectStoreException objectStoreException) {
            throw new IndexedStoreException(26, (Throwable)objectStoreException);
        }
        registry.remove(this.name);
        this.name = null;
        this.objectDirectory = null;
        this.objectDirectoryAddress = null;
        this.objectDirectoryCursor = null;
        this.indexDirectory = null;
        this.indexDirectoryAddress = null;
        this.indexDirectoryCursor = null;
    }

    public synchronized void commit() throws IndexedStoreException {
        try {
            this.objectStore.commit();
        }
        catch (Exception exception) {
            throw new IndexedStoreException(36, (Throwable)exception);
        }
    }

    private void convert(int n) throws IndexedStoreException {
        throw new IndexedStoreException(34);
    }

    public static synchronized void create(String string) throws IndexedStoreException {
        ObjectStore objectStore = new ObjectStore(new IndexedStoreObjectPolicy());
        try {
            ObjectStore.create(string);
            objectStore.open(string);
            ObjectAddress objectAddress = objectStore.insertObject(new IndexedStoreContext());
            IndexedStoreContext indexedStoreContext = (IndexedStoreContext)objectStore.acquireObject(objectAddress);
            IndexAnchor indexAnchor = new IndexAnchor();
            ObjectAddress objectAddress2 = objectStore.insertObject(indexAnchor);
            indexedStoreContext.setIndexDirectoryAddress(objectAddress2);
            indexAnchor = new IndexAnchor();
            objectAddress2 = objectStore.insertObject(indexAnchor);
            indexedStoreContext.setObjectDirectoryAddress(objectAddress2);
            indexedStoreContext.release();
            objectStore.commit();
            objectStore.close();
        }
        catch (Exception exception) {
            try {
                objectStore.close();
            }
            catch (ObjectStoreException objectStoreException) {}
            ObjectStore.delete(string);
            throw new IndexedStoreException(24, (Throwable)exception);
        }
    }

    public synchronized Index createIndex(String string) throws IndexedStoreException {
        Index index = null;
        this.indexDirectoryCursor.find(string);
        if (this.indexDirectoryCursor.keyMatches(string)) {
            throw new IndexedStoreException(9);
        }
        ObjectAddress objectAddress = this.insertObject(new IndexAnchor());
        this.indexDirectory.insert(string, objectAddress.toByteArray());
        index = new Index(this, objectAddress);
        return index;
    }

    public synchronized ObjectID createObject(byte[] byArray) throws IndexedStoreException {
        ObjectAddress objectAddress = this.insertObject(new BinarySmallObject(byArray));
        ObjectID objectID = this.getNextObjectID();
        this.objectDirectory.insert(objectID.toByteArray(), objectAddress.toByteArray());
        return objectID;
    }

    public synchronized ObjectID createObject(String string) throws IndexedStoreException {
        return this.createObject(Convert.toUTF8(string));
    }

    public static synchronized boolean exists(String string) {
        return ObjectStore.exists(string);
    }

    protected void finalize() {
        try {
            this.close();
        }
        catch (Exception exception) {}
    }

    public static synchronized IndexedStore find(String string) {
        return (IndexedStore)registry.get(string);
    }

    public synchronized Index getIndex(String string) throws IndexedStoreException {
        byte[] byArray = Convert.toUTF8(string);
        this.indexDirectoryCursor.find(byArray);
        if (!this.indexDirectoryCursor.keyMatches(byArray)) {
            throw new IndexedStoreException(11);
        }
        ObjectAddress objectAddress = this.indexDirectoryCursor.getValueAsObjectAddress();
        Index index = new Index(this, objectAddress);
        return index;
    }

    private Buffer getMetadataArea(int n) throws IndexedStoreException {
        try {
            return this.objectStore.getMetadataArea(n);
        }
        catch (ObjectStoreException objectStoreException) {
            throw new IndexedStoreException(32, (Throwable)objectStoreException);
        }
    }

    private ObjectID getNextObjectID() throws IndexedStoreException {
        IndexedStoreContext indexedStoreContext = this.acquireContext(this.contextAddress);
        if (indexedStoreContext == null) {
            throw new IndexedStoreException(30);
        }
        long l = indexedStoreContext.getNextObjectNumber();
        indexedStoreContext.release();
        return new ObjectID(l);
    }

    public synchronized byte[] getObject(ObjectID objectID) throws IndexedStoreException {
        this.objectDirectoryCursor.find(objectID.toByteArray());
        ObjectAddress objectAddress = this.objectDirectoryCursor.getValueAsObjectAddress();
        BinarySmallObject binarySmallObject = this.acquireBinarySmallObject(objectAddress);
        byte[] byArray = binarySmallObject.getValue();
        binarySmallObject.release();
        return byArray;
    }

    public synchronized String getObjectAsString(ObjectID objectID) throws IndexedStoreException {
        String string = Convert.fromUTF8(this.getObject(objectID));
        int n = string.indexOf(0);
        if (n == -1) {
            return string;
        }
        return string.substring(0, n);
    }

    ObjectAddress insertObject(StoredObject storedObject) throws IndexedStoreException {
        try {
            ObjectAddress objectAddress = this.objectStore.insertObject(storedObject);
            return objectAddress;
        }
        catch (ObjectStoreException objectStoreException) {
            throw new IndexedStoreException(20, (Throwable)objectStoreException);
        }
    }

    public synchronized void open(String string) throws IndexedStoreException {
        if (registry.get(string) != null) {
            throw new IndexedStoreException(35);
        }
        if (!IndexedStore.exists(string)) {
            IndexedStore.create(string);
        }
        try {
            this.objectStore = new ObjectStore(new IndexedStoreObjectPolicy());
            this.objectStore.open(string);
            this.name = string;
            this.checkMetadata();
            this.contextAddress = ContextAddress10;
            IndexedStoreContext indexedStoreContext = this.acquireContext(this.contextAddress);
            if (indexedStoreContext == null) {
                this.contextAddress = ContextAddress11;
                indexedStoreContext = this.acquireContext(this.contextAddress);
            }
            if (indexedStoreContext == null) {
                throw new IndexedStoreException(23);
            }
            this.indexDirectoryAddress = indexedStoreContext.getIndexDirectoryAddress();
            this.objectDirectoryAddress = indexedStoreContext.getObjectDirectoryAddress();
            indexedStoreContext.release();
            this.indexDirectory = new Index(this, this.indexDirectoryAddress);
            this.indexDirectoryCursor = this.indexDirectory.open();
            this.objectDirectory = new Index(this, this.objectDirectoryAddress);
            this.objectDirectoryCursor = this.objectDirectory.open();
            registry.put(string, this);
        }
        catch (IndexedStoreException indexedStoreException) {
            throw indexedStoreException;
        }
        catch (Exception exception) {
            throw new IndexedStoreException(0, (Throwable)exception);
        }
    }

    private void putMetadataArea(int n, Buffer buffer) throws IndexedStoreException {
        try {
            this.objectStore.putMetadataArea(n, buffer);
        }
        catch (ObjectStoreException objectStoreException) {
            throw new IndexedStoreException(32, (Throwable)objectStoreException);
        }
    }

    void removeObject(ObjectAddress objectAddress) throws IndexedStoreException {
        try {
            this.objectStore.removeObject(objectAddress);
        }
        catch (ObjectStoreException objectStoreException) {
            throw new IndexedStoreException(18, (Throwable)objectStoreException);
        }
    }

    public synchronized void removeObject(ObjectID objectID) throws IndexedStoreException {
        byte[] byArray = objectID.toByteArray();
        this.objectDirectoryCursor.find(byArray);
        if (!this.objectDirectoryCursor.keyMatches(byArray)) {
            throw new IndexedStoreException(16);
        }
        ObjectAddress objectAddress = this.objectDirectoryCursor.getValueAsObjectAddress();
        this.objectDirectoryCursor.remove();
        this.removeObject(objectAddress);
    }
}

