/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.indexing;

import org.eclipse.core.internal.indexing.Field;
import org.eclipse.core.internal.indexing.IndexedStoreObject;
import org.eclipse.core.internal.indexing.ObjectAddress;
import org.eclipse.core.internal.indexing.ObjectStore;
import org.eclipse.core.internal.indexing.ObjectStoreException;

class IndexedStoreContext
extends IndexedStoreObject {
    public static final int SIZE = 32;
    public static final int TYPE = 2;
    private static final int OpenNumberOffset = 2;
    private static final int OpenNumberLength = 4;
    private Field openNumberField;
    private int openNumber;
    private static final int ObjectDirectoryAddressOffset = 6;
    private static final int ObjectDirectoryAddressLength = 4;
    private Field objectDirectoryAddressField;
    private ObjectAddress objectDirectoryAddress;
    private static final int IndexDirectoryAddressOffset = 10;
    private static final int IndexDirectoryAddressLength = 4;
    private Field indexDirectoryAddressField;
    private ObjectAddress indexDirectoryAddress;
    private static final int ObjectNumberOffset = 14;
    private static final int ObjectNumberLength = 8;
    private Field objectNumberField;
    private long objectNumber;

    IndexedStoreContext() {
        this.indexDirectoryAddress = ObjectAddress.Null;
        this.objectDirectoryAddress = ObjectAddress.Null;
        this.openNumber = 0;
        this.objectNumber = 0L;
    }

    IndexedStoreContext(Field field, ObjectStore objectStore, ObjectAddress objectAddress) throws ObjectStoreException {
        super(field, objectStore, objectAddress);
    }

    protected void setFields(Field field) {
        this.openNumberField = field.subfield(2, 4);
        this.objectDirectoryAddressField = field.subfield(6, 4);
        this.indexDirectoryAddressField = field.subfield(10, 4);
        this.objectNumberField = field.subfield(14, 8);
    }

    protected void extractValues(Field field) throws ObjectStoreException {
        super.extractValues(field);
        this.setFields(field);
        this.openNumber = this.openNumberField.getInt();
        this.objectDirectoryAddress = new ObjectAddress(this.objectDirectoryAddressField.get());
        this.indexDirectoryAddress = new ObjectAddress(this.indexDirectoryAddressField.get());
        this.objectNumber = this.objectNumberField.getLong();
        if (this.openNumber > 0) {
            this.objectNumber = (long)this.openNumber << 32;
            this.openNumber = 0;
            this.setChanged();
        }
    }

    protected void insertValues(Field field) {
        super.insertValues(field);
        this.setFields(field);
        this.openNumberField.put(this.openNumber);
        this.objectDirectoryAddressField.put(this.objectDirectoryAddress);
        this.indexDirectoryAddressField.put(this.indexDirectoryAddress);
        this.objectNumberField.put(this.objectNumber);
    }

    ObjectAddress getIndexDirectoryAddress() {
        return this.indexDirectoryAddress;
    }

    protected int getMinimumSize() {
        return 32;
    }

    ObjectAddress getObjectDirectoryAddress() {
        return this.objectDirectoryAddress;
    }

    protected int getRequiredType() {
        return 2;
    }

    long getNextObjectNumber() {
        ++this.objectNumber;
        this.setChanged();
        return this.objectNumber;
    }

    void setIndexDirectoryAddress(ObjectAddress objectAddress) {
        this.indexDirectoryAddress = objectAddress;
        this.setChanged();
    }

    void setObjectDirectoryAddress(ObjectAddress objectAddress) {
        this.objectDirectoryAddress = objectAddress;
        this.setChanged();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Context(");
        stringBuffer.append(this.objectNumber);
        stringBuffer.append(",");
        stringBuffer.append(this.indexDirectoryAddress);
        stringBuffer.append(",");
        stringBuffer.append(this.objectDirectoryAddress);
        stringBuffer.append(")");
        return stringBuffer.toString();
    }
}

