/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.indexing;

import org.eclipse.core.internal.indexing.Field;
import org.eclipse.core.internal.indexing.IndexAnchor;
import org.eclipse.core.internal.indexing.IndexNode;
import org.eclipse.core.internal.indexing.IndexedStoreException;
import org.eclipse.core.internal.indexing.ObjectAddress;
import org.eclipse.core.internal.indexing.ObjectStore;
import org.eclipse.core.internal.indexing.ObjectStoreException;
import org.eclipse.core.internal.indexing.StoredObject;

abstract class IndexedStoreObject
extends StoredObject {
    public IndexedStoreObject() {
    }

    public IndexedStoreObject(Field field, ObjectStore objectStore, ObjectAddress objectAddress) throws ObjectStoreException {
        super(field, objectStore, objectAddress);
    }

    protected final IndexAnchor acquireAnchor(ObjectAddress objectAddress) throws IndexedStoreException {
        return (IndexAnchor)this.acquireObject(objectAddress);
    }

    protected final IndexNode acquireNode(ObjectAddress objectAddress) throws IndexedStoreException {
        return (IndexNode)this.acquireObject(objectAddress);
    }

    protected final StoredObject acquireObject(ObjectAddress objectAddress) throws IndexedStoreException {
        StoredObject storedObject;
        try {
            storedObject = this.store.acquireObject(objectAddress);
        }
        catch (ObjectStoreException objectStoreException) {
            throw new IndexedStoreException(14, (Throwable)objectStoreException);
        }
        return storedObject;
    }

    protected final ObjectAddress insertObject(StoredObject storedObject) throws IndexedStoreException {
        try {
            ObjectAddress objectAddress = this.store.insertObject(storedObject);
            return objectAddress;
        }
        catch (ObjectStoreException objectStoreException) {
            throw new IndexedStoreException(20, (Throwable)objectStoreException);
        }
    }

    protected final void release() throws IndexedStoreException {
        try {
            this.store.releaseObject(this);
        }
        catch (ObjectStoreException objectStoreException) {
            throw new IndexedStoreException(17, (Throwable)objectStoreException);
        }
    }

    protected final void removeObject(ObjectAddress objectAddress) throws IndexedStoreException {
        try {
            this.store.removeObject(objectAddress);
        }
        catch (ObjectStoreException objectStoreException) {
            throw new IndexedStoreException(18, (Throwable)objectStoreException);
        }
    }
}

