/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.indexing;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.internal.indexing.Field;
import org.eclipse.core.internal.indexing.Log;
import org.eclipse.core.internal.indexing.Page;
import org.eclipse.core.internal.indexing.PageStore;
import org.eclipse.core.internal.indexing.PageStoreException;

class LogReader {
    protected FileInputStream in;
    protected PageStore store;
    protected byte[] b4;
    protected byte[] pageBuffer;

    public static Map getModifiedPages(PageStore pageStore) throws PageStoreException {
        LogReader logReader = new LogReader(pageStore);
        Map map = null;
        try {
            logReader.open(pageStore);
            map = logReader.getModifiedPages();
        }
        finally {
            logReader.close();
        }
        return map;
    }

    public LogReader(PageStore pageStore) {
        this.store = pageStore;
        this.pageBuffer = new byte[8192];
        this.b4 = new byte[4];
    }

    protected void open(PageStore pageStore) throws PageStoreException {
        String string = pageStore.getName();
        if (!Log.exists(string)) {
            return;
        }
        try {
            this.in = new FileInputStream(Log.name(string));
        }
        catch (IOException iOException) {
            throw new PageStoreException(21, (Throwable)iOException);
        }
    }

    protected void close() {
        try {
            if (this.in != null) {
                this.in.close();
            }
        }
        catch (IOException iOException) {}
        this.in = null;
    }

    protected Map getModifiedPages() throws PageStoreException {
        TreeMap<Integer, Page> treeMap = new TreeMap<Integer, Page>();
        if (this.in == null) {
            return treeMap;
        }
        Field field = new Field(this.b4);
        this.readBuffer(this.b4);
        int n = field.getInt();
        int n2 = 8196;
        if (this.bytesAvailable() != n * n2) {
            return treeMap;
        }
        int n3 = 0;
        while (n3 < n) {
            this.readBuffer(this.b4);
            this.readBuffer(this.pageBuffer);
            int n4 = field.getInt();
            Page page = this.store.getPolicy().createPage(n4, this.pageBuffer, this.store);
            Integer n5 = new Integer(n4);
            treeMap.put(n5, page);
            ++n3;
        }
        return treeMap;
    }

    public void readBuffer(byte[] byArray) throws PageStoreException {
        try {
            this.in.read(byArray);
        }
        catch (IOException iOException) {
            throw new PageStoreException(23, (Throwable)iOException);
        }
    }

    protected int bytesAvailable() throws PageStoreException {
        try {
            return this.in.available();
        }
        catch (IOException iOException) {
            throw new PageStoreException(23, (Throwable)iOException);
        }
    }
}

