/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.indexing;

import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.internal.indexing.Buffer;
import org.eclipse.core.internal.indexing.Log;
import org.eclipse.core.internal.indexing.Page;
import org.eclipse.core.internal.indexing.PageStore;
import org.eclipse.core.internal.indexing.PageStoreException;

class LogWriter {
    protected FileOutputStream out;
    protected PageStore pageStore;

    LogWriter() {
    }

    public static void putModifiedPages(PageStore pageStore, Map map) throws PageStoreException {
        LogWriter logWriter = new LogWriter();
        try {
            logWriter.open(pageStore);
            logWriter.putModifiedPages(map);
        }
        finally {
            logWriter.close();
        }
    }

    protected void open(PageStore pageStore) throws PageStoreException {
        this.pageStore = pageStore;
        try {
            this.out = new FileOutputStream(Log.name(pageStore.getName()));
        }
        catch (IOException iOException) {
            throw new PageStoreException(21, (Throwable)iOException);
        }
    }

    protected void close() {
        try {
            if (this.out != null) {
                this.out.close();
            }
        }
        catch (IOException iOException) {}
        this.out = null;
    }

    protected void putModifiedPages(Map map) throws PageStoreException {
        Buffer buffer = new Buffer(4);
        byte[] byArray = new byte[8192];
        int n = map.size();
        buffer.put(0, 4, n);
        try {
            this.write(buffer.getByteArray());
            Iterator iterator = map.values().iterator();
            while (iterator.hasNext()) {
                Page page = (Page)iterator.next();
                int n2 = page.getPageNumber();
                buffer.put(0, 4, n2);
                this.write(buffer.getByteArray());
                page.toBuffer(byArray);
                this.write(byArray);
            }
        }
        catch (IOException iOException) {
            throw new PageStoreException(24, (Throwable)iOException);
        }
    }

    public void write(byte[] byArray) throws IOException {
        this.out.write(byArray);
    }
}

