/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.indexing;

import org.eclipse.core.internal.indexing.Buffer;
import org.eclipse.core.internal.indexing.Insertable;

public class ObjectAddress
implements Insertable {
    public static final int Size = 4;
    public static ObjectAddress Null = new ObjectAddress(0, 0);
    private static final int PageNumberOffset = 0;
    private static final int ObjectNumberOffset = 3;
    private int pageNumber;
    private int objectNumber;

    public ObjectAddress(byte[] byArray) throws IllegalArgumentException {
        if (byArray.length != 4) {
            throw new IllegalArgumentException();
        }
        Buffer buffer = new Buffer(byArray);
        this.pageNumber = buffer.getUInt(0, 3);
        this.objectNumber = buffer.getUInt(3, 1);
    }

    public ObjectAddress(int n, int n2) throws IllegalArgumentException {
        if (n == 0 && n2 == 0) {
            this.pageNumber = 0;
            this.objectNumber = 0;
            return;
        }
        if (n < 0 || n > 0xFFFFFF) {
            throw new IllegalArgumentException();
        }
        if (n % 8192 == 0) {
            throw new IllegalArgumentException();
        }
        if (n2 < 0 || n2 > 255) {
            throw new IllegalArgumentException();
        }
        this.pageNumber = n;
        this.objectNumber = n2;
    }

    public boolean equals(Object object) {
        if (!(object instanceof ObjectAddress)) {
            return false;
        }
        ObjectAddress objectAddress = (ObjectAddress)object;
        if (this.pageNumber != objectAddress.pageNumber) {
            return false;
        }
        return this.objectNumber == objectAddress.objectNumber;
    }

    public int getObjectNumber() {
        return this.objectNumber;
    }

    public int getPageNumber() {
        return this.pageNumber;
    }

    public int hashCode() {
        return this.pageNumber << 8 | this.objectNumber;
    }

    public boolean isNull() {
        return this.pageNumber == 0 && this.objectNumber == 0;
    }

    public byte[] toByteArray() {
        Buffer buffer = new Buffer(4);
        buffer.put(0, 3, this.pageNumber);
        buffer.put(3, 1, this.objectNumber);
        return buffer.get();
    }
}

