/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.indexing;

import org.eclipse.core.internal.indexing.Buffer;
import org.eclipse.core.internal.indexing.Insertable;
import org.eclipse.core.internal.indexing.ObjectStoreException;

class ObjectHeader
implements Insertable {
    public static final int SIZE = 4;
    private static final int HeaderTagValue = 65535;
    private static final int HeaderTagOffset = 0;
    private static final int ObjectLengthOffset = 2;
    private int objectLength;

    public ObjectHeader(byte[] byArray) throws ObjectStoreException {
        if (byArray.length != 4) {
            throw new IllegalArgumentException();
        }
        Buffer buffer = new Buffer(byArray);
        if (buffer.getUInt(0, 2) != 65535) {
            throw new ObjectStoreException(26);
        }
        this.objectLength = buffer.getUInt(2, 2);
    }

    public ObjectHeader(int n) {
        this.objectLength = n;
    }

    public int getObjectLength() {
        return this.objectLength;
    }

    public byte[] toByteArray() {
        Buffer buffer = new Buffer(4);
        buffer.put(0, 2, 65535);
        buffer.put(2, 2, this.objectLength);
        return buffer.get();
    }
}

