/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.indexing;

import org.eclipse.core.internal.indexing.Buffer;
import org.eclipse.core.internal.indexing.IndexedStoreException;
import org.eclipse.core.internal.indexing.Insertable;

public class ObjectID
implements Insertable {
    private static final int Size = 8;
    private static final int ObjectNumberOffset = 0;
    private long objectNumber;

    public ObjectID(byte[] byArray) throws IndexedStoreException {
        if (byArray.length != 8) {
            throw new IndexedStoreException(31);
        }
        Buffer buffer = new Buffer(byArray);
        this.objectNumber = buffer.getLong(0, 8);
    }

    public ObjectID(long l) {
        this.objectNumber = l;
    }

    public boolean equals(Object object) {
        if (!(object instanceof ObjectID)) {
            return false;
        }
        ObjectID objectID = (ObjectID)object;
        return this.objectNumber == objectID.objectNumber;
    }

    public int hashCode() {
        return (int)this.objectNumber;
    }

    public byte[] toByteArray() {
        Buffer buffer = new Buffer(8);
        buffer.put(0, 8, this.objectNumber);
        return buffer.get();
    }
}

