/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.indexing;

import org.eclipse.core.internal.indexing.Buffer;
import org.eclipse.core.internal.indexing.Field;
import org.eclipse.core.internal.indexing.ObjectHeader;
import org.eclipse.core.internal.indexing.ObjectStoreException;
import org.eclipse.core.internal.indexing.ObjectStorePage;
import org.eclipse.core.internal.indexing.PageStore;
import org.eclipse.core.internal.indexing.Reservation;
import org.eclipse.core.internal.indexing.ReservationTable;
import org.eclipse.core.internal.indexing.StoredObject;

class ObjectPage
extends ObjectStorePage {
    protected static final int MaxEntries = 256;
    protected static final int ObjectDirectoryOffset = 64;
    protected static final int ObjectSpaceOffset = 576;
    protected static final int FlagOffset = 0;
    protected static final int UsedSpaceOffset = 2;
    protected static final int UsedEntriesOffset = 4;
    protected static final int InitialEntryOffset = 6;
    protected static final int FreeSpaceOffset = 8;
    public static final int ObjectSpaceSize = 7616;
    protected int usedSpace;
    protected int usedEntries;
    protected int freeSpaceOffset;
    protected int initialEntry;

    public ObjectPage(int n, byte[] byArray, PageStore pageStore) {
        super(n, byArray, pageStore);
    }

    public void toBuffer(byte[] byArray) {
        this.dematerialize();
        this.pageBuffer.copyTo(byArray);
    }

    protected void materialize() {
        int n = this.pageBuffer.getUInt(0, 2);
        if (n == 61166) {
            this.usedSpace = this.pageBuffer.getUInt(2, 2);
            this.usedEntries = this.pageBuffer.getUInt(4, 2);
            this.initialEntry = this.pageBuffer.getUInt(6, 2);
            this.freeSpaceOffset = this.pageBuffer.getUInt(8, 2);
        } else {
            this.usedSpace = 0;
            this.usedEntries = 0;
            this.initialEntry = 0;
            this.freeSpaceOffset = 576;
        }
    }

    protected void dematerialize() {
        this.pageBuffer.put(0, 2, 61166);
        this.pageBuffer.put(2, 2, this.usedSpace);
        this.pageBuffer.put(4, 2, this.usedEntries);
        this.pageBuffer.put(6, 2, this.initialEntry);
        this.pageBuffer.put(8, 2, this.freeSpaceOffset);
    }

    public Field getObjectField(int n) throws ObjectStoreException {
        int n2 = 64 + 2 * n;
        int n3 = this.pageBuffer.getUInt(n2, 2);
        if (n3 == 0) {
            return null;
        }
        ObjectHeader objectHeader = new ObjectHeader(this.pageBuffer.get(n3, 4));
        Field field = this.pageBuffer.getField(n3 + 4, objectHeader.getObjectLength());
        return field;
    }

    public void insertObject(StoredObject storedObject) throws ObjectStoreException {
        int n = storedObject.length() + 4;
        if (this.getFreeSpace() < n) {
            throw new ObjectStoreException(24);
        }
        int n2 = storedObject.getAddress().getObjectNumber();
        int n3 = 64 + n2 * 2;
        int n4 = this.pageBuffer.getUInt(n3, 2);
        if (n4 != 0) {
            throw new ObjectStoreException(22);
        }
        if (n > 8192 - this.freeSpaceOffset) {
            this.compress();
        }
        n4 = this.freeSpaceOffset;
        ObjectHeader objectHeader = new ObjectHeader(storedObject.length());
        this.pageBuffer.put(n4, objectHeader);
        this.pageBuffer.put(n4 + 4, storedObject.toByteArray());
        this.pageBuffer.put(n3, 2, n4);
        this.freeSpaceOffset += n;
        this.usedSpace += n;
        ++this.usedEntries;
        this.initialEntry = (n2 + 1) % 256;
        this.setChanged();
        this.notifyObservers();
    }

    public int reserveObject(StoredObject storedObject, ReservationTable reservationTable) throws ObjectStoreException {
        int n = storedObject.length() + 4;
        if (this.getFreeSpace() < n) {
            throw new ObjectStoreException(24);
        }
        Reservation reservation = reservationTable.get(this.pageNumber);
        if (reservation == null) {
            reservation = new Reservation(this.getFreeSpace(), 256 - this.usedEntries, this.initialEntry);
            reservationTable.put(this.pageNumber, reservation);
        }
        int n2 = reservation.getInitialEntry();
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while (n5 < 256) {
            if (!reservation.contains(n2) && (n3 = this.pageBuffer.getUInt(n4 = 64 + n2 * 2, 2)) == 0) break;
            n2 = (n2 + 1) % 256;
            ++n5;
        }
        if (n3 != 0) {
            throw new ObjectStoreException(22);
        }
        reservation.setInitialEntry((n2 + 1) % 256);
        reservation.add(n2, n);
        return n2;
    }

    public void removeObject(int n) throws ObjectStoreException {
        int n2 = 64 + 2 * n;
        int n3 = this.pageBuffer.getUInt(n2, 2);
        if (n3 == 0) {
            throw new ObjectStoreException(25);
        }
        this.pageBuffer.put(n2, 2, 0);
        ObjectHeader objectHeader = new ObjectHeader(this.pageBuffer.get(n3, 4));
        int n4 = objectHeader.getObjectLength();
        int n5 = n4 + 4;
        this.pageBuffer.clear(n3, n5);
        this.usedSpace -= n5;
        --this.usedEntries;
        this.setChanged();
        this.notifyObservers();
    }

    public void updateObject(StoredObject storedObject) throws ObjectStoreException {
        int n = storedObject.getAddress().getObjectNumber();
        int n2 = 64 + 2 * n;
        int n3 = this.pageBuffer.getUInt(n2, 2);
        if (n3 == 0) {
            throw new ObjectStoreException(25);
        }
        ObjectHeader objectHeader = new ObjectHeader(this.pageBuffer.get(n3, 4));
        if (objectHeader.getObjectLength() != storedObject.length()) {
            throw new ObjectStoreException(24);
        }
        int n4 = n3 + 4;
        this.pageBuffer.put(n4, storedObject.toByteArray());
        this.setChanged();
        this.notifyObservers();
    }

    private void compress() throws ObjectStoreException {
        Buffer buffer = new Buffer(8192);
        int n = 576;
        int n2 = 64;
        this.usedEntries = 0;
        int n3 = 0;
        while (n3 < 256) {
            int n4 = this.pageBuffer.getUInt(n2, 2);
            if (n4 > 0) {
                ObjectHeader objectHeader = new ObjectHeader(this.pageBuffer.get(n4, 4));
                int n5 = objectHeader.getObjectLength() + 4;
                buffer.put(n, this.pageBuffer.get(n4, n5));
                this.pageBuffer.put(n2, 2, n);
                n += n5;
                ++this.usedEntries;
            }
            n2 += 2;
            ++n3;
        }
        this.pageBuffer.put(576, buffer.get(576, 7616));
        this.freeSpaceOffset = n;
    }

    public int getFreeSpace() {
        if (this.usedEntries >= 256) {
            return 0;
        }
        return 8192 - (576 + this.usedSpace);
    }
}

