/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.indexing;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import org.eclipse.core.internal.indexing.AbstractObjectPolicy;
import org.eclipse.core.internal.indexing.Buffer;
import org.eclipse.core.internal.indexing.Field;
import org.eclipse.core.internal.indexing.Insertable;
import org.eclipse.core.internal.indexing.ObjectAddress;
import org.eclipse.core.internal.indexing.ObjectPage;
import org.eclipse.core.internal.indexing.ObjectStoreException;
import org.eclipse.core.internal.indexing.ObjectStorePagePolicy;
import org.eclipse.core.internal.indexing.PageStore;
import org.eclipse.core.internal.indexing.PageStoreException;
import org.eclipse.core.internal.indexing.Reservation;
import org.eclipse.core.internal.indexing.ReservationTable;
import org.eclipse.core.internal.indexing.SpaceMapPage;
import org.eclipse.core.internal.indexing.StoredObject;

public class ObjectStore
implements Observer {
    public static final int MAXIMUM_OBJECT_SIZE = 7612;
    protected static final int CurrentObjectStoreVersion = 1;
    protected static final int ObjectStoreMetadataAreaID = 1;
    protected PageStore pageStore;
    protected String name;
    protected Map acquiredObjects;
    protected Map modifiedObjects;
    protected LinkedList cachedObjects;
    protected Set phantoms;
    protected ReservationTable reservations;
    protected ObjectStorePagePolicy pagePolicy = new ObjectStorePagePolicy();
    protected AbstractObjectPolicy objectPolicy;

    public static void create(String string) throws ObjectStoreException {
        try {
            PageStore.create(string);
        }
        catch (PageStoreException pageStoreException) {
            throw new ObjectStoreException(10, (Throwable)pageStoreException);
        }
    }

    public static void delete(String string) {
        PageStore.delete(string);
    }

    public static boolean exists(String string) {
        return PageStore.exists(string);
    }

    public ObjectStore(AbstractObjectPolicy abstractObjectPolicy) {
        this.objectPolicy = abstractObjectPolicy;
    }

    public void open(String string) throws ObjectStoreException {
        try {
            this.pageStore = new PageStore(this.pagePolicy);
            this.pageStore.open(string);
        }
        catch (PageStoreException pageStoreException) {
            throw new ObjectStoreException(12, (Throwable)pageStoreException);
        }
        this.checkMetadata();
        this.acquiredObjects = new HashMap();
        this.modifiedObjects = new HashMap();
        this.cachedObjects = new LinkedList();
        this.phantoms = new HashSet();
        this.reservations = new ReservationTable();
    }

    public void close() throws ObjectStoreException {
        try {
            this.commit();
        }
        catch (ObjectStoreException objectStoreException) {
            this.pageStore.close(false);
            throw objectStoreException;
        }
        try {
            this.pageStore.close();
        }
        catch (Exception exception) {}
        this.acquiredObjects = null;
        this.modifiedObjects = null;
        this.cachedObjects = null;
        this.phantoms = null;
        this.reservations = null;
    }

    public Buffer getMetadataArea(int n) throws ObjectStoreException {
        try {
            return new Buffer(this.pageStore.readMetadataArea(n));
        }
        catch (PageStoreException pageStoreException) {
            throw new ObjectStoreException(40, (Throwable)pageStoreException);
        }
    }

    public void putMetadataArea(int n, Buffer buffer) throws ObjectStoreException {
        try {
            this.pageStore.writeMetadataArea(n, buffer.getByteArray());
        }
        catch (PageStoreException pageStoreException) {
            throw new ObjectStoreException(40, (Throwable)pageStoreException);
        }
    }

    protected void checkMetadata() throws ObjectStoreException {
        Buffer buffer = this.getMetadataArea(1);
        Field field = buffer.getField(0, 4);
        int n = field.getInt();
        if (n == 0) {
            field.put(1);
            this.putMetadataArea(1, buffer);
            return;
        }
        if (n == 1) {
            return;
        }
        this.convert(n);
    }

    protected void convert(int n) throws ObjectStoreException {
        throw new ObjectStoreException(11);
    }

    public void commit() throws ObjectStoreException {
        Insertable insertable;
        Iterator<Object> iterator = this.acquiredObjects.values().iterator();
        while (iterator.hasNext()) {
            insertable = (StoredObject)iterator.next();
            ((Observable)((Object)insertable)).notifyObservers();
        }
        iterator = this.phantoms.iterator();
        while (iterator.hasNext()) {
            insertable = (ObjectAddress)iterator.next();
            int n = ((ObjectAddress)insertable).getPageNumber();
            ObjectPage objectPage = this.acquireObjectPage(n);
            objectPage.removeObject(((ObjectAddress)insertable).getObjectNumber());
            this.updateSpaceMapPage(objectPage.getPageNumber(), objectPage.getFreeSpace());
            objectPage.release();
        }
        this.phantoms.clear();
        iterator = this.modifiedObjects.values().iterator();
        while (iterator.hasNext()) {
            insertable = (StoredObject)iterator.next();
            iterator.remove();
            this.addToCache((StoredObject)insertable);
            ObjectAddress objectAddress = ((StoredObject)insertable).getAddress();
            int n = objectAddress.getPageNumber();
            ObjectPage objectPage = this.acquireObjectPage(n);
            if (this.reservations.contains(objectAddress)) {
                objectPage.insertObject((StoredObject)insertable);
                this.updateSpaceMapPage(n, objectPage.getFreeSpace());
            } else {
                objectPage.updateObject((StoredObject)insertable);
            }
            objectPage.release();
        }
        this.reservations.clear();
        try {
            this.pageStore.commit();
        }
        catch (PageStoreException pageStoreException) {
            throw new ObjectStoreException(21, (Throwable)pageStoreException);
        }
    }

    public StoredObject acquireObject(ObjectAddress objectAddress) throws ObjectStoreException {
        if (this.phantoms.contains(objectAddress)) {
            throw new ObjectStoreException(25);
        }
        StoredObject storedObject = (StoredObject)this.acquiredObjects.get(objectAddress);
        if (storedObject == null) {
            storedObject = (StoredObject)this.modifiedObjects.get(objectAddress);
            if (storedObject == null && (storedObject = this.removeFromCache(objectAddress)) == null) {
                int n = objectAddress.getPageNumber();
                ObjectPage objectPage = this.acquireObjectPage(n);
                try {
                    Field field = objectPage.getObjectField(objectAddress.getObjectNumber());
                    if (field == null) {
                        throw new ObjectStoreException(25);
                    }
                    storedObject = this.objectPolicy.createObject(field, this, objectAddress);
                }
                catch (ObjectStoreException objectStoreException) {
                    objectPage.release();
                    throw objectStoreException;
                }
                objectPage.release();
            }
            this.acquiredObjects.put(objectAddress, storedObject);
            storedObject.addObserver(this);
        }
        storedObject.addReference();
        return storedObject;
    }

    public void releaseObject(StoredObject storedObject) throws ObjectStoreException {
        storedObject.removeReference();
        if (storedObject.hasReferences()) {
            return;
        }
        storedObject.notifyObservers();
        storedObject.deleteObserver(this);
        this.acquiredObjects.remove(storedObject.getAddress());
        this.addToCache(storedObject);
    }

    public void update(Observable observable, Object object) {
        StoredObject storedObject = (StoredObject)observable;
        this.modifiedObjects.put(storedObject.getAddress(), storedObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addToCache(StoredObject storedObject) {
        LinkedList linkedList = this.cachedObjects;
        synchronized (linkedList) {
            if (this.acquiredObjects.containsKey(storedObject.getAddress())) {
                return;
            }
            if (this.modifiedObjects.containsKey(storedObject.getAddress())) {
                return;
            }
            this.cachedObjects.addFirst(storedObject);
            if (this.cachedObjects.size() <= 50) {
                return;
            }
            this.cachedObjects.removeLast();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected StoredObject removeFromCache(ObjectAddress objectAddress) {
        LinkedList linkedList = this.cachedObjects;
        synchronized (linkedList) {
            StoredObject storedObject = null;
            Iterator iterator = this.cachedObjects.iterator();
            while (iterator.hasNext()) {
                StoredObject storedObject2 = (StoredObject)iterator.next();
                if (!storedObject2.getAddress().equals(objectAddress)) continue;
                iterator.remove();
                storedObject = storedObject2;
                break;
            }
            return storedObject;
        }
    }

    public ObjectAddress insertObject(StoredObject storedObject) throws ObjectStoreException {
        int n = storedObject.length() + 4;
        ObjectPage objectPage = this.acquireObjectPageForSize(n);
        int n2 = objectPage.getPageNumber();
        int n3 = objectPage.reserveObject(storedObject, this.reservations);
        objectPage.release();
        ObjectAddress objectAddress = new ObjectAddress(n2, n3);
        storedObject.setAddress(objectAddress);
        storedObject.setStore(this);
        this.modifiedObjects.put(objectAddress, storedObject);
        return objectAddress;
    }

    public void removeObject(ObjectAddress objectAddress) throws ObjectStoreException {
        boolean bl;
        if (this.phantoms.contains(objectAddress)) {
            throw new ObjectStoreException(25);
        }
        if (this.acquiredObjects.containsKey(objectAddress)) {
            throw new ObjectStoreException(30);
        }
        StoredObject storedObject = (StoredObject)this.modifiedObjects.get(objectAddress);
        boolean bl2 = bl = !this.reservations.contains(objectAddress);
        if (storedObject != null) {
            this.reservations.remove(objectAddress);
            this.modifiedObjects.remove(objectAddress);
        }
        this.removeFromCache(objectAddress);
        if (bl) {
            this.phantoms.add(objectAddress);
        }
    }

    protected void updateSpaceMapPage(int n, int n2) throws ObjectStoreException {
        SpaceMapPage spaceMapPage = this.acquireSpaceMapPage(n);
        spaceMapPage.setFreeSpace(n, n2);
        spaceMapPage.release();
    }

    protected ObjectPage acquireObjectPage(int n) throws ObjectStoreException {
        ObjectPage objectPage;
        try {
            objectPage = (ObjectPage)this.pageStore.acquire(n);
        }
        catch (PageStoreException pageStoreException) {
            throw new ObjectStoreException(20, (Throwable)pageStoreException);
        }
        return objectPage;
    }

    protected ObjectPage acquireObjectPageForSize(int n) throws ObjectStoreException {
        int n2 = 0;
        int n3 = (this.pageStore.numberOfPages() - 1) / 8192 + 1;
        int n4 = 0;
        while (n4 <= n3) {
            try {
                int n5 = n4 * 8192;
                SpaceMapPage spaceMapPage = (SpaceMapPage)this.pageStore.acquire(n5);
                int n6 = 1;
                while (n6 < 8192) {
                    int n7;
                    int n8 = n5 + n6;
                    Reservation reservation = this.reservations.get(n8);
                    int n9 = n7 = reservation == null ? spaceMapPage.getFreeSpace(n8) : reservation.getFreeSpace();
                    if (n <= n7) {
                        n2 = n8;
                        break;
                    }
                    ++n6;
                }
                spaceMapPage.release();
            }
            catch (PageStoreException pageStoreException) {
                throw new ObjectStoreException(20, (Throwable)pageStoreException);
            }
            if (n2 != 0) break;
            ++n4;
        }
        if (n2 == 0) {
            throw new ObjectStoreException(20);
        }
        try {
            ObjectPage objectPage = (ObjectPage)this.pageStore.acquire(n2);
            return objectPage;
        }
        catch (PageStoreException pageStoreException) {
            throw new ObjectStoreException(20, (Throwable)pageStoreException);
        }
    }

    protected SpaceMapPage acquireSpaceMapPage(int n) throws ObjectStoreException {
        int n2 = n & 0xFFFFE000;
        SpaceMapPage spaceMapPage = null;
        try {
            spaceMapPage = (SpaceMapPage)this.pageStore.acquire(n2);
        }
        catch (PageStoreException pageStoreException) {
            throw new ObjectStoreException(20, (Throwable)pageStoreException);
        }
        return spaceMapPage;
    }
}

