/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.indexing;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.core.internal.indexing.AbstractPagePolicy;
import org.eclipse.core.internal.indexing.Buffer;
import org.eclipse.core.internal.indexing.Field;
import org.eclipse.core.internal.indexing.Log;
import org.eclipse.core.internal.indexing.LogReader;
import org.eclipse.core.internal.indexing.LogWriter;
import org.eclipse.core.internal.indexing.Page;
import org.eclipse.core.internal.indexing.PageStoreException;

public class PageStore
implements Observer {
    private static final int NumberOfMetadataAreas = 16;
    private static final int SizeOfMetadataArea = 64;
    private static final int CurrentPageStoreVersion = 1;
    private static final byte[] ZEROES = new byte[1024];
    private String name;
    private RandomAccessFile file;
    private int numberOfPages;
    private int numberOfFileReads;
    private int numberOfFileWrites;
    private int numberOfReads;
    private int numberOfCacheHits;
    private Map modifiedPages;
    private Map acquiredPages;
    private int storeOffset;
    private AbstractPagePolicy policy;
    private byte[] pageBuffer;
    private byte[] metadataBuffer;

    public static void create(String string) throws PageStoreException {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            throw new PageStoreException(1, (Throwable)iOException);
        }
    }

    public static void delete(String string) {
        new File(string).delete();
    }

    public static boolean exists(String string) {
        return new File(string).exists();
    }

    public PageStore(AbstractPagePolicy abstractPagePolicy) {
        this.policy = abstractPagePolicy;
        this.storeOffset = 1024;
    }

    public void open(String string) throws PageStoreException {
        this.name = string;
        this.pageBuffer = new byte[8192];
        this.metadataBuffer = new byte[64];
        if (!PageStore.exists(string)) {
            PageStore.create(string);
        }
        try {
            this.file = new RandomAccessFile(string, "rw");
        }
        catch (IOException iOException) {
            throw new PageStoreException(2, (Throwable)iOException);
        }
        this.checkMetadata();
        this.numberOfPages = this.numberOfPagesInFile();
        this.numberOfFileReads = 0;
        this.numberOfFileWrites = 0;
        this.numberOfReads = 0;
        this.numberOfCacheHits = 0;
        this.modifiedPages = LogReader.getModifiedPages(this);
        this.flush();
        Log.delete(string);
        this.acquiredPages = new HashMap();
    }

    private void checkMetadata() throws PageStoreException {
        byte[] byArray = this.readMetadataArea(0);
        Buffer buffer = new Buffer(byArray);
        Field field = buffer.getField(0, 4);
        int n = field.getInt();
        if (n == 0) {
            field.put(1);
            this.writeMetadataArea(0, byArray);
            return;
        }
        if (n == 1) {
            return;
        }
        this.convertPageStore(n);
    }

    private void convertPageStore(int n) throws PageStoreException {
        throw new PageStoreException(9);
    }

    public void close() {
        this.close(true);
    }

    public void close(boolean bl) {
        if (bl) {
            try {
                this.commit();
            }
            catch (PageStoreException pageStoreException) {}
        }
        try {
            this.file.close();
        }
        catch (IOException iOException) {}
        this.file = null;
    }

    public void commit() throws PageStoreException {
        if (this.modifiedPages.size() == 0) {
            return;
        }
        LogWriter.putModifiedPages(this, this.modifiedPages);
        this.flush();
        Log.delete(this.name);
    }

    private void flush() throws PageStoreException {
        if (this.modifiedPages.size() == 0) {
            return;
        }
        Iterator iterator = this.modifiedPages.values().iterator();
        while (iterator.hasNext()) {
            Page page = (Page)iterator.next();
            this.writePage(page);
        }
        this.modifiedPages.clear();
    }

    public Page acquire(int n) throws PageStoreException {
        ++this.numberOfReads;
        Integer n2 = new Integer(n);
        Page page = (Page)this.acquiredPages.get(n2);
        if (page == null) {
            page = (Page)this.modifiedPages.get(n2);
            if (page == null) {
                this.numberOfPages = Math.max(n + 1, this.numberOfPages);
                page = this.readPage(n);
            } else {
                ++this.numberOfCacheHits;
            }
            this.acquiredPages.put(n2, page);
            page.addObserver(this);
        } else {
            ++this.numberOfCacheHits;
        }
        page.addReference();
        return page;
    }

    public void release(Page page) {
        Integer n = new Integer(page.getPageNumber());
        page.removeReference();
        if (page.hasReferences()) {
            return;
        }
        page.deleteObserver(this);
        this.acquiredPages.remove(n);
    }

    public void update(Observable observable, Object object) {
        Page page = (Page)observable;
        Integer n = new Integer(page.getPageNumber());
        this.modifiedPages.put(n, page);
    }

    protected long offsetOfPage(int n) {
        return (long)(n * 8192) + (long)this.storeOffset;
    }

    protected Page readPage(int n) throws PageStoreException {
        if (!this.readBuffer(this.offsetOfPage(n), this.pageBuffer)) {
            throw new PageStoreException(5);
        }
        ++this.numberOfFileReads;
        Page page = this.policy.createPage(n, this.pageBuffer, this);
        page.addObserver(this);
        return page;
    }

    protected void writePage(Page page) throws PageStoreException {
        page.toBuffer(this.pageBuffer);
        long l = this.offsetOfPage(page.getPageNumber());
        if (!this.writeBuffer(l, this.pageBuffer, 0, this.pageBuffer.length)) {
            throw new PageStoreException(4);
        }
        ++this.numberOfFileWrites;
    }

    protected long offsetOfMetadataArea(int n) {
        return (long)n * 64L;
    }

    public byte[] readMetadataArea(int n) throws PageStoreException {
        if (!this.readBuffer(this.offsetOfMetadataArea(n), this.metadataBuffer)) {
            throw new PageStoreException(8);
        }
        return new Buffer(this.metadataBuffer).get(0, this.metadataBuffer.length);
    }

    public void writeMetadataArea(int n, byte[] byArray) throws PageStoreException {
        if (n < 0 || n >= 16) {
            throw new PageStoreException(8);
        }
        if (byArray.length != 64) {
            throw new PageStoreException(8);
        }
        if (!this.writeBuffer(this.offsetOfMetadataArea(n), byArray, 0, byArray.length)) {
            throw new PageStoreException(8);
        }
    }

    protected boolean readBuffer(long l, byte[] byArray) {
        new Buffer(byArray).clear();
        long l2 = this.getFileLength();
        if (l >= l2) {
            return true;
        }
        int n = (int)Math.min((long)byArray.length, l2 - l);
        try {
            this.file.seek(l);
            this.file.readFully(byArray, 0, n);
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    protected boolean writeBuffer(long l, byte[] byArray, int n, int n2) {
        this.clearFileToOffset(l);
        try {
            this.file.seek(l);
            this.file.write(byArray, n, n2);
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    protected long getFileLength() {
        long l = 0L;
        try {
            l = this.file.length();
        }
        catch (IOException iOException) {
            return 0L;
        }
        return l;
    }

    protected void clearFileToOffset(long l) {
        long l2 = this.getFileLength();
        while (l2 < l) {
            int n = (int)Math.min((long)ZEROES.length, l - l2);
            this.writeBuffer(l2, ZEROES, 0, n);
            l2 += (long)n;
        }
    }

    protected int numberOfPagesInFile() {
        return (int)((this.getFileLength() - this.offsetOfPage(0)) / 8192L);
    }

    public String getName() {
        return this.name;
    }

    public AbstractPagePolicy getPolicy() {
        return this.policy;
    }

    public int numberOfPages() {
        return this.numberOfPages;
    }
}

