/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.indexing;

import org.eclipse.core.internal.indexing.ObjectStorePage;
import org.eclipse.core.internal.indexing.PageStore;

class SpaceMapPage
extends ObjectStorePage {
    private static int[] SpaceClassSize;

    static {
        int[] nArray = new int[16];
        nArray[0] = 7616;
        nArray[1] = 6906;
        nArray[2] = 6196;
        nArray[3] = 5486;
        nArray[4] = 4776;
        nArray[5] = 4066;
        nArray[6] = 3356;
        nArray[7] = 2646;
        nArray[8] = 1936;
        nArray[9] = 1226;
        nArray[10] = 516;
        nArray[11] = 258;
        nArray[12] = 129;
        nArray[13] = 64;
        nArray[14] = 32;
        SpaceClassSize = nArray;
    }

    public static int freeSpaceForClass(int n) {
        return SpaceClassSize[n];
    }

    public SpaceMapPage(int n, byte[] byArray, PageStore pageStore) {
        super(n, byArray, pageStore);
    }

    public void toBuffer(byte[] byArray) {
        int n = Math.min(byArray.length, this.pageBuffer.length());
        System.arraycopy(this.pageBuffer.getByteArray(), 0, byArray, 0, n);
    }

    public int getFreeSpace(int n) {
        int n2 = n - this.pageNumber;
        if (n2 < 1 || n2 >= 8192) {
            return 0;
        }
        byte by = this.pageBuffer.getByte(n2);
        int n3 = SpaceMapPage.freeSpaceForClass(by);
        return n3;
    }

    public void setFreeSpace(int n, int n2) {
        int n3 = n - this.pageNumber;
        if (n3 < 1 || n3 >= 8192) {
            return;
        }
        byte by = 0;
        while (SpaceClassSize[by] > n2) {
            by = (byte)(by + 1);
        }
        this.pageBuffer.put(n3, by);
        this.setChanged();
        this.notifyObservers();
    }

    protected void materialize() {
    }
}

