/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.indexing;

import java.util.Observable;
import org.eclipse.core.internal.indexing.Field;
import org.eclipse.core.internal.indexing.Insertable;
import org.eclipse.core.internal.indexing.ObjectAddress;
import org.eclipse.core.internal.indexing.ObjectStore;
import org.eclipse.core.internal.indexing.ObjectStoreException;
import org.eclipse.core.internal.indexing.Referable;

public abstract class StoredObject
extends Observable
implements Referable,
Insertable {
    public static final int MAXIMUM_OBJECT_SIZE = 7612;
    public static final int TYPE_OFFSET = 0;
    public static final int TYPE_LENGTH = 2;
    protected ObjectStore store;
    protected ObjectAddress address;
    protected int referenceCount;
    protected int type;

    protected StoredObject() {
        this.type = this.getRequiredType();
    }

    protected StoredObject(Field field, ObjectStore objectStore, ObjectAddress objectAddress) throws ObjectStoreException {
        if (field.length() < this.getMinimumSize()) {
            throw new ObjectStoreException(24);
        }
        if (field.length() > this.getMaximumSize()) {
            throw new ObjectStoreException(24);
        }
        this.extractValues(field);
        this.setStore(objectStore);
        this.setAddress(objectAddress);
    }

    public abstract String toString();

    protected abstract int getRequiredType();

    public final byte[] toByteArray() {
        Field field = new Field(this.length());
        this.insertValues(field);
        return field.get();
    }

    public final int addReference() {
        ++this.referenceCount;
        return this.referenceCount;
    }

    public final int removeReference() {
        if (this.referenceCount > 0) {
            --this.referenceCount;
        }
        return this.referenceCount;
    }

    public final boolean hasReferences() {
        return this.referenceCount > 0;
    }

    public final ObjectAddress getAddress() {
        return this.address;
    }

    public final void setStore(ObjectStore objectStore) {
        this.store = objectStore;
    }

    public final void setAddress(ObjectAddress objectAddress) {
        this.address = objectAddress;
    }

    protected void extractValues(Field field) throws ObjectStoreException {
        this.type = field.subfield(0, 2).getInt();
        if (this.type != this.getRequiredType()) {
            throw new ObjectStoreException(23);
        }
    }

    protected void insertValues(Field field) {
        field.subfield(0, 2).put(this.type);
    }

    protected int getMaximumSize() {
        return this.getMinimumSize();
    }

    protected int getMinimumSize() {
        return 2;
    }

    protected int length() {
        return this.getMinimumSize();
    }
}

