/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.localstore;

import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.internal.indexing.IndexCursor;
import org.eclipse.core.internal.indexing.IndexedStoreException;
import org.eclipse.core.internal.indexing.ObjectID;
import org.eclipse.core.internal.localstore.BlobStore;
import org.eclipse.core.internal.localstore.HistoryStore;
import org.eclipse.core.internal.localstore.HistoryStoreEntry;
import org.eclipse.core.internal.localstore.IHistoryStore;
import org.eclipse.core.internal.localstore.IHistoryStoreVisitor;
import org.eclipse.core.internal.properties.IndexedStoreWrapper;
import org.eclipse.core.internal.resources.CompatibilityMessages;
import org.eclipse.core.internal.resources.FileState;
import org.eclipse.core.internal.resources.ICoreConstants;
import org.eclipse.core.internal.resources.ResourceException;
import org.eclipse.core.internal.resources.ResourceStatus;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.internal.resources.WorkspaceDescription;
import org.eclipse.core.internal.utils.Convert;
import org.eclipse.core.internal.utils.Policy;
import org.eclipse.core.internal.utils.UniversalUniqueIdentifier;
import org.eclipse.core.resources.IFileState;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.util.NLS;

public class HistoryStore
implements IHistoryStore {
    static final String INDEX_FILE = ".index";
    protected BlobStore blobStore;
    Set blobsToRemove = new HashSet();
    IndexedStoreWrapper store;
    protected Workspace workspace;

    public HistoryStore(Workspace workspace, IPath iPath, int n) {
        this.workspace = workspace;
        this.blobStore = new BlobStore(EFS.getLocalFileSystem().getStore(iPath), n);
        this.store = new IndexedStoreWrapper(iPath.append(INDEX_FILE));
    }

    protected void accept(byte[] byArray, IHistoryStoreVisitor iHistoryStoreVisitor, boolean bl, boolean bl2) {
        try {
            IndexCursor indexCursor = this.store.getCursor();
            indexCursor.find(byArray);
            while (indexCursor.keyMatches(byArray)) {
                HistoryStoreEntry historyStoreEntry;
                int n;
                byte[] byArray2 = indexCursor.getKey();
                int n2 = n = bl2 ? 1 : 9;
                if (byArray2.length - n == byArray.length) {
                    HistoryStoreEntry historyStoreEntry2 = HistoryStoreEntry.create(this.store, indexCursor);
                    if (!iHistoryStoreVisitor.visit(historyStoreEntry2)) break;
                    indexCursor.next();
                    continue;
                }
                if (!bl) {
                    indexCursor.next();
                    continue;
                }
                byte by = byArray2[byArray.length];
                if ((byArray[byArray.length - 1] == 47 || by == 47) && !iHistoryStoreVisitor.visit(historyStoreEntry = HistoryStoreEntry.create(this.store, indexCursor))) break;
                indexCursor.next();
            }
            indexCursor.close();
        }
        catch (Exception exception) {
            String string = CompatibilityMessages.history_problemsAccessing;
            Policy.log((IStatus)new ResourceStatus(271, null, string, (Throwable)exception));
        }
    }

    protected void accept(IPath iPath, IHistoryStoreVisitor iHistoryStoreVisitor, boolean bl) {
        this.accept(Convert.toUTF8((String)iPath.toString()), iHistoryStoreVisitor, bl, false);
    }

    public IFileState addState(IPath iPath, IFileStore iFileStore, IFileInfo iFileInfo, boolean bl) {
        long l = iFileInfo.getLastModified();
        if (Policy.DEBUG_HISTORY) {
            System.out.println("History: Adding state for key: " + iPath + ", file: " + iFileStore + ", timestamp: " + l + ", size: " + iFileStore.fetchInfo().getLength());
        }
        if (!this.isValid(iFileStore)) {
            return null;
        }
        UniversalUniqueIdentifier universalUniqueIdentifier = null;
        try {
            universalUniqueIdentifier = this.blobStore.addBlob(iFileStore, bl);
            this.addState(iPath, universalUniqueIdentifier, l);
            this.store.commit();
        }
        catch (CoreException coreException) {
            Policy.log((Throwable)coreException);
        }
        return new FileState((IHistoryStore)this, iPath, l, universalUniqueIdentifier);
    }

    protected void addState(IPath iPath, UniversalUniqueIdentifier universalUniqueIdentifier, long l) {
        byte[] byArray = HistoryStoreEntry.keyPrefixToBytes(iPath, l);
        class BitVisitor
        implements IHistoryStoreVisitor {
            BitSet bits;
            final /* synthetic */ HistoryStore this$0;

            BitVisitor(HistoryStore historyStore) {
                this.this$0 = historyStore;
                this.bits = new BitSet();
            }

            public byte useNextClearBit(byte[] byArray) {
                int n = this.bits.length();
                if (n > 127) {
                    if (this.bits.cardinality() < 127) {
                        byte by;
                        IndexCursor indexCursor;
                        block9: {
                            indexCursor = this.this$0.store.getCursor();
                            by = (byte)this.bits.nextClearBit(0);
                            if (by >= 0) break block9;
                            return -1;
                        }
                        try {
                            byte by2 = (byte)this.bits.nextSetBit(by);
                            if (by2 < 0) {
                                return by;
                            }
                            byte[] byArray2 = new byte[byArray.length + 1];
                            System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
                            while (by2 >= 0 && by >= 0) {
                                byArray2[byArray2.length - 1] = by2;
                                indexCursor.find(byArray2);
                                if (indexCursor.keyMatches(byArray2)) {
                                    HistoryStoreEntry historyStoreEntry = HistoryStoreEntry.create(this.this$0.store, indexCursor);
                                    HistoryStoreEntry historyStoreEntry2 = new HistoryStoreEntry(historyStoreEntry.getPath(), historyStoreEntry.getUUID(), historyStoreEntry.getLastModified(), by);
                                    this.this$0.remove(historyStoreEntry);
                                    ObjectID objectID = this.this$0.store.createObject(historyStoreEntry2.valueToBytes());
                                    this.this$0.store.getIndex().insert(historyStoreEntry2.getKey(), objectID);
                                    by2 = (byte)this.bits.nextSetBit(by2 + 1);
                                }
                                by = (byte)(by + 1);
                            }
                            indexCursor.close();
                            return by;
                        }
                        catch (Exception exception) {
                            String string = CompatibilityMessages.history_problemsAccessing;
                            Policy.log((IStatus)new ResourceStatus(271, null, string, (Throwable)exception));
                        }
                    } else {
                        return -1;
                    }
                }
                return (byte)n;
            }

            public boolean visit(HistoryStoreEntry historyStoreEntry) {
                this.bits.set(historyStoreEntry.getCount());
                return true;
            }
        }
        BitVisitor bitVisitor = new BitVisitor(this);
        this.accept(byArray, bitVisitor, false, true);
        byte by = bitVisitor.useNextClearBit(byArray);
        try {
            if (by < 0) {
                String string = NLS.bind((String)CompatibilityMessages.history_tooManySimUpdates, (Object)iPath, (Object)new Date(l));
                Policy.log((IStatus)new ResourceStatus(272, iPath, string, null));
                return;
            }
            HistoryStoreEntry historyStoreEntry = new HistoryStoreEntry(iPath, universalUniqueIdentifier, l, by);
            ObjectID objectID = this.store.createObject(historyStoreEntry.valueToBytes());
            this.store.getIndex().insert(historyStoreEntry.getKey(), objectID);
        }
        catch (Exception exception) {
            this.resetIndexedStore();
            String string = NLS.bind((String)CompatibilityMessages.history_couldNotAdd, (Object)iPath);
            Policy.log((IStatus)new ResourceStatus(272, iPath, string, (Throwable)exception));
        }
    }

    public Set allFiles(IPath iPath, int n, IProgressMonitor iProgressMonitor) {
        HashSet hashSet = new HashSet();
        int n2 = iPath.segmentCount();
        class PathCollector
        implements IHistoryStoreVisitor {
            final /* synthetic */ HistoryStore this$0;
            private final /* synthetic */ int val$depth;
            private final /* synthetic */ int val$pathLength;
            private final /* synthetic */ Set val$allFiles;

            PathCollector(HistoryStore historyStore, int n, int n2, Set set) {
                this.this$0 = historyStore;
                this.val$depth = n;
                this.val$pathLength = n2;
                this.val$allFiles = set;
            }

            public boolean visit(HistoryStoreEntry historyStoreEntry) {
                IPath iPath = historyStoreEntry.getPath();
                boolean bl = false;
                switch (this.val$depth) {
                    case 0: {
                        bl = iPath.segmentCount() == this.val$pathLength;
                        break;
                    }
                    case 1: {
                        bl = iPath.segmentCount() <= this.val$pathLength + 1;
                        break;
                    }
                    case 2: {
                        bl = true;
                    }
                }
                if (bl) {
                    this.val$allFiles.add(iPath);
                }
                return bl;
            }
        }
        this.accept(iPath, new PathCollector(this, n, n2, hashSet), true);
        return hashSet;
    }

    public void clean(IProgressMonitor iProgressMonitor) {
        long l = System.currentTimeMillis();
        int n = 0;
        WorkspaceDescription workspaceDescription = this.workspace.internalGetDescription();
        long l2 = System.currentTimeMillis() - workspaceDescription.getFileStateLongevity();
        int n2 = workspaceDescription.getMaxFileStates();
        IPath iPath = null;
        ArrayList<HistoryStoreEntry> arrayList = new ArrayList<HistoryStoreEntry>(Math.min(n2, 1000));
        try {
            IndexCursor indexCursor = this.store.getCursor();
            indexCursor.findFirstEntry();
            while (indexCursor.isSet()) {
                ++n;
                HistoryStoreEntry historyStoreEntry = HistoryStoreEntry.create(this.store, indexCursor);
                if (historyStoreEntry.getLastModified() < l2) {
                    this.remove(historyStoreEntry);
                    continue;
                }
                if (!historyStoreEntry.getPath().equals(iPath)) {
                    this.removeOldestEntries(arrayList, n2);
                    arrayList.clear();
                    iPath = historyStoreEntry.getPath();
                }
                arrayList.add(historyStoreEntry);
                indexCursor.next();
            }
            this.removeOldestEntries(arrayList, n2);
            indexCursor.close();
            this.store.commit();
            if (Policy.DEBUG_HISTORY) {
                Policy.debug((String)("Time to apply history store policies: " + (System.currentTimeMillis() - l) + "ms."));
                Policy.debug((String)("Total number of history store entries: " + n));
            }
            l = System.currentTimeMillis();
            this.blobStore.deleteBlobs(this.blobsToRemove);
            if (Policy.DEBUG_HISTORY) {
                Policy.debug((String)("Time to remove " + this.blobsToRemove.size() + " unreferenced blobs: " + (System.currentTimeMillis() - l) + "ms."));
            }
            this.blobsToRemove = new HashSet();
        }
        catch (Exception exception) {
            String string = CompatibilityMessages.history_problemsCleaning;
            Policy.log((IStatus)new ResourceStatus(273, null, string, (Throwable)exception));
        }
    }

    public void closeHistoryStore(IResource iResource) {
    }

    public void copyHistory(IResource iResource, IResource iResource2, boolean bl) {
        IndexCursor indexCursor;
        Object object;
        if (iResource == null || iResource2 == null) {
            String string = CompatibilityMessages.history_copyToNull;
            Policy.log((IStatus)new ResourceStatus(566, null, string, null));
            return;
        }
        if (iResource.equals((Object)iResource2)) {
            String string = CompatibilityMessages.history_copyToSelf;
            Policy.log((IStatus)new ResourceStatus(566, iResource.getFullPath(), string, null));
            return;
        }
        final IPath iPath = iResource.getFullPath();
        final IPath iPath2 = iResource2.getFullPath();
        final HashSet hashSet = new HashSet();
        IHistoryStoreVisitor iHistoryStoreVisitor = new IHistoryStoreVisitor(){

            public boolean visit(HistoryStoreEntry historyStoreEntry) {
                IPath iPath3 = historyStoreEntry.getPath();
                int n = iPath.matchingFirstSegments(iPath3);
                if (n == 0) {
                    String string = NLS.bind((String)CompatibilityMessages.history_interalPathErrors, (Object)iPath, (Object)iPath3);
                    Policy.log((IStatus)new ResourceStatus(566, iPath, string, null));
                    return false;
                }
                if (!HistoryStore.this.stateAlreadyExists(iPath3 = iPath2.append(iPath3.removeFirstSegments(n)), historyStoreEntry.getUUID())) {
                    hashSet.add(iPath3);
                    HistoryStore.this.addState(iPath3, historyStoreEntry.getUUID(), historyStoreEntry.getLastModified());
                }
                return true;
            }
        };
        this.accept(iPath, iHistoryStoreVisitor, true);
        WorkspaceDescription workspaceDescription = this.workspace.internalGetDescription();
        int n = workspaceDescription.getMaxFileStates();
        try {
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                object = new LinkedList();
                indexCursor = this.store.getCursor();
                IPath iPath3 = (IPath)iterator.next();
                byte[] byArray = Convert.toUTF8((String)iPath3.toString());
                indexCursor.find(byArray);
                while (indexCursor.keyMatches(byArray)) {
                    object.add(HistoryStoreEntry.create(this.store, indexCursor));
                    indexCursor.next();
                }
                indexCursor.close();
                this.removeOldestEntries((List)object, n);
            }
        }
        catch (IndexedStoreException indexedStoreException) {
            object = NLS.bind((String)CompatibilityMessages.history_problemsPurging, (Object)iPath, (Object)iPath2);
            indexCursor = new ResourceStatus(568, iPath, (String)object, (Throwable)indexedStoreException);
            Policy.log((IStatus)indexCursor);
        }
        catch (CoreException coreException) {
            object = NLS.bind((String)CompatibilityMessages.history_problemsPurging, (Object)iPath, (Object)iPath2);
            indexCursor = new ResourceStatus(568, iPath, (String)object, (Throwable)coreException);
            Policy.log((IStatus)indexCursor);
        }
        try {
            this.store.commit();
        }
        catch (CoreException coreException) {
            object = NLS.bind((String)CompatibilityMessages.history_problemCopying, (Object)iPath, (Object)iPath2);
            indexCursor = new ResourceStatus(568, iPath, (String)object, (Throwable)coreException);
            Policy.log((IStatus)indexCursor);
        }
    }

    public boolean exists(IFileState iFileState) {
        return this.blobStore.fileFor(((FileState)iFileState).getUUID()).fetchInfo().exists();
    }

    public InputStream getContents(IFileState iFileState) throws CoreException {
        if (!iFileState.exists()) {
            String string = CompatibilityMessages.history_notValid;
            throw new ResourceException(271, iFileState.getFullPath(), string, null);
        }
        return this.blobStore.getBlob(((FileState)iFileState).getUUID());
    }

    public IFileState[] getStates(final IPath iPath, IProgressMonitor iProgressMonitor) {
        int n = this.workspace.internalGetDescription().getMaxFileStates();
        final ArrayList arrayList = new ArrayList(n);
        IHistoryStoreVisitor iHistoryStoreVisitor = new IHistoryStoreVisitor(){

            public boolean visit(HistoryStoreEntry historyStoreEntry) {
                arrayList.add(new FileState((IHistoryStore)HistoryStore.this, iPath, historyStoreEntry.getLastModified(), historyStoreEntry.getUUID()));
                return true;
            }
        };
        this.accept(iPath, iHistoryStoreVisitor, false);
        if (arrayList.isEmpty()) {
            return ICoreConstants.EMPTY_FILE_STATES;
        }
        IFileState[] iFileStateArray = new IFileState[arrayList.size()];
        int n2 = 0;
        while (n2 < iFileStateArray.length) {
            iFileStateArray[n2] = (IFileState)arrayList.get(arrayList.size() - (n2 + 1));
            ++n2;
        }
        return iFileStateArray;
    }

    private boolean isValid(IFileStore iFileStore) {
        boolean bl;
        WorkspaceDescription workspaceDescription = this.workspace.internalGetDescription();
        long l = iFileStore.fetchInfo().getLength();
        boolean bl2 = bl = l <= workspaceDescription.getMaxFileStateSize();
        if (Policy.DEBUG_HISTORY && !bl) {
            System.out.println("History: Ignoring file (too large). File: " + iFileStore.toString() + ", size: " + l + ", max: " + workspaceDescription.getMaxFileStateSize());
        }
        return bl;
    }

    protected void remove(HistoryStoreEntry historyStoreEntry) throws IndexedStoreException {
        try {
            Vector vector = this.store.getIndex().getObjectIdentifiersMatching(historyStoreEntry.getKey());
            if (vector.size() == 1) {
                this.store.removeObject((ObjectID)vector.get(0));
            } else if (vector.size() > 1) {
                String string = NLS.bind((String)CompatibilityMessages.history_tooManySimUpdates, (Object)historyStoreEntry.getPath(), (Object)new Date(historyStoreEntry.getLastModified()));
                ResourceStatus resourceStatus = new ResourceStatus(273, historyStoreEntry.getPath(), string, null);
                Policy.log((IStatus)resourceStatus);
            }
        }
        catch (Exception exception) {
            Object[] objectArray = new String[]{historyStoreEntry.getPath().toString(), new Date(historyStoreEntry.getLastModified()).toString(), historyStoreEntry.getUUID().toString()};
            String string = NLS.bind((String)CompatibilityMessages.history_specificProblemsCleaning, (Object[])objectArray);
            ResourceStatus resourceStatus = new ResourceStatus(273, null, string, (Throwable)exception);
            Policy.log((IStatus)resourceStatus);
        }
        this.blobsToRemove.add(historyStoreEntry.getUUID());
        historyStoreEntry.remove();
    }

    public void remove(IPath iPath, IProgressMonitor iProgressMonitor) {
        if (Path.ROOT.equals((Object)iPath)) {
            this.removeAll();
            return;
        }
        try {
            IndexCursor indexCursor = this.store.getCursor();
            byte[] byArray = Convert.toUTF8((String)iPath.toString());
            indexCursor.find(byArray);
            while (indexCursor.keyMatches(byArray)) {
                HistoryStoreEntry historyStoreEntry = HistoryStoreEntry.create(this.store, indexCursor);
                this.remove(historyStoreEntry);
            }
            indexCursor.close();
            this.store.commit();
        }
        catch (Exception exception) {
            String string = NLS.bind((String)CompatibilityMessages.history_problemsRemoving, (Object)iPath);
            ResourceStatus resourceStatus = new ResourceStatus(273, iPath, string, (Throwable)exception);
            Policy.log((IStatus)resourceStatus);
        }
    }

    private void removeAll() {
        try {
            IndexCursor indexCursor = this.store.getCursor();
            indexCursor.findFirstEntry();
            while (indexCursor.isSet()) {
                HistoryStoreEntry historyStoreEntry = HistoryStoreEntry.create(this.store, indexCursor);
                this.remove(historyStoreEntry);
            }
            indexCursor.close();
            this.store.commit();
        }
        catch (Exception exception) {
            String string = NLS.bind((String)CompatibilityMessages.history_problemsRemoving, (Object)this.workspace.getRoot().getFullPath());
            ResourceStatus resourceStatus = new ResourceStatus(273, this.workspace.getRoot().getFullPath(), string, (Throwable)exception);
            Policy.log((IStatus)resourceStatus);
        }
    }

    public void removeGarbage() {
        try {
            IndexCursor indexCursor = this.store.getCursor();
            indexCursor.findFirstEntry();
            while (!this.blobsToRemove.isEmpty() && indexCursor.isSet()) {
                HistoryStoreEntry historyStoreEntry = HistoryStoreEntry.create(this.store, indexCursor);
                this.blobsToRemove.remove(historyStoreEntry.getUUID());
                indexCursor.next();
            }
            indexCursor.close();
            this.blobStore.deleteBlobs(this.blobsToRemove);
            this.blobsToRemove = new HashSet();
        }
        catch (Exception exception) {
            String string = CompatibilityMessages.history_problemsCleaning;
            ResourceStatus resourceStatus = new ResourceStatus(273, null, string, (Throwable)exception);
            Policy.log((IStatus)resourceStatus);
        }
    }

    protected void removeOldestEntries(List list, int n) throws IndexedStoreException {
        if (list.size() <= n) {
            return;
        }
        int n2 = list.size() - n;
        int n3 = 0;
        while (n3 < n2) {
            this.remove((HistoryStoreEntry)list.get(n3));
            ++n3;
        }
    }

    protected void resetIndexedStore() {
        this.store.reset();
        File file = this.workspace.getMetaArea().getHistoryStoreLocation().toFile();
        Workspace.clear((File)file);
        file.mkdirs();
        String string = CompatibilityMessages.history_corrupt;
        ResourceStatus resourceStatus = new ResourceStatus(566, null, string, null);
        Policy.log((IStatus)resourceStatus);
    }

    public void shutdown(IProgressMonitor iProgressMonitor) {
        if (this.store == null) {
            return;
        }
        this.store.close();
    }

    public void startup(IProgressMonitor iProgressMonitor) {
    }

    boolean stateAlreadyExists(IPath iPath, final UniversalUniqueIdentifier universalUniqueIdentifier) {
        final boolean[] blArray = new boolean[1];
        IHistoryStoreVisitor iHistoryStoreVisitor = new IHistoryStoreVisitor(){

            public boolean visit(HistoryStoreEntry historyStoreEntry) {
                if (blArray[0] || universalUniqueIdentifier.equals((Object)historyStoreEntry.getUUID())) {
                    blArray[0] = true;
                    return false;
                }
                return true;
            }
        };
        this.accept(iPath, iHistoryStoreVisitor, false);
        return blArray[0];
    }
}

