/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.localstore;

import org.eclipse.core.internal.localstore.BucketTree;
import org.eclipse.core.internal.localstore.HistoryBucket;
import org.eclipse.core.internal.localstore.HistoryStore;
import org.eclipse.core.internal.localstore.HistoryStore2;
import org.eclipse.core.internal.localstore.HistoryStoreEntry;
import org.eclipse.core.internal.localstore.IHistoryStoreVisitor;
import org.eclipse.core.internal.resources.CompatibilityMessages;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.internal.utils.Policy;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;

public class HistoryStoreConverter {
    public IStatus convertHistory(Workspace workspace, IPath iPath, int n, HistoryStore2 historyStore2, boolean bl) {
        if (!iPath.toFile().isDirectory()) {
            return Status.OK_STATUS;
        }
        IPath iPath2 = iPath.append(".index");
        if (!iPath2.toFile().isFile()) {
            return Status.OK_STATUS;
        }
        long l = System.currentTimeMillis();
        final CoreException[] coreExceptionArray = new CoreException[1];
        final BucketTree bucketTree = historyStore2.getTree();
        final HistoryBucket historyBucket = (HistoryBucket)bucketTree.getCurrent();
        HistoryStore historyStore = new HistoryStore(workspace, iPath, n);
        historyStore.accept((IPath)Path.ROOT, new IHistoryStoreVisitor(){

            public boolean visit(HistoryStoreEntry historyStoreEntry) {
                try {
                    bucketTree.loadBucketFor(historyStoreEntry.getPath());
                }
                catch (CoreException coreException) {
                    coreExceptionArray[0] = coreException;
                    return false;
                }
                historyBucket.addBlob(historyStoreEntry.getPath(), historyStoreEntry.getUUID(), historyStoreEntry.getLastModified());
                return true;
            }
        }, true);
        try {
            bucketTree.getCurrent().save();
            historyStore.shutdown(null);
        }
        catch (CoreException coreException) {
            coreExceptionArray[0] = coreException;
        }
        if (Policy.DEBUG_HISTORY) {
            Policy.debug((String)("Time to convert local history: " + (System.currentTimeMillis() - l) + "ms."));
        }
        if (coreExceptionArray[0] != null) {
            String string = CompatibilityMessages.history_conversionFailed;
            MultiStatus multiStatus = new MultiStatus("org.eclipse.core.resources", 567, new IStatus[]{coreExceptionArray[0].getStatus()}, string, null);
            return multiStatus;
        }
        if (bl) {
            iPath2.toFile().renameTo(iPath2.addFileExtension(Long.toString(System.currentTimeMillis())).toFile());
        }
        String string = CompatibilityMessages.history_conversionSucceeded;
        return new Status(1, "org.eclipse.core.resources", 0, string, null);
    }
}

