/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.localstore;

import org.eclipse.core.internal.indexing.IndexCursor;
import org.eclipse.core.internal.indexing.IndexedStoreException;
import org.eclipse.core.internal.indexing.ObjectID;
import org.eclipse.core.internal.localstore.ILocalStoreConstants;
import org.eclipse.core.internal.properties.IndexedStoreWrapper;
import org.eclipse.core.internal.utils.Convert;
import org.eclipse.core.internal.utils.UniversalUniqueIdentifier;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class HistoryStoreEntry
implements ILocalStoreConstants {
    private IndexCursor cursor;
    private UniversalUniqueIdentifier uuid;
    private byte[] key;

    private HistoryStoreEntry(byte[] byArray, byte[] byArray2, IndexCursor indexCursor) {
        this.cursor = indexCursor;
        this.key = byArray;
        this.uuid = new UniversalUniqueIdentifier(byArray2);
    }

    public HistoryStoreEntry(IPath iPath, UniversalUniqueIdentifier universalUniqueIdentifier, long l, byte by) {
        this.key = this.keyToBytes(iPath, l, by);
        this.uuid = universalUniqueIdentifier;
    }

    protected boolean compare(byte[] byArray, byte[] byArray2) {
        if (byArray.length != byArray2.length) {
            return false;
        }
        int n = 0;
        while (n < byArray.length) {
            if (byArray[n] != byArray2[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public static HistoryStoreEntry create(IndexedStoreWrapper indexedStoreWrapper, IndexCursor indexCursor) throws CoreException, IndexedStoreException {
        byte[] byArray = indexCursor.getKey();
        ObjectID objectID = indexCursor.getValueAsObjectID();
        byte[] byArray2 = indexedStoreWrapper.getObject(objectID);
        return new HistoryStoreEntry(byArray, byArray2, indexCursor);
    }

    public byte getCount() {
        return this.key[this.key.length - 1];
    }

    public byte[] getKey() {
        return this.key;
    }

    public long getLastModified() {
        byte[] byArray = new byte[8];
        int n = this.key.length - 9;
        System.arraycopy(this.key, n, byArray, 0, 8);
        return Convert.bytesToLong((byte[])byArray);
    }

    public IPath getPath() {
        byte[] byArray = new byte[this.key.length - 9];
        System.arraycopy(this.key, 0, byArray, 0, byArray.length);
        return new Path(Convert.fromUTF8((byte[])byArray));
    }

    public UniversalUniqueIdentifier getUUID() {
        return this.uuid;
    }

    public static byte[] keyPrefixToBytes(IPath iPath, long l) {
        byte[] byArray = Convert.toUTF8((String)iPath.toString());
        byte[] byArray2 = Convert.longToBytes((long)l);
        byte[] byArray3 = new byte[byArray.length + byArray2.length];
        System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
        System.arraycopy(byArray2, 0, byArray3, byArray.length, byArray2.length);
        return byArray3;
    }

    protected byte[] keyToBytes(IPath iPath, long l, byte by) {
        byte[] byArray = HistoryStoreEntry.keyPrefixToBytes(iPath, l);
        byte[] byArray2 = new byte[byArray.length + 1];
        int n = 0;
        System.arraycopy(byArray, 0, byArray2, n, byArray.length);
        byArray2[n += byArray.length] = by;
        return byArray2;
    }

    public void remove() throws IndexedStoreException {
        if (this.cursor == null) {
            return;
        }
        this.reposition();
        if (!this.cursor.isSet()) {
            return;
        }
        this.cursor.remove();
    }

    protected void reposition() throws IndexedStoreException {
        if (this.cursor.isSet() && this.compare(this.cursor.getKey(), this.key)) {
            return;
        }
        this.cursor.find(this.key);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Path: ").append(this.getPath()).append("\n");
        stringBuffer.append("Last Modified: ").append(this.getLastModified()).append("\n");
        stringBuffer.append("Count: ").append(this.getCount()).append("\n");
        stringBuffer.append("UUID: ").append(this.uuid.toStringAsBytes()).append("\n");
        return stringBuffer.toString();
    }

    public byte[] valueToBytes() {
        return this.uuid.toBytes();
    }
}

