/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.properties;

import java.io.File;
import org.eclipse.core.internal.indexing.Index;
import org.eclipse.core.internal.indexing.IndexCursor;
import org.eclipse.core.internal.indexing.IndexedStore;
import org.eclipse.core.internal.indexing.IndexedStoreException;
import org.eclipse.core.internal.indexing.ObjectID;
import org.eclipse.core.internal.resources.CompatibilityMessages;
import org.eclipse.core.internal.resources.ResourceException;
import org.eclipse.core.internal.resources.ResourceStatus;
import org.eclipse.core.internal.utils.Policy;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.osgi.util.NLS;

public class IndexedStoreWrapper {
    private IndexedStore store;
    private IPath location;
    private static final String INDEX_NAME = "index";

    public IndexedStoreWrapper(IPath iPath) {
        this.location = iPath;
    }

    private void open() throws CoreException {
        try {
            String string = this.location.toOSString();
            this.store = IndexedStore.find(string);
            if (this.store == null) {
                this.store = new IndexedStore();
                this.store.open(string);
            }
        }
        catch (Exception exception) {
            String string = NLS.bind((String)CompatibilityMessages.indexed_couldNotOpen, (Object)this.location.toOSString());
            ResourceStatus resourceStatus = new ResourceStatus(272, this.location, string, (Throwable)exception);
            throw new CoreException((IStatus)resourceStatus);
        }
    }

    private void recreate() throws CoreException {
        this.close();
        File file = this.location.toFile();
        file.renameTo(this.location.addFileExtension("001").toFile());
        file.delete();
        if (!file.exists()) {
            try {
                this.open();
            }
            catch (CoreException coreException) {
                this.store = null;
                throw coreException;
            }
        }
    }

    public synchronized void close() {
        if (this.store == null) {
            return;
        }
        try {
            try {
                this.store.close();
            }
            catch (Exception exception) {
                String string = NLS.bind((String)CompatibilityMessages.indexed_couldNotClose, (Object)this.location.toOSString());
                Policy.log((IStatus)new ResourceStatus(272, this.location, string, (Throwable)exception));
                this.store = null;
            }
        }
        finally {
            this.store = null;
        }
    }

    public synchronized void commit() throws CoreException {
        if (this.store == null) {
            return;
        }
        try {
            this.store.commit();
        }
        catch (Exception exception) {
            String string = NLS.bind((String)CompatibilityMessages.indexed_couldNotCommit, (Object)this.location.toOSString());
            ResourceStatus resourceStatus = new ResourceStatus(272, this.location, string, (Throwable)exception);
            throw new ResourceException((IStatus)resourceStatus);
        }
    }

    private void create() throws CoreException {
        block2: {
            try {
                this.open();
            }
            catch (CoreException coreException) {
                Policy.log((IStatus)coreException.getStatus());
                this.recreate();
                if (this.store != null) break block2;
                String string = NLS.bind((String)CompatibilityMessages.indexed_couldNotCreate, (Object)this.location.toOSString());
                ResourceStatus resourceStatus = new ResourceStatus(272, this.location, string, null);
                throw new ResourceException((IStatus)resourceStatus);
            }
        }
    }

    private Index createIndex() throws CoreException {
        try {
            return this.getStore().createIndex(INDEX_NAME);
        }
        catch (Exception exception) {
            String string = NLS.bind((String)CompatibilityMessages.indexed_couldNotCreateIndex, (Object)this.location.toOSString());
            ResourceStatus resourceStatus = new ResourceStatus(272, this.location, string, (Throwable)exception);
            throw new ResourceException((IStatus)resourceStatus);
        }
    }

    public synchronized Index getIndex() throws CoreException {
        Exception exception = null;
        try {
            Index index = this.getStore().getIndex(INDEX_NAME);
            return index;
        }
        catch (IndexedStoreException indexedStoreException) {
            if (indexedStoreException.id == 11) {
                Index index = this.createIndex();
                return index;
            }
            exception = indexedStoreException;
            return null;
        }
        catch (CoreException coreException) {
            throw coreException;
        }
        catch (Exception exception2) {
            exception = exception2;
            return null;
        }
        finally {
            if (exception != null) {
                String string = NLS.bind((String)CompatibilityMessages.indexed_couldNotGetIndex, (Object)this.location.toOSString());
                ResourceStatus resourceStatus = new ResourceStatus(271, this.location, string, (Throwable)exception);
                throw new ResourceException((IStatus)resourceStatus);
            }
        }
    }

    public synchronized String getObjectAsString(ObjectID objectID) throws CoreException {
        try {
            return this.getStore().getObjectAsString(objectID);
        }
        catch (Exception exception) {
            String string = NLS.bind((String)CompatibilityMessages.indexed_couldNotRead, (Object)this.location.toOSString());
            throw new ResourceException(271, this.location, string, (Throwable)exception);
        }
    }

    private IndexedStore getStore() throws CoreException {
        if (this.store == null) {
            this.create();
        }
        return this.store;
    }

    public synchronized IndexCursor getCursor() throws CoreException {
        try {
            return this.getIndex().open();
        }
        catch (Exception exception) {
            String string = NLS.bind((String)CompatibilityMessages.indexed_couldNotCreateCursor, (Object)this.location.toOSString());
            throw new ResourceException(271, this.location, string, (Throwable)exception);
        }
    }

    public synchronized ObjectID createObject(String string) throws CoreException {
        try {
            return this.getStore().createObject(string);
        }
        catch (Exception exception) {
            String string2 = NLS.bind((String)CompatibilityMessages.indexed_couldNotWrite, (Object)this.location.toOSString());
            throw new ResourceException(272, this.location, string2, (Throwable)exception);
        }
    }

    public synchronized ObjectID createObject(byte[] byArray) throws CoreException {
        try {
            return this.getStore().createObject(byArray);
        }
        catch (Exception exception) {
            String string = NLS.bind((String)CompatibilityMessages.indexed_couldNotWrite, (Object)this.location.toOSString());
            throw new ResourceException(272, this.location, string, (Throwable)exception);
        }
    }

    public synchronized void removeObject(ObjectID objectID) throws CoreException {
        try {
            this.getStore().removeObject(objectID);
        }
        catch (Exception exception) {
            String string = NLS.bind((String)CompatibilityMessages.indexed_couldNotDelete, (Object)this.location.toOSString());
            throw new ResourceException(273, this.location, string, (Throwable)exception);
        }
    }

    public synchronized byte[] getObject(ObjectID objectID) throws CoreException {
        try {
            return this.getStore().getObject(objectID);
        }
        catch (Exception exception) {
            String string = NLS.bind((String)CompatibilityMessages.indexed_couldNotRead, (Object)this.location.toOSString());
            throw new ResourceException(271, this.location, string, (Throwable)exception);
        }
    }

    public synchronized void reset() {
        try {
            this.recreate();
        }
        catch (CoreException coreException) {
            Policy.log((IStatus)coreException.getStatus());
        }
    }
}

