/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.properties;

import java.io.File;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.internal.events.ILifecycleListener;
import org.eclipse.core.internal.events.LifecycleEvent;
import org.eclipse.core.internal.properties.IPropertyManager;
import org.eclipse.core.internal.properties.PropertyStore;
import org.eclipse.core.internal.properties.QueryResults;
import org.eclipse.core.internal.properties.ResourceName;
import org.eclipse.core.internal.properties.StoredProperty;
import org.eclipse.core.internal.resources.CompatibilityMessages;
import org.eclipse.core.internal.resources.IManager;
import org.eclipse.core.internal.resources.ProjectInfo;
import org.eclipse.core.internal.resources.Resource;
import org.eclipse.core.internal.resources.ResourceException;
import org.eclipse.core.internal.resources.ResourceInfo;
import org.eclipse.core.internal.resources.RootInfo;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.osgi.util.NLS;

public class PropertyManager
implements IManager,
ILifecycleListener,
IPropertyManager {
    protected Workspace workspace;

    public PropertyManager(Workspace workspace) {
        this.workspace = workspace;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closePropertyStore(IResource iResource) throws CoreException {
        PropertyStore propertyStore = this.getPropertyStoreOrNull(iResource);
        if (propertyStore == null) {
            return;
        }
        PropertyStore propertyStore2 = propertyStore;
        synchronized (propertyStore2) {
            propertyStore.shutdown(null);
            this.setPropertyStore(iResource, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copy(IResource iResource, IResource iResource2, int n) throws CoreException {
        PropertyStore propertyStore = this.getPropertyStore(iResource);
        PropertyStore propertyStore2 = this.getPropertyStore(iResource2);
        PropertyStore propertyStore3 = propertyStore;
        synchronized (propertyStore3) {
            this.assertRunning(iResource, propertyStore);
            PropertyStore propertyStore4 = propertyStore2;
            synchronized (propertyStore4) {
                this.assertRunning(iResource2, propertyStore2);
                this.copyProperties(iResource, iResource2, n);
                propertyStore.commit();
                propertyStore2.commit();
            }
        }
    }

    private void assertRunning(IResource iResource, PropertyStore propertyStore) throws CoreException {
        if (!propertyStore.isRunning()) {
            String string = NLS.bind((String)CompatibilityMessages.resources_mustExist, (Object)iResource.getFullPath());
            throw new ResourceException(368, iResource.getFullPath(), string, null);
        }
    }

    private void copyProperties(IResource iResource, IResource iResource2, int n) throws CoreException {
        PropertyStore propertyStore = this.getPropertyStore(iResource);
        PropertyStore propertyStore2 = this.getPropertyStore(iResource2);
        ResourceName resourceName = this.getPropertyKey(iResource);
        ResourceName resourceName2 = this.getPropertyKey(iResource2);
        QueryResults queryResults = propertyStore.getAll(resourceName, n);
        Enumeration enumeration = queryResults.getResourceNames();
        while (enumeration.hasMoreElements()) {
            ResourceName resourceName3 = (ResourceName)enumeration.nextElement();
            List list = queryResults.getResults(resourceName3);
            if (list.isEmpty()) continue;
            StoredProperty[] storedPropertyArray = new StoredProperty[list.size()];
            storedPropertyArray = list.toArray(storedPropertyArray);
            int n2 = iResource.getProjectRelativePath().matchingFirstSegments(resourceName3.getPath());
            IPath iPath = resourceName2.getPath().append(resourceName3.getPath().removeFirstSegments(n2));
            resourceName3 = new ResourceName(resourceName3.getQualifier(), iPath);
            propertyStore2.set(resourceName3, storedPropertyArray, 0, 2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteProperties(IResource iResource, int n) throws CoreException {
        switch (iResource.getType()) {
            case 1: 
            case 2: {
                PropertyStore propertyStore;
                PropertyStore propertyStore2 = propertyStore = this.getPropertyStore(iResource);
                synchronized (propertyStore2) {
                    this.assertRunning(iResource, propertyStore);
                    propertyStore.removeAll(this.getPropertyKey(iResource), n);
                    propertyStore.commit();
                    break;
                }
            }
            case 4: 
            case 8: {
                this.deletePropertyStore(iResource, true);
            }
        }
    }

    public void deleteResource(IResource iResource) throws CoreException {
        switch (iResource.getType()) {
            case 1: 
            case 2: 
            case 8: {
                this.deleteProperties(iResource, 2);
                break;
            }
            case 4: {
                this.deletePropertyStore(iResource, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deletePropertyStore(IResource iResource, boolean bl) throws CoreException {
        PropertyStore propertyStore = this.getPropertyStoreOrNull(iResource);
        if (propertyStore == null) {
            return;
        }
        PropertyStore propertyStore2 = propertyStore;
        synchronized (propertyStore2) {
            ResourceInfo resourceInfo;
            propertyStore.shutdown(null);
            this.workspace.getMetaArea().getPropertyStoreLocation(iResource).toFile().delete();
            if (bl && (resourceInfo = this.getPropertyHost(iResource).getResourceInfo(false, false)) != null) {
                resourceInfo.setPropertyStore(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getProperty(IResource iResource, QualifiedName qualifiedName) throws CoreException {
        PropertyStore propertyStore;
        PropertyStore propertyStore2 = propertyStore = this.getPropertyStore(iResource);
        synchronized (propertyStore2) {
            this.assertRunning(iResource, propertyStore);
            StoredProperty storedProperty = propertyStore.get(this.getPropertyKey(iResource), qualifiedName);
            return storedProperty == null ? null : storedProperty.getStringValue();
        }
    }

    private Resource getPropertyHost(IResource iResource) {
        return (Resource)(iResource.getType() == 8 ? iResource : iResource.getProject());
    }

    private ResourceName getPropertyKey(IResource iResource) {
        return new ResourceName("", iResource.getProjectRelativePath());
    }

    PropertyStore getPropertyStore(IResource iResource) throws CoreException {
        return this.getPropertyStore(iResource, true);
    }

    PropertyStore getPropertyStore(IResource iResource, boolean bl) throws CoreException {
        try {
            Resource resource = this.getPropertyHost(iResource);
            ResourceInfo resourceInfo = resource.getResourceInfo(false, false);
            if (resourceInfo == null) {
                String string = NLS.bind((String)CompatibilityMessages.properties_storeNotAvailable, (Object)iResource.getFullPath());
                throw new ResourceException(271, iResource.getFullPath(), string, null);
            }
            PropertyStore propertyStore = (PropertyStore)resourceInfo.getPropertyStore();
            if (propertyStore == null) {
                propertyStore = this.openPropertyStore((IResource)resource, bl);
            }
            return propertyStore;
        }
        catch (Exception exception) {
            if (exception instanceof CoreException) {
                throw (CoreException)((Object)exception);
            }
            String string = NLS.bind((String)CompatibilityMessages.properties_storeNotAvailable, (Object)iResource.getFullPath());
            throw new ResourceException(271, iResource.getFullPath(), string, (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PropertyStore getPropertyStoreOrNull(IResource iResource) {
        PropertyStore propertyStore;
        Resource resource = this.getPropertyHost(iResource);
        ResourceInfo resourceInfo = resource.getResourceInfo(false, false);
        if (resourceInfo != null && (propertyStore = (PropertyStore)resourceInfo.getPropertyStore()) != null) {
            PropertyStore propertyStore2 = propertyStore;
            synchronized (propertyStore2) {
                if (propertyStore.isRunning()) {
                    return propertyStore;
                }
            }
        }
        return null;
    }

    public void handleEvent(LifecycleEvent lifecycleEvent) throws CoreException {
        if (lifecycleEvent.kind == 1) {
            this.closePropertyStore(lifecycleEvent.resource);
        }
    }

    private PropertyStore openPropertyStore(IResource iResource, boolean bl) {
        int n = iResource.getType();
        Assert.isTrue((n != 1 && n != 2 ? 1 : 0) != 0);
        IPath iPath = this.workspace.getMetaArea().getPropertyStoreLocation(iResource);
        File file = iPath.toFile();
        if (!bl && !file.isFile()) {
            return null;
        }
        file.getParentFile().mkdirs();
        PropertyStore propertyStore = new PropertyStore(iPath);
        this.setPropertyStore(iResource, propertyStore);
        return propertyStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProperty(IResource iResource, QualifiedName qualifiedName, String string) throws CoreException {
        PropertyStore propertyStore;
        PropertyStore propertyStore2 = propertyStore = this.getPropertyStore(iResource);
        synchronized (propertyStore2) {
            this.assertRunning(iResource, propertyStore);
            if (string == null) {
                propertyStore.remove(this.getPropertyKey(iResource), qualifiedName);
            } else {
                StoredProperty storedProperty = new StoredProperty(qualifiedName, string);
                propertyStore.set(this.getPropertyKey(iResource), storedProperty);
            }
            propertyStore.commit();
        }
    }

    private void setPropertyStore(IResource iResource, PropertyStore propertyStore) {
        ResourceInfo resourceInfo = this.getPropertyHost(iResource).getResourceInfo(false, false);
        if (resourceInfo.getType() == 4) {
            ((ProjectInfo)resourceInfo).setPropertyStore((Object)propertyStore);
        } else {
            ((RootInfo)resourceInfo).setPropertyStore((Object)propertyStore);
        }
    }

    public void shutdown(IProgressMonitor iProgressMonitor) throws CoreException {
        this.closePropertyStore((IResource)this.workspace.getRoot());
    }

    public void startup(IProgressMonitor iProgressMonitor) throws CoreException {
        this.workspace.addLifecycleListener((ILifecycleListener)this);
    }

    public Map getProperties(IResource iResource) throws CoreException {
        PropertyStore propertyStore = this.getPropertyStore(iResource);
        if (propertyStore == null) {
            return Collections.EMPTY_MAP;
        }
        IPath iPath = iResource.getProjectRelativePath();
        ResourceName resourceName = new ResourceName("", iPath);
        QueryResults queryResults = propertyStore.getAll(resourceName, 1);
        List list = queryResults.getResults(resourceName);
        int n = list.size();
        if (n == 0) {
            return Collections.EMPTY_MAP;
        }
        HashMap<QualifiedName, String> hashMap = new HashMap<QualifiedName, String>();
        int n2 = 0;
        while (n2 < n) {
            StoredProperty storedProperty = (StoredProperty)list.get(n2);
            hashMap.put(storedProperty.getName(), storedProperty.getStringValue());
            ++n2;
        }
        return hashMap;
    }
}

