/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.properties;

import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import org.eclipse.core.internal.indexing.IndexCursor;
import org.eclipse.core.internal.indexing.ObjectID;
import org.eclipse.core.internal.properties.IVisitor;
import org.eclipse.core.internal.properties.IndexedStoreWrapper;
import org.eclipse.core.internal.properties.QueryResults;
import org.eclipse.core.internal.properties.ResourceName;
import org.eclipse.core.internal.properties.StoreKey;
import org.eclipse.core.internal.properties.StoredProperty;
import org.eclipse.core.internal.resources.CompatibilityMessages;
import org.eclipse.core.internal.resources.ResourceException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.osgi.util.NLS;

public class PropertyStore {
    protected IndexedStoreWrapper store = null;
    public static final int CREATE = 0;
    public static final int UPDATE = 1;
    public static final int SET_UPDATE = 2;
    public static final int SET_SKIP = 3;
    public static final int IGNORE_MISSING = 0;
    public static final int FAIL_MISSING = 1;

    public PropertyStore(IPath iPath) {
        this.store = new IndexedStoreWrapper(iPath);
    }

    protected boolean basicExists(StoreKey storeKey) throws CoreException {
        byte[] byArray = storeKey.toBytes();
        IndexCursor indexCursor = this.store.getCursor();
        try {
            indexCursor.find(byArray);
            boolean bl = indexCursor.keyEquals(byArray);
            indexCursor.close();
            return bl;
        }
        catch (Exception exception) {
            String string = NLS.bind((String)CompatibilityMessages.properties_couldNotReadProp, (Object)storeKey.getQualifier(), (Object)storeKey.getLocalName());
            throw new ResourceException(271, storeKey.getResourceName().getPath(), string, (Throwable)exception);
        }
    }

    protected void basicInsert(StoreKey storeKey, String string) throws CoreException {
        try {
            ObjectID objectID = this.store.createObject(string);
            this.store.getIndex().insert(storeKey.toBytes(), objectID);
        }
        catch (Exception exception) {
            String string2 = NLS.bind((String)CompatibilityMessages.properties_couldNotWriteProp, (Object)storeKey.getQualifier(), (Object)storeKey.getLocalName());
            throw new ResourceException(272, storeKey.getResourceName().getPath(), string2, (Throwable)exception);
        }
    }

    protected boolean basicRemove(ResourceName resourceName, QualifiedName qualifiedName) throws CoreException {
        StoreKey storeKey = new StoreKey(resourceName, qualifiedName);
        byte[] byArray = storeKey.toBytes();
        boolean bl = false;
        IndexCursor indexCursor = this.store.getCursor();
        try {
            indexCursor.find(byArray);
            if (indexCursor.keyEquals(byArray)) {
                bl = true;
                ObjectID objectID = indexCursor.getValueAsObjectID();
                this.store.removeObject(objectID);
                indexCursor.remove();
            }
            indexCursor.close();
        }
        catch (Exception exception) {
            String string = NLS.bind((String)CompatibilityMessages.properties_couldNotDeleteProp, (Object)storeKey.getQualifier(), (Object)storeKey.getLocalName());
            throw new ResourceException(273, resourceName.getPath(), string, (Throwable)exception);
        }
        return bl;
    }

    protected void basicUpdate(StoreKey storeKey, String string) throws CoreException {
        byte[] byArray = storeKey.toBytes();
        IndexCursor indexCursor = this.store.getCursor();
        try {
            indexCursor.find(byArray);
            if (indexCursor.keyEquals(byArray)) {
                ObjectID objectID = indexCursor.getValueAsObjectID();
                this.store.removeObject(objectID);
                ObjectID objectID2 = this.store.createObject(string);
                indexCursor.updateValue(objectID2);
            }
            indexCursor.close();
        }
        catch (Exception exception) {
            String string2 = NLS.bind((String)CompatibilityMessages.properties_couldNotWriteProp, (Object)storeKey.getQualifier(), (Object)storeKey.getLocalName());
            throw new ResourceException(272, storeKey.getResourceName().getPath(), string2, (Throwable)exception);
        }
    }

    protected synchronized void commonSet(ResourceName resourceName, StoredProperty[] storedPropertyArray, int n, int n2, QueryResults queryResults) throws CoreException {
        if (n == 0) {
            int n3 = 0;
            while (n3 < storedPropertyArray.length) {
                StoredProperty storedProperty = storedPropertyArray[n3];
                StoreKey storeKey = new StoreKey(resourceName, storedProperty.getName());
                boolean bl = this.basicExists(storeKey);
                if (bl && n2 == 0 || !bl && n2 == 1) {
                    queryResults.add(resourceName, storedProperty);
                } else if (bl && n2 != 3) {
                    this.basicUpdate(storeKey, storedProperty.getStringValue());
                } else {
                    this.basicInsert(storeKey, storedProperty.getStringValue());
                }
                ++n3;
            }
        } else {
            Enumeration enumeration = this.deepResourceNames(resourceName);
            while (enumeration.hasMoreElements()) {
                this.commonSet((ResourceName)enumeration.nextElement(), storedPropertyArray, 0, n2, queryResults);
            }
        }
    }

    public Enumeration deepResourceNames(ResourceName resourceName) throws CoreException {
        final HashSet hashSet = new HashSet(10);
        IVisitor iVisitor = new IVisitor(){

            public void visit(ResourceName resourceName, StoredProperty storedProperty, IndexCursor indexCursor) {
                hashSet.add(resourceName);
            }

            public boolean requiresValue(ResourceName resourceName, QualifiedName qualifiedName) {
                return false;
            }
        };
        this.recordsDeepMatching(resourceName, iVisitor);
        return Collections.enumeration(hashSet);
    }

    public StoredProperty get(ResourceName resourceName, QualifiedName qualifiedName) throws CoreException {
        final Object[] objectArray = new Object[1];
        IVisitor iVisitor = new IVisitor(){

            public void visit(ResourceName resourceName, StoredProperty storedProperty, IndexCursor indexCursor) {
                objectArray[0] = storedProperty;
            }

            public boolean requiresValue(ResourceName resourceName, QualifiedName qualifiedName) {
                return true;
            }
        };
        this.recordsMatching(resourceName, qualifiedName, iVisitor);
        return (StoredProperty)objectArray[0];
    }

    public QueryResults getAll(ResourceName resourceName, int n) throws CoreException {
        final QueryResults queryResults = new QueryResults();
        IVisitor iVisitor = new IVisitor(){

            public void visit(ResourceName resourceName, StoredProperty storedProperty, IndexCursor indexCursor) {
                queryResults.add(resourceName, storedProperty);
            }

            public boolean requiresValue(ResourceName resourceName, QualifiedName qualifiedName) {
                return true;
            }
        };
        if (n == 0) {
            this.recordsMatching(resourceName, iVisitor);
        } else {
            this.recordsDeepMatching(resourceName, iVisitor);
        }
        return queryResults;
    }

    public QueryResults getNames(ResourceName resourceName, int n) throws CoreException {
        QueryResults queryResults = new QueryResults();
        if (n == 0) {
            this.recordsMatching(resourceName, this.propertyNameVisitor(queryResults));
        } else {
            this.recordsDeepMatching(resourceName, this.propertyNameVisitor(queryResults));
        }
        return queryResults;
    }

    public boolean isRunning() {
        return this.store != null;
    }

    protected IVisitor propertyNameVisitor(final QueryResults queryResults) {
        return new IVisitor(){

            public void visit(ResourceName resourceName, StoredProperty storedProperty, IndexCursor indexCursor) {
                queryResults.add(resourceName, storedProperty.getName());
            }

            public boolean requiresValue(ResourceName resourceName, QualifiedName qualifiedName) {
                return false;
            }
        };
    }

    protected void recordsDeepMatching(ResourceName resourceName, IVisitor iVisitor) throws CoreException {
        StoreKey storeKey = new StoreKey(resourceName, true);
        byte[] byArray = storeKey.toBytes();
        int n = byArray.length;
        IndexCursor indexCursor = this.store.getCursor();
        try {
            indexCursor.find(byArray);
            while (indexCursor.keyMatches(byArray)) {
                byte[] byArray2 = indexCursor.getKey();
                if (n == 1 || byArray2[n] == 0 || byArray2[n] == 47) {
                    this.visitPropertyAt(indexCursor, iVisitor);
                }
                indexCursor.next();
            }
            indexCursor.close();
        }
        catch (Exception exception) {
            throw new ResourceException(271, resourceName.getPath(), CompatibilityMessages.properties_storeProblem, (Throwable)exception);
        }
    }

    protected void recordsMatching(ResourceName resourceName, IVisitor iVisitor) throws CoreException {
        StoreKey storeKey = new StoreKey(resourceName, false);
        byte[] byArray = storeKey.toBytes();
        IndexCursor indexCursor = this.store.getCursor();
        try {
            indexCursor.find(byArray);
            while (indexCursor.keyMatches(byArray)) {
                this.visitPropertyAt(indexCursor, iVisitor);
                indexCursor.next();
            }
            indexCursor.close();
        }
        catch (Exception exception) {
            this.store.reset();
            throw new ResourceException(271, resourceName.getPath(), CompatibilityMessages.properties_storeProblem, (Throwable)exception);
        }
    }

    protected void recordsMatching(ResourceName resourceName, QualifiedName qualifiedName, IVisitor iVisitor) throws CoreException {
        StoreKey storeKey = new StoreKey(resourceName, qualifiedName);
        byte[] byArray = storeKey.toBytes();
        IndexCursor indexCursor = this.store.getCursor();
        try {
            indexCursor.find(byArray);
            if (indexCursor.keyEquals(byArray)) {
                this.visitPropertyAt(indexCursor, iVisitor);
            }
            indexCursor.close();
        }
        catch (Exception exception) {
            this.store.reset();
            throw new ResourceException(271, resourceName.getPath(), CompatibilityMessages.properties_storeProblem, (Throwable)exception);
        }
    }

    public QueryResults remove(ResourceName resourceName, QualifiedName[] qualifiedNameArray, int n, int n2) throws CoreException {
        QueryResults queryResults = new QueryResults();
        if (n == 0) {
            int n3 = 0;
            while (n3 < qualifiedNameArray.length) {
                boolean bl = this.basicRemove(resourceName, qualifiedNameArray[n3]);
                if (!bl && n2 == 1) {
                    queryResults.add(resourceName, qualifiedNameArray[n3]);
                }
                ++n3;
            }
        } else {
            Enumeration enumeration = this.deepResourceNames(resourceName);
            while (enumeration.hasMoreElements()) {
                ResourceName resourceName2 = (ResourceName)enumeration.nextElement();
                int n4 = 0;
                while (n4 < qualifiedNameArray.length) {
                    boolean bl = this.basicRemove(resourceName2, qualifiedNameArray[n4]);
                    if (!bl && n2 == 1) {
                        queryResults.add(resourceName2, qualifiedNameArray[n4]);
                    }
                    ++n4;
                }
            }
        }
        return queryResults;
    }

    public void remove(ResourceName resourceName, QualifiedName qualifiedName) throws CoreException {
        this.remove(resourceName, new QualifiedName[]{qualifiedName}, 0, 0);
    }

    public void removeAll(ResourceName resourceName, int n) throws CoreException {
        QueryResults queryResults = this.getNames(resourceName, n);
        Enumeration enumeration = queryResults.getResourceNames();
        while (enumeration.hasMoreElements()) {
            ResourceName resourceName2 = (ResourceName)enumeration.nextElement();
            Enumeration enumeration2 = Collections.enumeration(queryResults.getResults(resourceName2));
            while (enumeration2.hasMoreElements()) {
                QualifiedName qualifiedName = (QualifiedName)enumeration2.nextElement();
                this.basicRemove(resourceName2, qualifiedName);
            }
        }
    }

    public QueryResults set(ResourceName resourceName, StoredProperty[] storedPropertyArray, int n, int n2) throws CoreException {
        QueryResults queryResults = new QueryResults();
        this.commonSet(resourceName, storedPropertyArray, n, n2, queryResults);
        return queryResults;
    }

    public void set(ResourceName resourceName, StoredProperty storedProperty) throws CoreException {
        this.commonSet(resourceName, new StoredProperty[]{storedProperty}, 0, 2, null);
    }

    public void shutdown(IProgressMonitor iProgressMonitor) {
        if (this.store == null) {
            return;
        }
        try {
            this.store.close();
        }
        finally {
            this.store = null;
        }
    }

    public void startup(IProgressMonitor iProgressMonitor) {
    }

    protected void visitPropertyAt(IndexCursor indexCursor, IVisitor iVisitor) throws CoreException {
        try {
            StoreKey storeKey = new StoreKey(indexCursor.getKey());
            ResourceName resourceName = storeKey.getResourceName();
            QualifiedName qualifiedName = storeKey.getPropertyName();
            String string = null;
            if (iVisitor.requiresValue(resourceName, qualifiedName)) {
                string = this.store.getObjectAsString(indexCursor.getValueAsObjectID());
            }
            iVisitor.visit(resourceName, new StoredProperty(qualifiedName, string), indexCursor);
        }
        catch (Exception exception) {
            throw new ResourceException(271, null, CompatibilityMessages.properties_storeProblem, (Throwable)exception);
        }
    }

    public void commit() throws CoreException {
        this.store.commit();
    }
}

