/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.properties;

import java.io.File;
import org.eclipse.core.internal.indexing.IndexCursor;
import org.eclipse.core.internal.localstore.BucketTree;
import org.eclipse.core.internal.properties.IVisitor;
import org.eclipse.core.internal.properties.PropertyBucket;
import org.eclipse.core.internal.properties.PropertyManager;
import org.eclipse.core.internal.properties.PropertyManager2;
import org.eclipse.core.internal.properties.PropertyStore;
import org.eclipse.core.internal.properties.ResourceName;
import org.eclipse.core.internal.properties.StoredProperty;
import org.eclipse.core.internal.resources.CompatibilityMessages;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;

public class PropertyStoreConverter {
    public IStatus convertProperties(Workspace workspace, final PropertyManager2 propertyManager2) {
        File file = propertyManager2.getVersionFile();
        if (file.isFile()) {
            return Status.OK_STATUS;
        }
        final boolean[] blArray = new boolean[1];
        final PropertyManager propertyManager = new PropertyManager(workspace);
        try {
            workspace.getRoot().accept(new IResourceVisitor(){

                public boolean visit(IResource iResource) throws CoreException {
                    ConversionVisitor conversionVisitor = new ConversionVisitor(iResource.getFullPath(), propertyManager2.getTree());
                    PropertyStore propertyStore = propertyManager.getPropertyStore(iResource, false);
                    if (propertyStore == null) {
                        return true;
                    }
                    propertyStore.recordsDeepMatching(new ResourceName("", iResource.getProjectRelativePath()), conversionVisitor);
                    propertyManager.closePropertyStore(iResource);
                    blArray[0] = blArray[0] || conversionVisitor.hasWorked();
                    return true;
                }
            }, 1, 0);
            propertyManager2.getTree().getCurrent().save();
        }
        catch (CoreException coreException) {
            String string = CompatibilityMessages.properties_conversionFailed;
            return new MultiStatus("org.eclipse.core.resources", 567, new IStatus[]{coreException.getStatus()}, string, null);
        }
        if (!blArray[0]) {
            return Status.OK_STATUS;
        }
        String string = CompatibilityMessages.properties_conversionSucceeded;
        return new Status(1, "org.eclipse.core.resources", 0, string, null);
    }

    class ConversionVisitor
    implements IVisitor {
        private IPath basePath;
        private BucketTree target;
        private boolean worked;

        public ConversionVisitor(IPath iPath, BucketTree bucketTree) {
            this.target = bucketTree;
            this.basePath = iPath;
        }

        public boolean hasWorked() {
            return this.worked;
        }

        public boolean requiresValue(ResourceName resourceName, QualifiedName qualifiedName) {
            return true;
        }

        public void visit(ResourceName resourceName, StoredProperty storedProperty, IndexCursor indexCursor) throws CoreException {
            IPath iPath = this.basePath.append(resourceName.getPath());
            this.target.loadBucketFor(iPath);
            ((PropertyBucket)this.target.getCurrent()).setProperty(iPath, storedProperty.getName(), storedProperty.getStringValue());
            this.worked = true;
        }
    }
}

