/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.properties;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import org.eclipse.core.internal.properties.ResourceName;
import org.eclipse.core.internal.resources.CompatibilityMessages;
import org.eclipse.core.internal.resources.ResourceException;
import org.eclipse.core.internal.utils.Convert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.osgi.util.NLS;

public class StoreKey {
    protected byte[] value = null;
    protected boolean matchPrefix = false;
    protected ResourceName resourceName = null;
    protected String qualifier = null;
    protected String localName = null;

    public StoreKey(byte[] byArray) throws CoreException {
        this.value = byArray;
        this.initializeObjects();
    }

    public StoreKey(ResourceName resourceName, QualifiedName qualifiedName) throws CoreException {
        this.resourceName = resourceName;
        this.qualifier = qualifiedName.getQualifier();
        this.localName = qualifiedName.getLocalName();
        this.initializeBytes();
    }

    public StoreKey(ResourceName resourceName, boolean bl) throws CoreException {
        this.resourceName = resourceName;
        this.matchPrefix = bl;
        this.initializeBytes();
    }

    public String getLocalName() {
        return this.localName;
    }

    public QualifiedName getPropertyName() {
        return new QualifiedName(this.qualifier, this.localName);
    }

    public String getQualifier() {
        return this.qualifier;
    }

    public ResourceName getResourceName() {
        return this.resourceName;
    }

    private void initializeBytes() throws CoreException {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            this.writeNullTerminated(byteArrayOutputStream, this.resourceName.getQualifier());
            String string = this.resourceName.getPath().toString();
            if (this.matchPrefix) {
                this.writeBytes(byteArrayOutputStream, string);
                if (this.qualifier != null || this.localName != null) {
                    String string2 = NLS.bind((String)CompatibilityMessages.properties_invalidPropName, (Object)this.qualifier, (Object)this.localName);
                    throw new ResourceException(77, null, string2, null);
                }
            } else {
                this.writeNullTerminated(byteArrayOutputStream, string);
            }
            if (this.qualifier != null) {
                this.writeNullTerminated(byteArrayOutputStream, this.qualifier);
                if (this.localName != null) {
                    this.writeNullTerminated(byteArrayOutputStream, this.localName);
                }
            } else if (this.localName != null) {
                String string3 = NLS.bind((String)CompatibilityMessages.properties_invalidPropName, (Object)this.qualifier, (Object)this.localName);
                throw new ResourceException(77, null, string3, null);
            }
            this.value = byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            throw new ResourceException(566, null, CompatibilityMessages.properties_storeProblem, (Throwable)iOException);
        }
    }

    protected void initializeObjects() throws CoreException {
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.value);
            String string = this.readNullTerminated(byteArrayInputStream);
            String string2 = this.readNullTerminated(byteArrayInputStream);
            this.resourceName = new ResourceName(string, (IPath)new Path(string2));
            this.qualifier = this.readNullTerminated(byteArrayInputStream);
            this.localName = this.readNullTerminated(byteArrayInputStream);
        }
        catch (IOException iOException) {
            throw new ResourceException(566, null, CompatibilityMessages.properties_storeProblem, (Throwable)iOException);
        }
    }

    private String readNullTerminated(ByteArrayInputStream byteArrayInputStream) throws IOException {
        int n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        while ((n = byteArrayInputStream.read()) > 0) {
            byteArrayOutputStream.write(n);
        }
        if (n == -1) {
            throw new EOFException();
        }
        return Convert.fromUTF8((byte[])byteArrayOutputStream.toByteArray());
    }

    public byte[] toBytes() {
        return this.value;
    }

    public String toString() {
        return new String(this.toBytes());
    }

    private void writeBytes(ByteArrayOutputStream byteArrayOutputStream, String string) throws IOException {
        byte[] byArray = Convert.toUTF8((String)string);
        byteArrayOutputStream.write(byArray);
    }

    private void writeNullTerminated(ByteArrayOutputStream byteArrayOutputStream, String string) throws IOException {
        this.writeBytes(byteArrayOutputStream, string);
        byteArrayOutputStream.write(0);
    }
}

