/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources;

import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.internal.localstore.HistoryStore;
import org.eclipse.core.internal.localstore.HistoryStore2;
import org.eclipse.core.internal.localstore.HistoryStoreConverter;
import org.eclipse.core.internal.localstore.IHistoryStore;
import org.eclipse.core.internal.properties.IPropertyManager;
import org.eclipse.core.internal.properties.PropertyManager;
import org.eclipse.core.internal.properties.PropertyManager2;
import org.eclipse.core.internal.properties.PropertyStoreConverter;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.internal.utils.Policy;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;

public class ResourcesCompatibility {
    public static IHistoryStore createHistoryStore(IPath iPath, int n, boolean bl, boolean bl2, boolean bl3) {
        Workspace workspace = (Workspace)ResourcesPlugin.getWorkspace();
        if (!bl) {
            return new HistoryStore(workspace, iPath, n);
        }
        IFileStore iFileStore = EFS.getLocalFileSystem().getStore(iPath);
        HistoryStore2 historyStore2 = new HistoryStore2(workspace, iFileStore, n);
        if (!bl2) {
            return historyStore2;
        }
        IStatus iStatus = new HistoryStoreConverter().convertHistory(workspace, iPath, n, historyStore2, bl3);
        if (iStatus.getSeverity() != 0) {
            Policy.log((IStatus)iStatus);
        }
        return historyStore2;
    }

    public static IPropertyManager createPropertyManager(boolean bl, boolean bl2) {
        Workspace workspace = (Workspace)ResourcesPlugin.getWorkspace();
        if (!bl) {
            return new PropertyManager(workspace);
        }
        PropertyManager2 propertyManager2 = new PropertyManager2(workspace);
        if (!bl2) {
            return propertyManager2;
        }
        IStatus iStatus = new PropertyStoreConverter().convertProperties(workspace, propertyManager2);
        if (iStatus.getSeverity() != 0) {
            Policy.log((IStatus)iStatus);
        }
        return propertyManager2;
    }
}

