/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.css.jface.viewers;

import org.eclipse.e4.ui.css.core.css2.CSS2FontPropertiesHelpers;
import org.eclipse.e4.ui.css.core.dom.properties.css2.CSS2FontProperties;
import org.eclipse.e4.ui.css.core.engine.CSSEngine;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Widget;
import org.w3c.dom.Element;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.css.CSSValue;

public class CSSBaseLabelProvider
extends LabelProvider {
    protected CSSEngine engine;
    protected StructuredViewer viewer;

    public CSSBaseLabelProvider(CSSEngine cSSEngine, StructuredViewer structuredViewer) {
        this.engine = cSSEngine;
        this.viewer = structuredViewer;
    }

    protected Font getFont(Object object, String string, int n) {
        Widget widget = this.getWidget(object, n);
        return this.getFont(widget, string);
    }

    protected Font getFont(Object object, String string) {
        Widget widget = this.getWidget(object);
        return this.getFont(widget, string);
    }

    protected Font getFont(Widget widget, String string) {
        CSSValue cSSValue = this.getCSSValue(widget, string);
        if (cSSValue == null) {
            return null;
        }
        CSS2FontProperties cSS2FontProperties = CSS2FontPropertiesHelpers.createCSS2FontProperties((CSSValue)cSSValue, (String)string);
        try {
            return (Font)this.engine.convert((CSSValue)cSS2FontProperties, Font.class, (Object)widget.getDisplay());
        }
        catch (Exception exception) {
            this.engine.handleExceptions(exception);
            return null;
        }
    }

    protected Image getImage(Object object, String string, int n) {
        Widget widget = this.getWidget(object, n);
        return this.getImage(widget, string);
    }

    protected Image getImage(Object object, String string) {
        Widget widget = this.getWidget(object);
        return this.getImage(widget, string);
    }

    protected Image getImage(Widget widget, String string) {
        return (Image)this.getResource(widget, string, Image.class);
    }

    protected Color getColor(Object object, String string, int n) {
        Widget widget = this.getWidget(object, n);
        return this.getColor(widget, string);
    }

    protected Color getColor(Object object, String string) {
        Widget widget = this.getWidget(object);
        return this.getColor(widget, string);
    }

    protected Color getColor(Widget widget, String string) {
        return (Color)this.getResource(widget, string, Color.class);
    }

    protected Object getResource(Widget widget, String string, Object object) {
        CSSValue cSSValue = this.getCSSValue(widget, string);
        if (cSSValue != null) {
            try {
                return this.engine.convert(cSSValue, object, (Object)widget.getDisplay());
            }
            catch (Exception exception) {
                this.engine.handleExceptions(exception);
            }
        }
        return null;
    }

    protected CSSValue getCSSValue(Widget widget, String string) {
        if (widget == null) {
            return null;
        }
        Element element = this.engine.getElement((Object)widget);
        if (element == null) {
            return null;
        }
        CSSStyleDeclaration cSSStyleDeclaration = this.engine.getViewCSS().getComputedStyle(element, null);
        if (cSSStyleDeclaration == null) {
            return null;
        }
        return cSSStyleDeclaration.getPropertyCSSValue(string);
    }

    protected Widget getWidget(Object object) {
        return this.viewer.testFindItem(object);
    }

    protected Widget getWidget(Object object, int n) {
        return null;
    }
}

