/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.ui.editor;

import java.util.HashSet;
import org.eclipse.e4.xwt.XWT;
import org.eclipse.e4.xwt.metadata.IEvent;
import org.eclipse.e4.xwt.metadata.IMetaclass;
import org.eclipse.e4.xwt.ui.editor.XWTEditor;
import org.eclipse.e4.xwt.ui.editor.jdt.ASTHelper;
import org.eclipse.e4.xwt.vex.AbstractCodeSynchronizer;
import org.eclipse.e4.xwt.vex.VEXEditor;
import org.eclipse.e4.xwt.vex.dom.DomHelper;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.javaeditor.CompilationUnitEditor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.IEditorPart;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.ui.internal.StructuredTextViewer;
import org.eclipse.wst.sse.ui.internal.contentassist.ContentAssistUtils;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XWTCodeSynchronizer
extends AbstractCodeSynchronizer {
    private static final String INIT_METHOD_NAME = "initializeComponent";
    private IType type;

    public XWTCodeSynchronizer(XWTEditor xWTEditor, IType iType) {
        super((VEXEditor)xWTEditor);
        this.type = iType;
        if (iType == null) {
            throw new NullPointerException("Java Source Type is Null!");
        }
    }

    public void remove(final IDOMNode iDOMNode) {
        Display display;
        final String string = (String)this.getNode2name().remove(iDOMNode);
        if (string != null && (display = Display.getDefault()) != null) {
            display.syncExec(new Runnable(){

                public void run() {
                    String string2 = XWTCodeSynchronizer.this.getFullTypeName(iDOMNode);
                    if (string2 == null) {
                        return;
                    }
                    XWTCodeSynchronizer.this.removeFields(string2, string);
                    XWTCodeSynchronizer.this.buildInitialization();
                    ASTHelper.removeUnusedImports(XWTCodeSynchronizer.this.type);
                }
            });
        }
    }

    protected String getFullTypeName(IDOMNode iDOMNode) {
        String string = null;
        iDOMNode.getNodeName();
        return string;
    }

    public IType getType() {
        return this.type;
    }

    public void setType(IType iType) {
        this.type = iType;
    }

    public void generateFields(String string, String string2) {
        ASTHelper.generateNamedFields(this.type, string, string2);
    }

    public void removeFields(String string, String string2) {
        try {
            IField[] iFieldArray;
            IField[] iFieldArray2 = iFieldArray = this.type.getFields();
            int n = iFieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                IField iField = iFieldArray2[n2];
                if (string2.equals(iField.getElementName())) {
                    iField.delete(false, null);
                }
                ++n2;
            }
        }
        catch (JavaModelException javaModelException) {}
    }

    public void buildInitialization() {
        try {
            HashSet<String> hashSet = new HashSet<String>(this.getNode2name().values());
            this.type.getFields();
            ASTHelper.generateInitialization(this.type, INIT_METHOD_NAME, hashSet);
        }
        catch (Exception exception) {}
    }

    public boolean generateHandles() {
        StructuredTextViewer structuredTextViewer = this.getEditor().getTextEditor().getTextViewer();
        int n = structuredTextViewer.getTextWidget().getCaretOffset();
        IndexedRegion indexedRegion = ContentAssistUtils.getNodeAt((ITextViewer)structuredTextViewer, (int)n);
        Node node = (Node)indexedRegion;
        while (node != null && node.getNodeType() == 3 && node.getParentNode() != null) {
            node = node.getParentNode();
        }
        IDOMNode iDOMNode = (IDOMNode)node;
        this.updateCodeManager();
        String string = iDOMNode.getNodeName();
        if (string.indexOf(":") > 0) {
            string = string.substring(string.indexOf(":") + 1);
        }
        IMetaclass iMetaclass = null;
        try {
            iMetaclass = XWT.getMetaclass((String)string, (String)DomHelper.lookupNamespaceURI((Node)iDOMNode));
        }
        catch (Exception exception) {
            return false;
        }
        if (iMetaclass != null) {
            NamedNodeMap namedNodeMap = iDOMNode.getAttributes();
            int n2 = namedNodeMap.getLength() - 1;
            while (n2 >= 0) {
                IDOMAttr iDOMAttr = (IDOMAttr)namedNodeMap.item(n2);
                int n3 = iDOMAttr.getEndOffset();
                int n4 = iDOMAttr.getStartOffset();
                if (n >= n4 && n <= n3) {
                    int n5;
                    String string2 = iDOMAttr.getName();
                    IEvent iEvent = iMetaclass.findEvent(string2);
                    if (iEvent == null && (n5 = string2.indexOf(46)) != -1) {
                        String string3 = string2.substring(0, n5);
                        String string4 = string2.substring(n5 + 1);
                        iMetaclass = XWT.getMetaclass((String)string3, (String)DomHelper.lookupNamespaceURI((Node)iDOMAttr));
                        if (iMetaclass != null) {
                            iEvent = iMetaclass.findEvent(string4);
                        }
                    }
                    if (iEvent != null) {
                        try {
                            ASTHelper.generateEventHandler(this.type, Event.class.getName(), iDOMAttr.getValue());
                            return true;
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                            break;
                        }
                    }
                }
                --n2;
            }
        }
        return false;
    }

    public boolean openDefinition() {
        StructuredTextViewer structuredTextViewer = this.getEditor().getTextEditor().getTextViewer();
        int n = structuredTextViewer.getTextWidget().getCaretOffset();
        IndexedRegion indexedRegion = ContentAssistUtils.getNodeAt((ITextViewer)structuredTextViewer, (int)n);
        Node node = (Node)indexedRegion;
        while (node != null && node.getNodeType() == 3 && node.getParentNode() != null) {
            node = node.getParentNode();
        }
        IDOMNode iDOMNode = (IDOMNode)node;
        iDOMNode.getNodeName();
        return false;
    }

    public boolean handleInputChanged(IDocument iDocument) {
        String string = iDocument.get();
        if (this.checkContent(string)) {
            return false;
        }
        StructuredTextViewer structuredTextViewer = this.getEditor().getTextEditor().getTextViewer();
        int n = structuredTextViewer.getTextWidget().getCaretOffset();
        IndexedRegion indexedRegion = ContentAssistUtils.getNodeAt((ITextViewer)structuredTextViewer, (int)n);
        Node node = (Node)indexedRegion;
        while (node != null && node.getNodeType() == 3 && node.getParentNode() != null) {
            node = node.getParentNode();
        }
        IDOMNode iDOMNode = (IDOMNode)node;
        iDOMNode.getNodeName();
        return true;
    }

    private void jumpToJavaMethod(IMethod[] iMethodArray, String string) {
        IMethod iMethod = this.findMethod(iMethodArray, string);
        CompilationUnitEditor compilationUnitEditor = ((XWTEditor)this.getEditor()).getJavaEditor();
        if (iMethod != null) {
            compilationUnitEditor.setSelection((IJavaElement)iMethod);
        }
        this.getEditor().setActiveEditor((IEditorPart)compilationUnitEditor);
    }

    private IMethod findMethod(IMethod[] iMethodArray, String string) {
        int n = 0;
        while (n < iMethodArray.length) {
            IMethod iMethod = iMethodArray[n];
            if (iMethod.getElementName().equals(string)) {
                return iMethod;
            }
            ++n;
        }
        return null;
    }

    private void modifyAllRelativeHandlerName(StructuredTextViewer structuredTextViewer, int n, String string, String string2) {
        IndexedRegion indexedRegion = ContentAssistUtils.getNodeAt((ITextViewer)structuredTextViewer, (int)n);
        Node node = (Node)indexedRegion;
        this.modifyHandlerName(string, node, string2);
    }

    private void modifyHandlerName(String string, Node node, String string2) {
        while (node != null && node.getNodeType() == 3 && node.getParentNode() != null) {
            node = node.getParentNode();
        }
        node.getNodeName();
        node.getNodeType();
        NodeList nodeList = node.getChildNodes();
        int n = nodeList.getLength();
        int n2 = 0;
        while (n2 < n) {
            Node node2 = nodeList.item(n2);
            if (node2.getNodeType() == 1) {
                this.modifyHandlerName(string, node2, string2);
            }
            ++n2;
        }
    }
}

