/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.ui.editor;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.e4.xwt.ILoadingContext;
import org.eclipse.e4.xwt.XWT;
import org.eclipse.e4.xwt.ui.ExceptionHandle;
import org.eclipse.e4.xwt.ui.XWTUIPlugin;
import org.eclipse.e4.xwt.ui.editor.XWTCodeSynchronizer;
import org.eclipse.e4.xwt.ui.editor.XWTFileChecker;
import org.eclipse.e4.xwt.ui.editor.XWTUIContext;
import org.eclipse.e4.xwt.ui.editor.render.XWTRender;
import org.eclipse.e4.xwt.ui.editor.treeviewer.XWTTableTreeViewer;
import org.eclipse.e4.xwt.ui.utils.DisplayUtil;
import org.eclipse.e4.xwt.ui.utils.ImageManager;
import org.eclipse.e4.xwt.ui.utils.ProjectContext;
import org.eclipse.e4.xwt.ui.views.XWTView;
import org.eclipse.e4.xwt.vex.VEXCodeSynchronizer;
import org.eclipse.e4.xwt.vex.VEXContext;
import org.eclipse.e4.xwt.vex.VEXEditor;
import org.eclipse.e4.xwt.vex.VEXFileChecker;
import org.eclipse.e4.xwt.vex.VEXFileFormator;
import org.eclipse.e4.xwt.vex.VEXRenderer;
import org.eclipse.e4.xwt.vex.VEXTextEditorHelper;
import org.eclipse.e4.xwt.vex.toolpalette.Entry;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.javaeditor.CompilationUnitEditor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.templates.ContextTypeRegistry;
import org.eclipse.jface.text.templates.DocumentTemplateContext;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateBuffer;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.TemplateVariable;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.progress.ProgressManager;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.wst.sse.ui.StructuredTextEditor;
import org.eclipse.wst.sse.ui.internal.StructuredTextViewer;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.ui.internal.XMLUIPlugin;
import org.eclipse.wst.xml.ui.internal.tabletree.IDesignViewer;
import org.w3c.dom.Node;

public class XWTEditor
extends VEXEditor {
    private CompilationUnitEditor javaEditor;
    private IFile javaFile;
    private String className;
    private ToolItem previewTool;
    private ToolItem generateTool;
    private long modificationStamp;
    private IElementChangedListener elementChangedListener = new IElementChangedListener(){

        public void elementChanged(ElementChangedEvent elementChangedEvent) {
            if (XWTEditor.this.getFileChecker() != null) {
                long l = XWTEditor.this.javaFile.getModificationStamp();
                if (XWTEditor.this.modificationStamp == l) {
                    XWTEditor.this.getFileChecker().doCheck(XWTEditor.this.render.getHostClassName());
                } else {
                    XWTEditor.this.modificationStamp = l;
                }
            }
        }
    };
    private DropTargetAdapter dropTargetAdapter = new DropTargetAdapter(){
        static final int CARET_WIDTH = 2;
        protected int dropCaretOffset = -1;
        private Map<String, String> name2content = new HashMap<String, String>();

        public void drop(DropTargetEvent dropTargetEvent) {
            IFile iFile = (IFile)XWTEditor.this.getTextEditor().getEditorInput().getAdapter(IFile.class);
            VEXFileFormator vEXFileFormator = new VEXFileFormator();
            IDocument iDocument = XWTEditor.this.getTextEditor().getTextViewer().getDocument();
            try {
                vEXFileFormator.format(iDocument, iFile.getContentDescription().getContentType().getId());
            }
            catch (CoreException coreException) {
                coreException.printStackTrace();
            }
        }

        public void dragLeave(DropTargetEvent dropTargetEvent) {
            StyledText styledText = XWTEditor.this.getTextWidget();
            if (this.dropCaretOffset != -1) {
                this.refreshCaret(styledText, this.dropCaretOffset);
            }
        }

        public void dragOver(DropTargetEvent dropTargetEvent) {
            IStructuredSelection iStructuredSelection = (IStructuredSelection)LocalSelectionTransfer.getTransfer().getSelection();
            if (iStructuredSelection == null) {
                return;
            }
            Object object = iStructuredSelection.getFirstElement();
            if (object instanceof Entry) {
                int n;
                StructuredTextEditor structuredTextEditor;
                StructuredTextViewer structuredTextViewer;
                IDOMNode iDOMNode;
                Entry entry = (Entry)object;
                VEXContext vEXContext = XWTEditor.this.getContext();
                int n2 = vEXContext.findDropPosition((Node)(iDOMNode = VEXTextEditorHelper.getNode((ITextViewer)(structuredTextViewer = (structuredTextEditor = XWTEditor.this.getTextEditor()).getTextViewer()), (int)(n = VEXTextEditorHelper.getOffsetAtPoint((ITextViewer)structuredTextViewer, (Point)new Point(dropTargetEvent.x, dropTargetEvent.y))))), entry, n);
                if (n2 < 0) {
                    dropTargetEvent.detail = 0;
                } else {
                    StyledText styledText = XWTEditor.this.getTextWidget();
                    this.dropCaretOffset = n2;
                    this.refreshCaret(styledText, this.dropCaretOffset);
                }
            }
            super.dragOver(dropTargetEvent);
        }

        public void dropAccept(DropTargetEvent dropTargetEvent) {
            IStructuredSelection iStructuredSelection = (IStructuredSelection)LocalSelectionTransfer.getTransfer().getSelection();
            if (iStructuredSelection == null) {
                return;
            }
            Object object = iStructuredSelection.getFirstElement();
            if (object instanceof Entry) {
                int n;
                TemplateContextType templateContextType;
                DocumentTemplateContext documentTemplateContext;
                Entry entry = (Entry)object;
                this.updateLayoutEntry(entry, dropTargetEvent.x, dropTargetEvent.y);
                this.updateLayoutDataEntry(entry, dropTargetEvent.x, dropTargetEvent.y);
                IDocument iDocument = XWTEditor.this.getTextEditor().getTextViewer().getDocument();
                Template template = new Template(entry.getName(), "", entry.getContext().getName(), entry.getContent(), true);
                ContextTypeRegistry contextTypeRegistry = XMLUIPlugin.getDefault().getTemplateContextRegistry();
                if (contextTypeRegistry != null && (documentTemplateContext = new DocumentTemplateContext(templateContextType = contextTypeRegistry.getContextType(template.getContextTypeId()), iDocument, new Position(this.dropCaretOffset, n = 0))).canEvaluate(template)) {
                    try {
                        TemplateBuffer templateBuffer = documentTemplateContext.evaluate(template);
                        String string = templateBuffer.getString();
                        iDocument.replace(this.dropCaretOffset, n, string);
                        StyledText styledText = XWTEditor.this.getTextWidget();
                        int n2 = this.getCursorOffset(templateBuffer) + this.dropCaretOffset;
                        styledText.setCaretOffset(n2);
                        styledText.setFocus();
                    }
                    catch (Exception exception) {
                        throw new RuntimeException(exception);
                    }
                }
            } else {
                super.dropAccept(dropTargetEvent);
            }
        }

        private int getCursorOffset(TemplateBuffer templateBuffer) {
            TemplateVariable[] templateVariableArray = templateBuffer.getVariables();
            int n = 0;
            while (n != templateVariableArray.length) {
                TemplateVariable templateVariable = templateVariableArray[n];
                if (templateVariable.getType().equals("cursor")) {
                    return templateVariable.getOffsets()[0];
                }
                ++n;
            }
            return templateBuffer.getString().length();
        }

        void refreshCaret(StyledText styledText, int n) {
            if (n != -1) {
                Point point = styledText.getLocationAtOffset(n);
                int n2 = styledText.getLineHeight(n);
                styledText.redraw(point.x, point.y, 2, n2, false);
            }
        }

        protected void updateLayoutEntry(Entry entry, int n, int n2) {
            StructuredTextEditor structuredTextEditor = XWTEditor.this.getTextEditor();
            StructuredTextViewer structuredTextViewer = structuredTextEditor.getTextViewer();
            int n3 = VEXTextEditorHelper.getOffsetAtPoint((ITextViewer)structuredTextViewer, (Point)new Point(n, n2));
            Object object = VEXTextEditorHelper.getNode((ITextViewer)structuredTextViewer, (int)n3);
            while (object.getNodeType() == 3) {
                object = object.getParentNode();
            }
            String string = object.getNodeName();
            String string2 = entry.getName();
            String string3 = null;
            if (string != null && string2.toLowerCase().endsWith("layout")) {
                string3 = string.indexOf(":") != -1 ? string.substring(string.lastIndexOf(":") + 1) : string;
                String string4 = this.name2content.get(string2);
                if (string4 == null) {
                    string4 = entry.getContent();
                    this.name2content.put(string2, string4);
                }
                String string5 = string4.replace("Composite", string3);
                entry.setContent(string5);
            }
        }

        protected void updateLayoutDataEntry(Entry entry, int n, int n2) {
            StructuredTextEditor structuredTextEditor = XWTEditor.this.getTextEditor();
            StructuredTextViewer structuredTextViewer = structuredTextEditor.getTextViewer();
            int n3 = VEXTextEditorHelper.getOffsetAtPoint((ITextViewer)structuredTextViewer, (Point)new Point(n, n2));
            Object object = VEXTextEditorHelper.getNode((ITextViewer)structuredTextViewer, (int)n3);
            while (object.getNodeType() == 3) {
                object = object.getParentNode();
            }
            String string = object.getNodeName();
            String string2 = entry.getName();
            String string3 = null;
            if (string != null && string2.toLowerCase().endsWith("data")) {
                string3 = string.indexOf(":") != -1 ? string.substring(string.lastIndexOf(":") + 1) : string;
                String string4 = this.name2content.get(string2);
                if (string4 == null) {
                    string4 = entry.getContent();
                    this.name2content.put(string2, string4);
                }
                String string5 = string4.replace("Control", string3);
                entry.setContent(string5);
            }
        }
    };

    public XWTEditor() {
        super((VEXContext)new XWTUIContext());
    }

    public CompilationUnitEditor getJavaEditor() {
        return this.javaEditor;
    }

    public void init(IEditorSite iEditorSite, IEditorInput iEditorInput) throws PartInitException {
        super.init(iEditorSite, iEditorInput);
        XWTUIPlugin.getDefault().openXWTPerspective();
    }

    protected IDesignViewer createDesignPage() {
        XWTTableTreeViewer xWTTableTreeViewer = new XWTTableTreeViewer(this.getContainer());
        XMLUIPlugin.getInstance().getWorkbench().getHelpSystem().setHelp(xWTTableTreeViewer.getControl(), "org.eclipse.wst.xml.ui.xmlm3000");
        return xWTTableTreeViewer;
    }

    protected VEXRenderer createRender(Canvas canvas) {
        return new XWTRender(canvas, this.changeListener);
    }

    protected void createToolBar(CTabFolder cTabFolder) {
        cTabFolder.setTabPosition(128);
        cTabFolder.setSimple(false);
        ToolBar toolBar = new ToolBar((Composite)cTabFolder, 8519744);
        this.previewTool = new ToolItem(toolBar, 8);
        this.previewTool.setImage(ImageManager.get((String)ImageManager.IMG_PREVIEW));
        this.previewTool.setToolTipText("Preview");
        this.previewTool.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                XWTEditor.this.handlePreview();
            }

            public void widgetSelected(SelectionEvent selectionEvent) {
                XWTEditor.this.handlePreview();
            }
        });
        this.generateTool = new ToolItem(toolBar, 8);
        this.generateTool.setImage(JavaPluginImages.get((String)"org.eclipse.jdt.ui.class_obj.gif"));
        this.generateTool.setToolTipText("Generate Java codes");
        this.generateTool.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                XWTEditor.this.generateCLRCodeAction();
            }

            public void widgetSelected(SelectionEvent selectionEvent) {
                XWTEditor.this.generateCLRCodeAction();
            }
        });
        this.generateTool.setEnabled(false);
        cTabFolder.setTopRight((Control)toolBar);
        cTabFolder.setTabHeight(Math.max(toolBar.computeSize((int)-1, (int)-1).y, cTabFolder.getTabHeight()));
    }

    void handlePreview() {
        IFile iFile = (IFile)this.getEditorInput().getAdapter(IFile.class);
        IJavaProject iJavaProject = JavaCore.create((IProject)iFile.getProject());
        if (!iJavaProject.exists()) {
            return;
        }
        try {
            XWT.setLoadingContext((ILoadingContext)ProjectContext.getContext((IJavaProject)iJavaProject));
            DisplayUtil.open((IFile)iFile);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected void setJavaEditor(String string) {
        IJavaProject iJavaProject = this.getJavaProject();
        this.removeElementChangedListener(iJavaProject);
        try {
            if (string == null) {
                return;
            }
            IType iType = iJavaProject.findType(string);
            if (iType == null || !iType.exists()) {
                return;
            }
            this.javaFile = (IFile)iType.getResource();
            FileEditorInput fileEditorInput = new FileEditorInput(this.javaFile);
            if (this.javaEditor == null) {
                this.javaEditor = new CompilationUnitEditor();
                int n = this.addPage((IEditorPart)this.javaEditor, (IEditorInput)fileEditorInput);
                this.setPageText(n, "Java");
                this.setPageImage(n, JavaPluginImages.get((String)"org.eclipse.jdt.ui.class_obj.gif"));
            } else {
                this.javaEditor.setInput((IEditorInput)fileEditorInput);
            }
            this.className = string;
            if (this.generateTool != null) {
                this.generateTool.setEnabled(true);
            }
            this.addElementChangedListener(iJavaProject);
            XWTCodeSynchronizer xWTCodeSynchronizer = (XWTCodeSynchronizer)this.getCodeSynchronizer();
            xWTCodeSynchronizer.setType(iType);
        }
        catch (PartInitException partInitException) {
            partInitException.printStackTrace();
        }
        catch (JavaModelException javaModelException) {
            javaModelException.printStackTrace();
        }
    }

    protected IJavaProject getJavaProject() {
        IFile iFile = (IFile)this.getEditorInput().getAdapter(IFile.class);
        IJavaProject iJavaProject = JavaCore.create((IProject)iFile.getProject());
        if (!iJavaProject.exists()) {
            return null;
        }
        return iJavaProject;
    }

    public void doSave(IProgressMonitor iProgressMonitor) {
        super.doSave(iProgressMonitor);
        if (this.javaEditor != null) {
            this.javaEditor.doSave(iProgressMonitor);
        }
    }

    protected boolean handleInputChanged(IDocument iDocument) {
        String string = iDocument.get();
        if (iDocument == null) {
            return false;
        }
        boolean bl = super.handleInputChanged(iDocument);
        if (bl) {
            String string2 = this.render.getHostClassName();
            if (this.className == null || !this.className.equals(string2)) {
                this.setJavaEditor(string2);
            }
        }
        this.refreshXWTView(string);
        return bl;
    }

    private void refreshXWTView(String string) {
        IFile iFile = (IFile)this.getEditorInput().getAdapter(IFile.class);
        if (iFile != null) {
            XWTUIPlugin.checkStartup();
            try {
                XWTView xWTView = (XWTView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("org.eclipse.e4.xwt.ui.views.XWTView");
                if (xWTView != null) {
                    xWTView.setContent(string, iFile);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                ExceptionHandle.handle((Exception)exception, (String)"");
            }
        }
    }

    protected VEXFileChecker createFileChecker() {
        return new XWTFileChecker(this.getTextEditor());
    }

    protected VEXCodeSynchronizer createCodeSynchronizer() {
        IJavaProject iJavaProject;
        block4: {
            try {
                iJavaProject = this.getJavaProject();
                if (iJavaProject != null && this.className != null) break block4;
                return null;
            }
            catch (JavaModelException javaModelException) {}
        }
        IType iType = iJavaProject.findType(this.className);
        if (iType != null) {
            return new XWTCodeSynchronizer(this, iType);
        }
        return null;
    }

    public void addElementChangedListener(IJavaProject iJavaProject) {
        int n = 5;
        JavaModelManager.getDeltaState().addElementChangedListener(this.elementChangedListener, n);
    }

    public void removeElementChangedListener(IJavaProject iJavaProject) {
        JavaModelManager.getDeltaState().removeElementChangedListener(this.elementChangedListener);
    }

    public void initializeDND(VEXEditor vEXEditor) {
        this.update(vEXEditor);
    }

    private void update(VEXEditor vEXEditor) {
        DropTarget dropTarget;
        StyledText styledText = vEXEditor.getTextWidget();
        if (styledText != null && (dropTarget = (DropTarget)styledText.getData("DropTarget")) != null) {
            dropTarget.removeDropListener((DropTargetListener)this.dropTargetAdapter);
        }
        vEXEditor.getTextWidget().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                StyledText styledText = (StyledText)disposeEvent.widget;
                DropTarget dropTarget = (DropTarget)styledText.getData("DropTarget");
                if (dropTarget != null) {
                    dropTarget.removeDropListener((DropTargetListener)XWTEditor.this.dropTargetAdapter);
                }
            }
        });
        dropTarget = (DropTarget)styledText.getData("DropTarget");
        if (dropTarget == null) {
            dropTarget = new DropTarget((Control)styledText, 3);
            dropTarget.setTransfer(new Transfer[]{LocalSelectionTransfer.getTransfer()});
        }
        dropTarget.addDropListener((DropTargetListener)this.dropTargetAdapter);
        DragSource dragSource = (DragSource)styledText.getData("DragSource");
        if (dragSource == null) {
            dragSource = new DragSource((Control)styledText, 3);
            Transfer[] transferArray = new Transfer[]{TextTransfer.getInstance()};
            dragSource.setTransfer(transferArray);
        }
        dragSource.addDragListener(this.dragSourceAdapter);
    }

    private IProgressMonitor getProgressMonitor() {
        ProgressManager progressManager = (ProgressManager)this.getSite().getWorkbenchWindow().getWorkbench().getProgressService();
        IProgressMonitor iProgressMonitor = progressManager.getDefaultMonitor();
        return iProgressMonitor;
    }

    public void setFocus() {
        super.setFocus();
        this.refreshXWTView(super.getTextEditor().getTextViewer().getDocument().get());
    }
}

