/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.ui.editor;

import org.eclipse.e4.xwt.ui.editor.XWTEditor;
import org.eclipse.e4.xwt.ui.utils.ImageManager;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.ide.IDEActionFactory;
import org.eclipse.ui.part.MultiPageEditorActionBarContributor;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.ITextEditorActionConstants;
import org.eclipse.wst.sse.ui.StructuredTextEditor;

public class XWTEditorContributor
extends MultiPageEditorActionBarContributor {
    private IEditorPart activeEditorPart;
    private Action previewAction;
    private Action javaAction;

    public XWTEditorContributor() {
        this.createActions();
    }

    protected IAction getAction(ITextEditor iTextEditor, String string) {
        return iTextEditor == null ? null : iTextEditor.getAction(string);
    }

    public void setActivePage(IEditorPart iEditorPart) {
        if (this.activeEditorPart == iEditorPart) {
            return;
        }
        this.activeEditorPart = iEditorPart;
        IActionBars iActionBars = this.getActionBars();
        if (iActionBars != null) {
            ITextEditor iTextEditor = iEditorPart instanceof ITextEditor ? (ITextEditor)iEditorPart : null;
            iActionBars.setGlobalActionHandler(ActionFactory.DELETE.getId(), this.getAction(iTextEditor, ITextEditorActionConstants.DELETE));
            iActionBars.setGlobalActionHandler(ActionFactory.UNDO.getId(), this.getAction(iTextEditor, ITextEditorActionConstants.UNDO));
            iActionBars.setGlobalActionHandler(ActionFactory.REDO.getId(), this.getAction(iTextEditor, ITextEditorActionConstants.REDO));
            iActionBars.setGlobalActionHandler(ActionFactory.CUT.getId(), this.getAction(iTextEditor, ITextEditorActionConstants.CUT));
            iActionBars.setGlobalActionHandler(ActionFactory.COPY.getId(), this.getAction(iTextEditor, ITextEditorActionConstants.COPY));
            iActionBars.setGlobalActionHandler(ActionFactory.PASTE.getId(), this.getAction(iTextEditor, ITextEditorActionConstants.PASTE));
            iActionBars.setGlobalActionHandler(ActionFactory.SELECT_ALL.getId(), this.getAction(iTextEditor, ITextEditorActionConstants.SELECT_ALL));
            iActionBars.setGlobalActionHandler(ActionFactory.FIND.getId(), this.getAction(iTextEditor, ITextEditorActionConstants.FIND));
            iActionBars.setGlobalActionHandler(IDEActionFactory.BOOKMARK.getId(), this.getAction(iTextEditor, IDEActionFactory.BOOKMARK.getId()));
            iActionBars.updateActionBars();
        }
        this.previewAction.setEnabled(iEditorPart != null);
        this.javaAction.setEnabled(iEditorPart != null);
    }

    private void createActions() {
        this.previewAction = new Action(){

            public void run() {
                StructuredTextEditor structuredTextEditor;
                IEditorPart iEditorPart;
                if (XWTEditorContributor.this.activeEditorPart instanceof StructuredTextEditor && (iEditorPart = (structuredTextEditor = (StructuredTextEditor)XWTEditorContributor.this.activeEditorPart).getEditorPart()) instanceof XWTEditor) {
                    XWTEditor xWTEditor = (XWTEditor)iEditorPart;
                    xWTEditor.handlePreview();
                }
            }
        };
        this.previewAction.setText("Preview");
        this.previewAction.setToolTipText("Preview");
        this.previewAction.setImageDescriptor(ImageManager.OBJ_PREVIEW);
        this.javaAction = new Action(){

            public void run() {
                StructuredTextEditor structuredTextEditor;
                IEditorPart iEditorPart;
                if (XWTEditorContributor.this.activeEditorPart instanceof StructuredTextEditor && (iEditorPart = (structuredTextEditor = (StructuredTextEditor)XWTEditorContributor.this.activeEditorPart).getEditorPart()) instanceof XWTEditor) {
                    XWTEditor xWTEditor = (XWTEditor)iEditorPart;
                    xWTEditor.generateCLRCodeAction();
                }
            }
        };
        this.javaAction.setText("Java");
        this.javaAction.setToolTipText("Preview");
        this.javaAction.setImageDescriptor(JavaPluginImages.DESC_OBJS_CLASS);
    }

    public void contributeToMenu(IMenuManager iMenuManager) {
        MenuManager menuManager = new MenuManager("XWT");
        iMenuManager.prependToGroup("additions", (IContributionItem)menuManager);
        menuManager.add((IAction)this.previewAction);
        menuManager.add((IAction)this.javaAction);
    }

    public void contributeToToolBar(IToolBarManager iToolBarManager) {
        iToolBarManager.add((IContributionItem)new Separator());
    }
}

