/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.ui.editor;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.e4.xwt.ui.utils.ProjectContext;
import org.eclipse.e4.xwt.vex.VEXFileChecker;
import org.eclipse.e4.xwt.vex.problems.IProblemChecker;
import org.eclipse.e4.xwt.vex.problems.Problem;
import org.eclipse.e4.xwt.vex.problems.ProblemCheckerRegistry;
import org.eclipse.wst.sse.ui.StructuredTextEditor;

public class XWTFileChecker
implements VEXFileChecker {
    public static final String EXTENSION_ID = "org.eclipse.e4.xwt.tools.ui.editor.problemchecker";
    private final String MARKER_ID = "org.eclipse.e4.xwt.tools.ui.editor.XAMLEditorMaker";
    private StructuredTextEditor fTextEditor = null;

    public XWTFileChecker(StructuredTextEditor structuredTextEditor) {
        this.fTextEditor = structuredTextEditor;
    }

    public void doCheck(String string) {
        IProblemChecker iProblemChecker2;
        ProjectContext.stop();
        this.deleteMarkers();
        List list = ProblemCheckerRegistry.INSTANCE.getCheckers(EXTENSION_ID);
        if (list.isEmpty()) {
            return;
        }
        ArrayList arrayList = new ArrayList();
        for (IProblemChecker iProblemChecker2 : list) {
            Object object;
            if (!iProblemChecker2.canChecked(this.fTextEditor, string) || (object = iProblemChecker2.checkProblems(this.fTextEditor, string)) == null) continue;
            arrayList.addAll(object);
        }
        if (arrayList.isEmpty()) {
            return;
        }
        iProblemChecker2 = (IFile)this.fTextEditor.getEditorInput().getAdapter(IFile.class);
        for (Problem problem : arrayList) {
            this.makeMaker((IFile)iProblemChecker2, problem);
        }
        ProjectContext.start();
    }

    private void makeMaker(IFile iFile, Problem problem) {
        try {
            IMarker iMarker = iFile.createMarker("org.eclipse.e4.xwt.tools.ui.editor.XAMLEditorMaker");
            iMarker.setAttribute("transient", true);
            iMarker.setAttribute("message", (Object)problem.getMessage());
            iMarker.setAttribute("charStart", problem.start);
            iMarker.setAttribute("charEnd", problem.end);
            int n = problem.getType();
            switch (n) {
                case 3: {
                    iMarker.setAttribute("severity", 2);
                    break;
                }
                case 2: {
                    iMarker.setAttribute("severity", 0);
                    break;
                }
                case 1: {
                    iMarker.setAttribute("severity", 1);
                }
            }
            iMarker.setAttribute("lineNumber", problem.line);
        }
        catch (CoreException coreException) {}
    }

    public void deleteMarkers() {
        IFile iFile = (IFile)this.fTextEditor.getEditorInput().getAdapter(IFile.class);
        try {
            iFile.deleteMarkers(null, true, 2);
        }
        catch (CoreException coreException) {}
    }
}

