/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.ui.editor.checkers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.e4.xwt.vex.problems.IProblemChecker;
import org.eclipse.e4.xwt.vex.problems.Problem;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.ui.StructuredTextEditor;
import org.eclipse.wst.sse.ui.internal.StructuredTextViewer;
import org.eclipse.wst.sse.ui.internal.contentassist.ContentAssistUtils;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractProblemChecker
implements IProblemChecker {
    protected IJavaProject getJavaProject(StructuredTextEditor structuredTextEditor) {
        return JavaCore.create((IProject)this.getFile(structuredTextEditor).getProject());
    }

    protected IFile getFile(StructuredTextEditor structuredTextEditor) {
        return (IFile)structuredTextEditor.getEditorInput().getAdapter(IFile.class);
    }

    protected Node getRoot(StructuredTextEditor structuredTextEditor) {
        StructuredTextViewer structuredTextViewer = structuredTextEditor.getTextViewer();
        if (structuredTextViewer == null) {
            return null;
        }
        IndexedRegion indexedRegion = ContentAssistUtils.getNodeAt((ITextViewer)structuredTextViewer, (int)0);
        if (indexedRegion instanceof Node) {
            return (Node)indexedRegion;
        }
        return null;
    }

    protected Node getNode(StructuredTextEditor structuredTextEditor) {
        StructuredTextViewer structuredTextViewer = structuredTextEditor.getTextViewer();
        if (structuredTextViewer == null) {
            return null;
        }
        StyledText styledText = structuredTextViewer.getTextWidget();
        if (styledText == null || styledText.isDisposed()) {
            return null;
        }
        int n = 0;
        try {
            n = styledText.getCaretOffset();
        }
        catch (Exception exception) {
            return null;
        }
        if (n == 0) {
            return null;
        }
        IndexedRegion indexedRegion = ContentAssistUtils.getNodeAt((ITextViewer)structuredTextViewer, (int)n);
        if (indexedRegion instanceof Node) {
            return (Node)indexedRegion;
        }
        return null;
    }

    protected Problem createProblem(StructuredTextEditor structuredTextEditor, Node node, String string, int n) {
        int n2 = 0;
        if (node instanceof IDOMNode) {
            n2 = ((IDOMNode)node).getStartOffset();
        }
        int n3 = 0;
        if (node instanceof IDOMNode) {
            n3 = ((IDOMNode)node).getEndOffset();
        }
        int n4 = 0;
        try {
            StructuredTextViewer structuredTextViewer = structuredTextEditor.getTextViewer();
            if (structuredTextViewer != null) {
                n4 = structuredTextViewer.getDocument().getLineOfOffset(n2) + 1;
            }
        }
        catch (BadLocationException badLocationException) {}
        return this.createProblem(string, n, node, n2, n3, n4);
    }

    protected Problem createProblem(String string, int n, Object object, int n2, int n3, int n4) {
        Problem problem = new Problem(string, n);
        problem.setSource(object);
        problem.start = n2;
        problem.end = n3;
        problem.line = n4;
        return problem;
    }

    protected boolean isValid(Node node) {
        if (node == null) {
            return false;
        }
        String string = node.getNodeName();
        return string != null && !string.equals("") && !string.equals("#text");
    }

    protected String getTagName(Node node) {
        if (!this.isValid(node)) {
            return null;
        }
        return node.getNodeName();
    }

    public List<Problem> checkProblems(StructuredTextEditor structuredTextEditor, String string) {
        ArrayList<Problem> arrayList = new ArrayList<Problem>();
        Node node = this.getRoot(structuredTextEditor);
        this.checkProblems(structuredTextEditor, string, node, arrayList, true);
        return arrayList;
    }

    protected abstract void checkProblems(StructuredTextEditor var1, String var2, Node var3, List<Problem> var4, boolean var5);

    public boolean canChecked(StructuredTextEditor structuredTextEditor, String string) {
        return this.getRoot(structuredTextEditor) != null;
    }
}

