/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.ui.editor.checkers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.e4.xwt.ui.editor.checkers.AbstractProblemChecker;
import org.eclipse.e4.xwt.vex.dom.DomHelper;
import org.eclipse.e4.xwt.vex.problems.Problem;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.wst.sse.ui.StructuredTextEditor;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElementEventsChecker
extends AbstractProblemChecker {
    @Override
    protected void checkProblems(StructuredTextEditor structuredTextEditor, String string, Node node, List<Problem> list, boolean bl) {
        Object object;
        int n;
        Object object2;
        if (!this.isValid(node)) {
            return;
        }
        if (bl && (object2 = node.getChildNodes()) != null) {
            int n2 = object2.getLength();
            n = 0;
            while (n < n2) {
                object = object2.item(n);
                this.checkProblems(structuredTextEditor, string, (Node)object, list, bl);
                ++n;
            }
        }
        object2 = this.getTagName(node);
        NamedNodeMap namedNodeMap = node.getAttributes();
        if (namedNodeMap == null) {
            return;
        }
        n = namedNodeMap.getLength();
        object = this.getEvents((String)object2, DomHelper.lookupNamespaceURI((Node)node));
        if (n == 0 || object.isEmpty()) {
            return;
        }
        int n3 = 0;
        while (n3 < n) {
            List<String> list2;
            String string2;
            Node node2 = namedNodeMap.item(n3);
            String string3 = this.getTagName(node2);
            if (string3 != null && object.contains(string3) && (string2 = node2.getNodeValue()) != null && !(list2 = this.getJavaMethods(structuredTextEditor, string)).contains(string2)) {
                Problem problem = this.createProblem(structuredTextEditor, node, "Java method \"" + string2 + "\" as event of \"" + (String)object2 + "\" not found", 3);
                list.add(problem);
            }
            ++n3;
        }
    }

    private List<String> getJavaMethods(StructuredTextEditor structuredTextEditor, String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        IType iType = this.getJaveType(structuredTextEditor, string);
        if (iType != null) {
            try {
                IMethod[] iMethodArray;
                IMethod[] iMethodArray2 = iMethodArray = iType.getMethods();
                int n = iMethodArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IMethod iMethod = iMethodArray2[n2];
                    arrayList.add(iMethod.getElementName());
                    ++n2;
                }
            }
            catch (JavaModelException javaModelException) {
                return arrayList;
            }
        }
        return arrayList;
    }

    private IType getJaveType(StructuredTextEditor structuredTextEditor, String string) {
        IJavaProject iJavaProject = this.getJavaProject(structuredTextEditor);
        if (iJavaProject != null) {
            try {
                return iJavaProject.findType(string);
            }
            catch (JavaModelException javaModelException) {
                return null;
            }
        }
        return null;
    }

    private List<String> getEvents(String string, String string2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        return arrayList;
    }

    @Override
    public boolean canChecked(StructuredTextEditor structuredTextEditor, String string) {
        return string != null && super.canChecked(structuredTextEditor, string);
    }
}

