/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.ui.editor.checkers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.e4.xwt.ui.editor.checkers.AbstractProblemChecker;
import org.eclipse.e4.xwt.vex.problems.Problem;
import org.eclipse.wst.sse.ui.StructuredTextEditor;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElementNameChecker
extends AbstractProblemChecker {
    @Override
    public List<Problem> checkProblems(StructuredTextEditor structuredTextEditor, String string) {
        ArrayList<Problem> arrayList = new ArrayList<Problem>();
        Node node = this.getRoot(structuredTextEditor);
        this.checkProblems(structuredTextEditor, node, arrayList, new ArrayList<String>());
        return arrayList;
    }

    private void checkProblems(StructuredTextEditor structuredTextEditor, Node node, List<Problem> list, List<String> list2) {
        NamedNodeMap namedNodeMap;
        int n;
        if (!this.isValid(node)) {
            return;
        }
        NodeList nodeList = node.getChildNodes();
        if (nodeList != null) {
            int n2 = nodeList.getLength();
            n = 0;
            while (n < n2) {
                Node node2 = nodeList.item(n);
                this.checkProblems(structuredTextEditor, node2, list, list2);
                ++n;
            }
        }
        if ((namedNodeMap = node.getAttributes()) == null) {
            return;
        }
        n = namedNodeMap.getLength();
        int n3 = 0;
        while (n3 < n) {
            String string;
            Node node3 = namedNodeMap.item(n3);
            String string2 = node3.getNodeName();
            if (string2 != null && "x:Name".equalsIgnoreCase(string2) && (string = node3.getNodeValue()) != null) {
                if (list2.contains(string)) {
                    Problem problem = this.createProblem(structuredTextEditor, node, "Element Name \"" + string + "\" is already used.", 3);
                    list.add(problem);
                } else {
                    list2.add(string);
                }
            }
            ++n3;
        }
    }

    @Override
    protected void checkProblems(StructuredTextEditor structuredTextEditor, String string, Node node, List<Problem> list, boolean bl) {
    }
}

