/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.ui.editor.checkers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.eclipse.e4.xwt.ui.editor.checkers.AbstractProblemChecker;
import org.eclipse.e4.xwt.vex.dom.DomHelper;
import org.eclipse.e4.xwt.vex.problems.Problem;
import org.eclipse.wst.sse.ui.StructuredTextEditor;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElementPropertiesChecker
extends AbstractProblemChecker {
    private static final String XMLNS_TAG = "xmlns";

    @Override
    protected void checkProblems(StructuredTextEditor structuredTextEditor, String string, Node node, List<Problem> list, boolean bl) {
        NamedNodeMap namedNodeMap;
        Object object;
        int n;
        if (!this.isValid(node)) {
            return;
        }
        NodeList nodeList = node.getChildNodes();
        if (bl && nodeList != null) {
            int n2 = nodeList.getLength();
            n = 0;
            while (n < n2) {
                object = nodeList.item(n);
                if (bl) {
                    this.checkProblems(structuredTextEditor, string, (Node)object, list, bl);
                }
                ++n;
            }
        }
        if ((namedNodeMap = node.getAttributes()) == null) {
            return;
        }
        n = namedNodeMap.getLength();
        if (n == 0) {
            return;
        }
        object = this.getTagName(node);
        HashMap<String, List<String>> hashMap = null;
        List list2 = this.getProperties((String)object, DomHelper.lookupNamespaceURI((Node)node), true);
        if (list2 == null) {
            list2 = Collections.EMPTY_LIST;
        }
        int n3 = 0;
        while (n3 < n) {
            Node node2 = namedNodeMap.item(n3);
            String string2 = this.getTagName(node2);
            if (string2 != null && !this.isLoadingTag(string2)) {
                String string3;
                int n4 = string2.indexOf(46);
                if (n4 != -1) {
                    string3 = string2.substring(0, n4);
                    String string4 = string2.substring(n4 + 1);
                    if (hashMap == null) {
                        hashMap = new HashMap<String, List<String>>();
                    }
                    this.collectAttachedProperties(string3, DomHelper.lookupNamespaceURI((Node)node, (Node)node2), hashMap, true);
                    List list3 = hashMap.get(string3);
                    if (list3 == null) {
                        list3 = Collections.EMPTY_LIST;
                    }
                    if (!list3.contains(string4)) {
                        Problem problem = this.createProblem(structuredTextEditor, node, "Attached Property \"" + string4 + "\" of \"" + string3 + "\" doesn't exist", 3);
                        list.add(problem);
                    }
                } else if (!list2.contains(string2)) {
                    string3 = this.createProblem(structuredTextEditor, node, "Property \"" + string2 + "\" of \"" + (String)object + "\" doesn't exist", 3);
                    list.add((Problem)string3);
                }
            }
            ++n3;
        }
    }

    private boolean isLoadingTag(String string) {
        if (string == null || string.equals("")) {
            return false;
        }
        if (string.indexOf(":") != -1) {
            return true;
        }
        return XMLNS_TAG.endsWith(string) || string.startsWith(XMLNS_TAG);
    }

    private List<String> getProperties(String string, String string2, boolean bl) {
        int n = string.indexOf(58);
        string.substring(n + 1);
        ArrayList<String> arrayList = new ArrayList<String>();
        return arrayList;
    }

    private void collectAttachedProperties(String string, String string2, HashMap<String, List<String>> hashMap, boolean bl) {
        if (hashMap.containsKey(string)) {
            return;
        }
    }
}

