/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.ui.editor.checkers;

import java.util.List;
import org.eclipse.e4.xwt.ui.editor.checkers.AbstractProblemChecker;
import org.eclipse.e4.xwt.vex.problems.Problem;
import org.eclipse.wst.sse.ui.StructuredTextEditor;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntegerPropertyChecker
extends AbstractProblemChecker {
    @Override
    protected void checkProblems(StructuredTextEditor structuredTextEditor, String string, Node node, List<Problem> list, boolean bl) {
        if (!this.isValid(node)) {
            return;
        }
        NodeList nodeList = node.getChildNodes();
        if (bl && nodeList != null) {
            int n = nodeList.getLength();
            int n2 = 0;
            while (n2 < n) {
                Node node2 = nodeList.item(n2);
                this.checkProblems(structuredTextEditor, string, node2, list, bl);
                ++n2;
            }
        }
        String string2 = this.getTagName(node);
        NamedNodeMap namedNodeMap = node.getAttributes();
        if (namedNodeMap == null) {
            return;
        }
        int n = namedNodeMap.getLength();
        int n3 = 0;
        while (n3 < n) {
            boolean bl2;
            Node node3 = namedNodeMap.item(n3);
            String string3 = this.getTagName(node3);
            if (string3 != null && (bl2 = this.isInteger(node, string3))) {
                Problem problem;
                String string4 = node3.getNodeValue();
                double d = -1.0;
                try {
                    d = Integer.parseInt(string4);
                }
                catch (NumberFormatException numberFormatException) {
                    problem = this.createProblem(structuredTextEditor, node, "Error Integer Format for Property \"" + string3 + "\" of \"" + string2 + "\".", 3);
                    list.add(problem);
                }
                if (d <= 0.0) {
                    if (string3.equals("ColumnSpan")) {
                        problem = this.createProblem(structuredTextEditor, node, "\"ColumnSpan\" must more than 0.", 3);
                        list.add(problem);
                    } else if (string3.equals("RowSpan")) {
                        problem = this.createProblem(structuredTextEditor, node, "\"RowSpan\" must more than 0.", 3);
                        list.add(problem);
                    }
                }
            }
            ++n3;
        }
    }

    private boolean isInteger(Node node, String string) {
        String string2 = this.getTagName(node);
        if (string2 == null) {
            return false;
        }
        return false;
    }
}

