/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.ui.editor.jdt;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.util.CodeFormatterUtil;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.Strings;
import org.eclipse.jdt.ui.CodeGeneration;
import org.eclipse.jdt.ui.CodeStyleConfiguration;
import org.eclipse.text.edits.TextEdit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ASTHelper {
    public static void generateEventHandler(final IType iType, final String string, final String string2) throws Exception {
        ASTHelper aSTHelper = new ASTHelper();
        Runnable runnable = new Runnable(){

            public void run() {
                try {
                    ASTHelper.this.createEventHandlers(iType, string2, string);
                }
                catch (CoreException coreException) {}
            }
        };
        aSTHelper.generateTypeMembers(iType, string, true, runnable);
    }

    public static void generateInitialization(final IType iType, final String string, final Set<String> set) throws Exception {
        ASTHelper aSTHelper = new ASTHelper();
        Runnable runnable = new Runnable(){

            public void run() {
                try {
                    ASTHelper.this.createInitializeMembers(iType, string, set);
                }
                catch (CoreException coreException) {}
            }
        };
        aSTHelper.generateTypeMembers(iType, null, true, runnable);
    }

    public void generateTypeMembers(IType iType, String string, boolean bl, Runnable runnable) throws Exception {
        int n = 0;
        NullProgressMonitor nullProgressMonitor = new NullProgressMonitor();
        String string2 = StubUtility.getLineDelimiterUsed((IJavaProject)iType.getJavaProject());
        ICompilationUnit iCompilationUnit = iType.getCompilationUnit();
        iCompilationUnit.becomeWorkingCopy((IProgressMonitor)nullProgressMonitor);
        CompilationUnit compilationUnit = this.createASTForImports(iCompilationUnit);
        Set set = this.getExistingImports(compilationUnit);
        ImportsManager importsManager = new ImportsManager(compilationUnit);
        if (string != null) {
            importsManager.addImport(string);
        }
        runnable.run();
        importsManager.create(false, (IProgressMonitor)nullProgressMonitor);
        this.removeUnusedImports(iCompilationUnit, set, false);
        JavaModelUtil.reconcile((ICompilationUnit)iCompilationUnit);
        ISourceRange iSourceRange = iType.getSourceRange();
        IBuffer iBuffer = iCompilationUnit.getBuffer();
        String string3 = iBuffer.getText(iSourceRange.getOffset(), iSourceRange.getLength());
        String string4 = CodeFormatterUtil.format((int)4, (String)string3, (int)n, (String)string2, (IJavaProject)iType.getJavaProject());
        string4 = Strings.trimLeadingTabsAndSpaces((String)string4);
        iBuffer.replace(iSourceRange.getOffset(), iSourceRange.getLength(), string4);
        if (bl) {
            iCompilationUnit.commitWorkingCopy(true, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)nullProgressMonitor, 1));
        } else {
            nullProgressMonitor.worked(1);
        }
    }

    private CompilationUnit createASTForImports(ICompilationUnit iCompilationUnit) {
        ASTParser aSTParser = ASTParser.newParser((int)3);
        aSTParser.setSource(iCompilationUnit);
        aSTParser.setResolveBindings(false);
        aSTParser.setFocalPosition(0);
        return (CompilationUnit)aSTParser.createAST(null);
    }

    private Set getExistingImports(CompilationUnit compilationUnit) {
        List list = compilationUnit.imports();
        HashSet<String> hashSet = new HashSet<String>(list.size());
        int n = 0;
        while (n < list.size()) {
            hashSet.add(ASTNodes.asString((ASTNode)((ImportDeclaration)list.get(n))));
            ++n;
        }
        return hashSet;
    }

    public static void removeUnusedImports(IType iType) {
        try {
            ASTHelper aSTHelper = new ASTHelper();
            ICompilationUnit iCompilationUnit = iType.getCompilationUnit();
            CompilationUnit compilationUnit = aSTHelper.createASTForImports(iCompilationUnit);
            Set set = aSTHelper.getExistingImports(compilationUnit);
            aSTHelper.removeUnusedImports(iCompilationUnit, set, true);
        }
        catch (CoreException coreException) {}
    }

    private void removeUnusedImports(ICompilationUnit iCompilationUnit, Set set, boolean bl) throws CoreException {
        ASTParser aSTParser = ASTParser.newParser((int)3);
        aSTParser.setSource(iCompilationUnit);
        aSTParser.setResolveBindings(true);
        CompilationUnit compilationUnit = (CompilationUnit)aSTParser.createAST(null);
        if (compilationUnit.getProblems().length == 0) {
            return;
        }
        List list = compilationUnit.imports();
        if (list.isEmpty()) {
            return;
        }
        ImportsManager importsManager = new ImportsManager(compilationUnit);
        int n = ASTNodes.getExclusiveEnd((ASTNode)((ASTNode)list.get(list.size() - 1)));
        IProblem[] iProblemArray = compilationUnit.getProblems();
        int n2 = 0;
        while (n2 < iProblemArray.length) {
            int n3;
            IProblem iProblem = iProblemArray[n2];
            if (iProblem.getSourceEnd() < n && ((n3 = iProblem.getID()) == 268435844 || n3 == 0x1000003)) {
                int n4 = iProblem.getSourceStart();
                int n5 = 0;
                while (n5 < list.size()) {
                    ImportDeclaration importDeclaration = (ImportDeclaration)list.get(n5);
                    if (importDeclaration.getStartPosition() <= n4 && n4 < importDeclaration.getStartPosition() + importDeclaration.getLength()) {
                        if (!set.isEmpty() && set.contains(ASTNodes.asString((ASTNode)importDeclaration))) break;
                        String string = importDeclaration.getName().getFullyQualifiedName();
                        if (importDeclaration.isOnDemand()) {
                            string = String.valueOf(string) + ".*";
                        }
                        if (importDeclaration.isStatic()) {
                            importsManager.removeStaticImport(string);
                            break;
                        }
                        importsManager.removeImport(string);
                        break;
                    }
                    ++n5;
                }
            }
            ++n2;
        }
        importsManager.create(bl, null);
    }

    protected void createEventHandlers(IType iType, String string, String string2) throws CoreException {
        int n = string2.lastIndexOf(".");
        String string3 = string2.substring(n + 1);
        StringBuffer stringBuffer = new StringBuffer();
        String string4 = CodeGeneration.getMethodComment((ICompilationUnit)iType.getCompilationUnit(), (String)iType.getTypeQualifiedName('.'), (String)string, (String[])new String[]{"event"}, (String[])new String[0], (String)Signature.createTypeSignature((String)"void", (boolean)true), null, (String)"\n");
        if (string4 != null) {
            stringBuffer.append(string4);
            stringBuffer.append("\n");
        }
        stringBuffer.append("public void " + string + "( ");
        stringBuffer.append(string3);
        stringBuffer.append(" event) {");
        stringBuffer.append("\n");
        String string5 = CodeGeneration.getMethodBodyContent((ICompilationUnit)iType.getCompilationUnit(), (String)iType.getTypeQualifiedName('.'), (String)string, (boolean)false, (String)"", (String)"\n");
        if (string5 != null && string5.length() != 0) {
            stringBuffer.append(string5);
        }
        stringBuffer.append("\n");
        stringBuffer.append("}");
        iType.createMethod(stringBuffer.toString(), null, false, null);
    }

    protected void createInitializeMembers(IType iType, String string, Set<String> set) throws CoreException {
        String string2;
        Object object;
        Object object2 = null;
        IMethod[] iMethodArray = iType.getMethods();
        IMethod[] iMethodArray2 = iMethodArray;
        int n = iMethodArray.length;
        int n2 = 0;
        while (n2 < n) {
            object = iMethodArray2[n2];
            if (object.getElementName().equals(string)) {
                object2 = object;
                break;
            }
            ++n2;
        }
        if (object2 != null) {
            object2.delete(false, null);
        }
        object = new StringBuffer();
        String string3 = "/**\n  * Generated Initialization.\n */";
        if (string3 != null) {
            ((StringBuffer)object).append(string3);
            ((StringBuffer)object).append("\n");
        }
        ((StringBuffer)object).append("protected void " + string + " () {");
        ((StringBuffer)object).append("\n");
        if (set.isEmpty() && (string2 = CodeGeneration.getMethodBodyContent((ICompilationUnit)iType.getCompilationUnit(), (String)iType.getTypeQualifiedName('.'), (String)string, (boolean)false, (String)"", (String)"\n")) != null && string2.length() != 0) {
            ((StringBuffer)object).append(string2);
        }
        for (String string4 : set) {
            IField iField = iType.getField(string4);
            if (iField == null) continue;
            String string5 = String.valueOf(string4) + " = (" + Signature.toString((String)iField.getTypeSignature()) + ") findElement(\"" + string4 + "\");";
            ((StringBuffer)object).append(string5);
        }
        ((StringBuffer)object).append("\n");
        ((StringBuffer)object).append("}");
        iType.createMethod(((StringBuffer)object).toString(), null, false, null);
    }

    public static void generateNamedFields(IType iType, String string, String string2) {
        try {
            ASTHelper aSTHelper = new ASTHelper();
            aSTHelper.createNamedFields(iType, string, string2, true);
        }
        catch (Exception exception) {}
    }

    public void createNamedFields(IType iType, String string, String string2, boolean bl) throws Exception {
        if (string == null || string2 == null) {
            return;
        }
        NullProgressMonitor nullProgressMonitor = new NullProgressMonitor();
        String string3 = StubUtility.getLineDelimiterUsed((IJavaProject)iType.getJavaProject());
        ICompilationUnit iCompilationUnit = iType.getCompilationUnit();
        iCompilationUnit.becomeWorkingCopy((IProgressMonitor)nullProgressMonitor);
        CompilationUnit compilationUnit = this.createASTForImports(iCompilationUnit);
        Set set = this.getExistingImports(compilationUnit);
        ImportsManager importsManager = new ImportsManager(compilationUnit);
        importsManager.addImport(string);
        this.createField(iType, string, string2);
        importsManager.create(false, (IProgressMonitor)nullProgressMonitor);
        this.removeUnusedImports(iCompilationUnit, set, false);
        JavaModelUtil.reconcile((ICompilationUnit)iCompilationUnit);
        ISourceRange iSourceRange = iType.getSourceRange();
        IBuffer iBuffer = iCompilationUnit.getBuffer();
        String string4 = iBuffer.getText(iSourceRange.getOffset(), iSourceRange.getLength());
        String string5 = CodeFormatterUtil.format((int)4, (String)string4, (int)0, (String)string3, (IJavaProject)iType.getJavaProject());
        string5 = Strings.trimLeadingTabsAndSpaces((String)string5);
        iBuffer.replace(iSourceRange.getOffset(), iSourceRange.getLength(), string5);
        if (bl) {
            iCompilationUnit.commitWorkingCopy(true, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)nullProgressMonitor, 1));
        } else {
            nullProgressMonitor.worked(1);
        }
    }

    private void createField(IType iType, String string, String string2) throws Exception {
        int n = string.lastIndexOf(".");
        String string3 = string.substring(n + 1);
        if (string3 == null || string3.equals("")) {
            string3 = string;
        }
        String string4 = "protected " + string3 + " " + string2 + ";";
        iType.createField(string4, null, false, null);
    }

    public static class ImportsManager {
        private ImportRewrite fImportsRewrite;

        ImportsManager(CompilationUnit compilationUnit) throws CoreException {
            this.fImportsRewrite = CodeStyleConfiguration.createImportRewrite((CompilationUnit)compilationUnit, (boolean)true);
        }

        ICompilationUnit getCompilationUnit() {
            return this.fImportsRewrite.getCompilationUnit();
        }

        public String addImport(String string) {
            return this.fImportsRewrite.addImport(string);
        }

        public String addImport(ITypeBinding iTypeBinding) {
            return this.fImportsRewrite.addImport(iTypeBinding);
        }

        public String addStaticImport(String string, String string2, boolean bl) {
            return this.fImportsRewrite.addStaticImport(string, string2, bl);
        }

        void create(boolean bl, IProgressMonitor iProgressMonitor) throws CoreException {
            TextEdit textEdit = this.fImportsRewrite.rewriteImports(iProgressMonitor);
            JavaModelUtil.applyEdit((ICompilationUnit)this.fImportsRewrite.getCompilationUnit(), (TextEdit)textEdit, (boolean)bl, null);
        }

        void removeImport(String string) {
            this.fImportsRewrite.removeImport(string);
        }

        void removeStaticImport(String string) {
            this.fImportsRewrite.removeStaticImport(string);
        }
    }
}

